/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.manifest;

import com.android.aapt.Resources;
import com.android.tools.build.bundletool.exceptions.ValidationException;
import com.android.tools.build.bundletool.manifest.AndroidManifest;
import com.android.tools.build.bundletool.manifest.AutoValue_ProtoManifest;
import com.android.tools.build.bundletool.manifest.ManifestEditor;
import com.android.tools.build.bundletool.manifest.ProtoManifestEditor;
import com.android.tools.build.bundletool.manifest.ProtoXmlHelper;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Optional;

@AutoValue
public abstract class ProtoManifest
implements AndroidManifest {
    abstract Resources.XmlNode getManifestRoot();

    public static ProtoManifest create(Resources.XmlNode manifestRoot) {
        return new AutoValue_ProtoManifest(manifestRoot);
    }

    @Override
    public byte[] getContent() {
        return this.getManifestRoot().toByteArray();
    }

    @Override
    public Optional<String> getSplitId() {
        Resources.XmlElement manifest = ProtoXmlHelper.getExactlyOneElement(this.getManifestRoot(), "manifest");
        return ProtoXmlHelper.findAttributeWithName(manifest, "split").map(Resources.XmlAttribute::getValue);
    }

    @Override
    public Collection<String> getUsesSplits() {
        return (Collection)ProtoXmlHelper.findElements(this.getManifestRoot(), "uses-split").map(elem -> ProtoXmlHelper.findAttribute(elem, "http://schemas.android.com/apk/res/android", "name").orElseThrow(() -> new ValidationException("<uses-split> element is missing the android:name attribute", new Object[0]))).map(Resources.XmlAttribute::getValue).collect(ImmutableList.toImmutableList());
    }

    @Override
    public boolean isDynamicModule() {
        Resources.XmlElement manifest = ProtoXmlHelper.getExactlyOneElement(this.getManifestRoot(), "manifest");
        Optional<Resources.XmlAttribute> dynamicNode = ProtoXmlHelper.findAttributeWithName(manifest, "dynamic");
        if (!dynamicNode.isPresent()) {
            return false;
        }
        return ProtoXmlHelper.getAttributeValueAsBoolean(dynamicNode.get());
    }

    @Override
    public ManifestEditor toEditor() {
        return new ProtoManifestEditor(this.getManifestRoot());
    }

    public boolean equals(Object other) {
        if (other instanceof ProtoManifest) {
            return ((ProtoManifest)other).getManifestRoot().equals((Object)this.getManifestRoot());
        }
        return false;
    }

    public int hashCode() {
        return this.getManifestRoot().hashCode();
    }
}

