/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool;

import com.android.bundle.SplitsOuterClass;
import com.android.tools.build.bundletool.AutoValue_SplitModuleCommand;
import com.android.tools.build.bundletool.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.BundleModuleName;
import com.android.tools.build.bundletool.model.ModuleSplitOnDisk;
import com.android.tools.build.bundletool.splitters.ModuleSplitter;
import com.android.tools.build.bundletool.utils.files.FilePreconditions;
import com.android.tools.build.bundletool.utils.files.FileUtils;
import com.android.tools.build.bundletool.utils.flags.Flag;
import com.android.tools.build.bundletool.utils.flags.ParsedFlags;
import com.android.tools.build.bundletool.validation.AppBundleValidator;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.zip.ZipException;

@AutoValue
public abstract class SplitModuleCommand {
    public static final String COMMAND_NAME = "split-module";
    private static final Flag<Path> BUNDLE_LOCATION_FLAG = Flag.path("bundle");
    private static final Flag<Path> OUTPUT_DIRECTORY_FLAG = Flag.path("output");
    private static final Flag<ImmutableList<String>> MODULE_FLAG = Flag.strings("modules");
    private static final Flag<ImmutableList<ModuleSplitter.SplittingDimension>> SPLIT_BY_FLAG = Flag.enums("split-by", ModuleSplitter.SplittingDimension.class);

    public abstract Path getBundlePath();

    public abstract Path getOutputDirectory();

    public abstract ImmutableList<BundleModuleName> getModuleNames();

    public abstract ImmutableList<ModuleSplitter.SplittingDimension> getSplittingDimensions();

    public static Builder builder() {
        return new AutoValue_SplitModuleCommand.Builder().setSplittingDimensions((ImmutableList<ModuleSplitter.SplittingDimension>)ImmutableList.of());
    }

    public static SplitModuleCommand fromFlags(ParsedFlags flags) {
        Builder builder = SplitModuleCommand.builder().setBundlePath(BUNDLE_LOCATION_FLAG.getRequiredValue(flags)).setOutputDirectory(OUTPUT_DIRECTORY_FLAG.getRequiredValue(flags)).setModuleNames((ImmutableList<BundleModuleName>)((ImmutableList)MODULE_FLAG.getRequiredValue(flags).stream().map(BundleModuleName::create).collect(ImmutableList.toImmutableList()))).setSplittingDimensions(SPLIT_BY_FLAG.value(flags).orElse((ImmutableList<ModuleSplitter.SplittingDimension>)ImmutableList.of()));
        flags.checkNoUnknownFlags();
        return builder.build();
    }

    public List<ModuleSplitOnDisk> execute() throws CommandExecutionException {
        AppBundle appBundle;
        this.validateInput();
        try {
            appBundle = new AppBundleValidator().validate(this.getBundlePath());
        }
        catch (ZipException e) {
            throw new CommandExecutionException(e, "Zip error while opening the bundle", new Object[0]);
        }
        catch (FileNotFoundException e) {
            throw new CommandExecutionException(e, "Bundle file not found", new Object[0]);
        }
        catch (IOException e) {
            throw new CommandExecutionException(e, "I/O error while processing the bundle", new Object[0]);
        }
        SplitsOuterClass.Splits.Builder splitsBuilder = SplitsOuterClass.Splits.newBuilder();
        ImmutableList.Builder allSplits = new ImmutableList.Builder();
        for (BundleModuleName moduleName : this.getModuleNames()) {
            BundleModule module = appBundle.getModule(moduleName).orElseThrow(() -> new CommandExecutionException("Cannot find module '%s' in the bundle", moduleName));
            ImmutableList<ModuleSplitOnDisk> moduleSplits = new ModuleSplitter(module, this.getSplittingDimensions()).splitModule(this.getOutputDirectory());
            splitsBuilder.addModuleSplits(SplitModuleCommand.toModuleSplits(moduleSplits, module));
            allSplits.addAll(moduleSplits);
        }
        this.writeSplitInformation(splitsBuilder.build());
        return allSplits.build();
    }

    private void validateInput() {
        FilePreconditions.checkFileExistsAndReadable(this.getBundlePath());
        FilePreconditions.checkDirectoryExists(this.getOutputDirectory());
    }

    private static SplitsOuterClass.ModuleSplits toModuleSplits(List<ModuleSplitOnDisk> splits, BundleModule module) {
        SplitsOuterClass.ModuleSplits.Builder builder = SplitsOuterClass.ModuleSplits.newBuilder().setName(module.getName().getName()).setModuleMetadata(SplitsOuterClass.ModuleMetadata.newBuilder().setIsDynamic(module.getManifest().isDynamicModule()));
        for (ModuleSplitOnDisk split : splits) {
            builder.addSplit(SplitsOuterClass.SplitDescription.newBuilder().setPath(split.getPath().toString()).setTargeting(split.getModuleSplit().getTargeting()).build());
        }
        return builder.build();
    }

    private void writeSplitInformation(SplitsOuterClass.Splits splits) {
        Path splitInfoFile = this.getOutputDirectory().resolve(FileUtils.getBaseFileName(this.getBundlePath()) + "-splits.pb.json");
        try {
            Files.write(splitInfoFile, JsonFormat.printer().print((MessageOrBuilder)splits).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new CommandExecutionException(e, "Error while writing to the split info file to '%s'", splitInfoFile);
        }
    }

    public static void help() {
        System.out.printf("bundletool %s --%s=<bundle.zip> --%s=<module-name> --%s=<output-dir> [--%s=%s]\n", COMMAND_NAME, BUNDLE_LOCATION_FLAG, MODULE_FLAG, OUTPUT_DIRECTORY_FLAG, SPLIT_BY_FLAG, ModuleSplitter.SplittingDimension.getValues("|"));
        System.out.println("Generates module splits for the given set of bundle modules.");
        System.out.println("The command outputs [budle-name]-splits.pb.json file with the information");
        System.out.println("about the generated files.");
        System.out.println();
        System.out.printf("--%s: the zip file containing an App Bundle.\n", BUNDLE_LOCATION_FLAG);
        System.out.printf("--%s: modules for which generate the splits.\n", MODULE_FLAG);
        System.out.printf("--%s: the directory where the split zip files and the json file should be written to.\n", OUTPUT_DIRECTORY_FLAG);
        System.out.printf("--%s: if set will generate configuration APKs for the given dimensions.\n", SPLIT_BY_FLAG);
    }

    public static abstract class Builder {
        public abstract Builder setBundlePath(Path var1);

        public abstract Builder setOutputDirectory(Path var1);

        public abstract Builder setModuleNames(ImmutableList<BundleModuleName> var1);

        public abstract Builder setSplittingDimensions(ImmutableList<ModuleSplitter.SplittingDimension> var1);

        public abstract SplitModuleCommand build();
    }
}

