/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool;

import com.android.bundle.Files;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.AutoValue_BuildBundleCommand;
import com.android.tools.build.bundletool.converter.TargetingXmlToProtoConverter;
import com.android.tools.build.bundletool.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.utils.files.FilePreconditions;
import com.android.tools.build.bundletool.utils.files.TargetingGenerator;
import com.android.tools.build.bundletool.utils.flags.Flag;
import com.android.tools.build.bundletool.utils.flags.ParsedFlags;
import com.android.tools.build.bundletool.utils.zip.OutputBuilder;
import com.android.tools.build.bundletool.utils.zip.ZipBuilder;
import com.android.tools.build.bundletool.utils.zip.ZipUtils;
import com.android.tools.build.bundletool.validation.BundleModulesValidator;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.io.MoreFiles;
import com.google.protobuf.MessageLite;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Optional;
import java.util.zip.ZipFile;

@AutoValue
public abstract class BuildBundleCommand {
    public static final String COMMAND_NAME = "build-bundle";
    private static final Flag<Path> OUTPUT_FLAG = Flag.path("output");
    private static final Flag<ImmutableList<Path>> MODULES_FLAG = Flag.paths("modules");
    private static final Flag<Path> TARGETING_XML_FLAG = Flag.path("targeting");

    public abstract Path getOutputPath();

    public abstract ImmutableList<Path> getModulesPaths();

    public abstract Optional<Path> getTargetingXmlPath();

    public static Builder builder() {
        return new AutoValue_BuildBundleCommand.Builder();
    }

    public static BuildBundleCommand fromFlags(ParsedFlags flags) {
        Builder builder = BuildBundleCommand.builder().setOutputPath(OUTPUT_FLAG.getRequiredValue(flags)).setModulesPaths(MODULES_FLAG.getRequiredValue(flags));
        TARGETING_XML_FLAG.value(flags).ifPresent(builder::setTargetingXmlPath);
        flags.checkNoUnknownFlags();
        return builder.build();
    }

    public void execute() {
        this.validateInput();
        try {
            ZipBuilder bundleBuilder = new ZipBuilder();
            ImmutableList<Targeting.TargetingQualifier> customTargeting = this.parseTargetingXml();
            for (Path module : this.getModulesPaths()) {
                Optional<Files.Assets> assetsTargeting;
                String moduleDir = MoreFiles.getNameWithoutExtension((Path)module) + "/";
                ZipFile moduleZipFile = new ZipFile(module.toFile());
                bundleBuilder.copyAllContentsFromZip(new ZipFile(module.toFile()), moduleDir);
                Optional<Files.NativeLibraries> nativeLibrariesTargeting = this.generateNativeLibrariesTargeting(moduleZipFile, customTargeting);
                if (nativeLibrariesTargeting.isPresent()) {
                    bundleBuilder.addFileWithProtoContent(moduleDir + "native.pb", (MessageLite)nativeLibrariesTargeting.get());
                }
                if (!(assetsTargeting = this.generateAssetsTargeting(moduleZipFile, customTargeting)).isPresent()) continue;
                bundleBuilder.addFileWithProtoContent(moduleDir + "assets.pb", (MessageLite)assetsTargeting.get());
            }
            bundleBuilder.addFileWithContent("VERSION", String.valueOf(1).getBytes(StandardCharsets.UTF_8));
            ((OutputBuilder)bundleBuilder).writeTo(this.getOutputPath());
        }
        catch (IOException e) {
            throw new CommandExecutionException(e, "Error building the bundle: %s", e);
        }
    }

    private void validateInput() {
        FilePreconditions.checkFileDoesNotExist(this.getOutputPath());
        this.getTargetingXmlPath().ifPresent(targetingXmlPath -> {
            FilePreconditions.checkFileHasExtension("Targeting file", targetingXmlPath, ".xml");
            FilePreconditions.checkFileExistsAndReadable(targetingXmlPath);
        });
        new BundleModulesValidator().validate(this.getModulesPaths());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ImmutableList<Targeting.TargetingQualifier> parseTargetingXml() {
        if (!this.getTargetingXmlPath().isPresent()) {
            return ImmutableList.of();
        }
        try (FileInputStream xmlStream = new FileInputStream(this.getTargetingXmlPath().get().toFile());){
            ImmutableList<Targeting.TargetingQualifier> immutableList = new TargetingXmlToProtoConverter().convert(xmlStream);
            return immutableList;
        }
        catch (IOException e) {
            throw new CommandExecutionException(e, "Failed to parse the targeting.xml.", new Object[0]);
        }
    }

    private Optional<Files.Assets> generateAssetsTargeting(ZipFile module, ImmutableList<Targeting.TargetingQualifier> customTargeting) {
        ImmutableList<Path> assetFiles = ZipUtils.getFilesWithPathPrefix(module, Paths.get("assets", new String[0]));
        ImmutableList targetedAssetsSubDirs = (ImmutableList)BuildBundleCommand.distinctRootSubDirectories(assetFiles).stream().filter(dirPath -> dirPath.contains("$")).collect(ImmutableList.toImmutableList());
        if (targetedAssetsSubDirs.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new TargetingGenerator((Collection<Targeting.TargetingQualifier>)customTargeting).generateTargetingForAssets((Collection<String>)targetedAssetsSubDirs));
    }

    private Optional<Files.NativeLibraries> generateNativeLibrariesTargeting(ZipFile module, ImmutableList<Targeting.TargetingQualifier> customTargeting) {
        ImmutableList<Path> libFiles = ZipUtils.getFilesWithPathPrefix(module, Paths.get("lib", new String[0]));
        ImmutableList<String> libAbiDirs = BuildBundleCommand.distinctRootSubDirectories(libFiles);
        if (libAbiDirs.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new TargetingGenerator((Collection<Targeting.TargetingQualifier>)customTargeting).generateTargetingForNativeLibraries((Collection<String>)libAbiDirs));
    }

    private static ImmutableList<String> distinctRootSubDirectories(ImmutableList<Path> files) {
        return (ImmutableList)files.stream().filter(path -> path.getNameCount() > 2).map(path -> path.subpath(0, 2)).map(Path::toString).distinct().collect(ImmutableList.toImmutableList());
    }

    public static void help() {
        System.out.printf("bundletool %s --%s=<path/to/bundle.zip> --%s=<path/to/module1.zip,path/to/module2.zip,...> [--%s=<path/to/targeting.xml>]\n", COMMAND_NAME, OUTPUT_FLAG, MODULES_FLAG, TARGETING_XML_FLAG);
        System.out.println();
        System.out.printf("Builds a bundle as a zip from a set of modules. Note that the resources and the AndroidManifest.xml must already have been compiled with aapt2 and the module created with the bundletool.\n", new Object[0]);
        System.out.printf("--output: Path to the zip file to build.\n", new Object[0]);
        System.out.printf("--%s: The list of module files to build the final bundle from.\n", MODULES_FLAG);
        System.out.printf("--%s: Path to the targeting.xml.\n", TARGETING_XML_FLAG);
    }

    public static abstract class Builder {
        public abstract Builder setOutputPath(Path var1);

        public abstract Builder setModulesPaths(ImmutableList<Path> var1);

        public abstract Builder setTargetingXmlPath(Path var1);

        public abstract BuildBundleCommand build();
    }
}

