/*
 * Decompiled with CFR 0.152.
 */
package com.android.apkzlib.zfile;

import com.android.apkzlib.zfile.ApkCreator;
import com.android.apkzlib.zfile.NativeLibrariesPackagingMode;
import com.google.common.base.Preconditions;
import java.io.File;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface ApkCreatorFactory {
    public ApkCreator make(@Nonnull CreationData var1);

    public static class CreationData {
        @Nonnull
        private final File mApkPath;
        @Nullable
        private final PrivateKey mKey;
        @Nullable
        private final X509Certificate mCertificate;
        private final boolean mV1SigningEnabled;
        private final boolean mV2SigningEnabled;
        @Nullable
        private final String mBuiltBy;
        @Nullable
        private final String mCreatedBy;
        private final int mMinSdkVersion;
        @Nonnull
        private final NativeLibrariesPackagingMode mNativeLibrariesPackagingMode;
        @Nonnull
        private final Predicate<String> mNoCompressPredicate;

        public CreationData(@Nonnull File apkPath, @Nullable PrivateKey key, @Nullable X509Certificate certificate, boolean v1SigningEnabled, boolean v2SigningEnabled, @Nullable String builtBy, @Nullable String createdBy, int minSdkVersion, @Nonnull NativeLibrariesPackagingMode nativeLibrariesPackagingMode, @Nonnull Predicate<String> noCompressPredicate) {
            Preconditions.checkArgument((key == null == (certificate == null) ? 1 : 0) != 0, (Object)"(key == null) != (certificate == null)");
            Preconditions.checkArgument((minSdkVersion >= 0 ? 1 : 0) != 0, (Object)"minSdkVersion < 0");
            this.mApkPath = apkPath;
            this.mKey = key;
            this.mCertificate = certificate;
            this.mV1SigningEnabled = v1SigningEnabled;
            this.mV2SigningEnabled = v2SigningEnabled;
            this.mBuiltBy = builtBy;
            this.mCreatedBy = createdBy;
            this.mMinSdkVersion = minSdkVersion;
            this.mNativeLibrariesPackagingMode = (NativeLibrariesPackagingMode)((Object)Preconditions.checkNotNull((Object)((Object)nativeLibrariesPackagingMode)));
            this.mNoCompressPredicate = (Predicate)Preconditions.checkNotNull(noCompressPredicate);
        }

        @Nonnull
        public File getApkPath() {
            return this.mApkPath;
        }

        @Nullable
        public PrivateKey getPrivateKey() {
            return this.mKey;
        }

        @Nullable
        public X509Certificate getCertificate() {
            return this.mCertificate;
        }

        public boolean isV1SigningEnabled() {
            return this.mV1SigningEnabled;
        }

        public boolean isV2SigningEnabled() {
            return this.mV2SigningEnabled;
        }

        @Nullable
        public String getBuiltBy() {
            return this.mBuiltBy;
        }

        @Nullable
        public String getCreatedBy() {
            return this.mCreatedBy;
        }

        public int getMinSdkVersion() {
            return this.mMinSdkVersion;
        }

        @Nonnull
        public NativeLibrariesPackagingMode getNativeLibrariesPackagingMode() {
            return this.mNativeLibrariesPackagingMode;
        }

        @Nonnull
        public Predicate<String> getNoCompressPredicate() {
            return this.mNoCompressPredicate;
        }
    }
}

