/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.utils;

import com.android.builder.internal.utils.IOExceptionFunction;
import com.android.builder.internal.utils.ProcessLock;
import com.android.utils.FileUtils;
import com.google.common.base.MoreObjects;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;

public class FileCache {
    public static final FileCache NO_CACHE = new FileCache(new File("")){

        @Override
        public boolean getOrCreateFile(File outputFile, String fileKey, IOExceptionFunction<File, Void> fileProducer) throws IOException {
            fileProducer.apply(outputFile);
            return outputFile.exists();
        }
    };
    private final File mCacheDirectory;
    private final boolean mInterProcessLocking;
    private final AtomicInteger mMisses = new AtomicInteger(0);
    private final AtomicInteger mHits = new AtomicInteger(0);

    public FileCache(File cacheDirectory, boolean interProcessLocking) {
        this.mCacheDirectory = cacheDirectory;
        this.mInterProcessLocking = interProcessLocking;
    }

    public FileCache(File cacheDirectory) {
        this(cacheDirectory, false);
    }

    public boolean getOrCreateFile(File outputFile, String fileKey, IOExceptionFunction<File, Void> fileProducer) throws IOException {
        File cachedFile = new File(this.mCacheDirectory, FileUtils.getValidFileName((String)fileKey, (String)"", (File)this.mCacheDirectory));
        ProcessLock.doLocked(cachedFile.getCanonicalPath(), () -> {
            if (!cachedFile.exists()) {
                this.mMisses.incrementAndGet();
                Files.createParentDirs((File)cachedFile);
                File tmpFile = new File(this.mCacheDirectory, FileUtils.getValidFileName((String)cachedFile.getName(), (String)Files.getFileExtension((String)outputFile.getName()), (File)this.mCacheDirectory));
                fileProducer.apply(tmpFile);
                if (tmpFile.exists() && !tmpFile.equals(cachedFile)) {
                    Files.move((File)tmpFile, (File)cachedFile);
                }
            } else {
                this.mHits.incrementAndGet();
            }
        }, this.mInterProcessLocking);
        if (cachedFile.exists()) {
            ProcessLock.doLocked(outputFile.getCanonicalPath(), () -> FileCache.copyFileOrDirectory(cachedFile, outputFile), this.mInterProcessLocking);
            return true;
        }
        return false;
    }

    private static void copyFileOrDirectory(File from, File to) throws IOException {
        if (from.isFile()) {
            FileUtils.mkdirs((File)to.getParentFile());
            FileUtils.copyFile((File)from, (File)to);
        } else if (from.isDirectory()) {
            FileUtils.deletePath((File)to);
            FileUtils.copyDirectory((File)from, (File)to);
        }
    }

    int getMisses() {
        return this.mMisses.get();
    }

    int getHits() {
        return this.mHits.get();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("cacheDirectory", (Object)this.mCacheDirectory).add("interProcessLocking", this.mInterProcessLocking).toString();
    }
}

