/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.core;

import com.android.builder.core.DexOptions;
import com.android.ide.common.process.JavaProcessInfo;
import com.android.ide.common.process.ProcessEnvBuilder;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.repository.Revision;
import com.android.sdklib.BuildToolInfo;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

public class DexProcessBuilder
extends ProcessEnvBuilder<DexProcessBuilder> {
    public static final Revision MIN_MULTIDEX_BUILD_TOOLS_REV = new Revision(21, 0, 0);
    public static final Revision MIN_MULTI_THREADED_DEX_BUILD_TOOLS_REV = new Revision(22, 0, 2);
    public static final Revision FIXED_DX_MERGER = new Revision(23, 0, 2);
    private final File mOutputFile;
    private boolean mVerbose = false;
    private boolean mNoOptimize = false;
    private boolean mMultiDex = false;
    private File mMainDexList = null;
    private Set<File> mInputs = Sets.newHashSet();

    public DexProcessBuilder(File outputFile) {
        this.mOutputFile = outputFile;
    }

    public DexProcessBuilder setVerbose(boolean verbose) {
        this.mVerbose = verbose;
        return this;
    }

    public DexProcessBuilder setNoOptimize(boolean noOptimize) {
        this.mNoOptimize = noOptimize;
        return this;
    }

    public DexProcessBuilder setMultiDex(boolean multiDex) {
        this.mMultiDex = multiDex;
        return this;
    }

    public DexProcessBuilder setMainDexList(File mainDexList) {
        this.mMainDexList = mainDexList;
        return this;
    }

    public DexProcessBuilder addInput(File input) {
        this.mInputs.add(input);
        return this;
    }

    public DexProcessBuilder addInputs(Collection<File> inputs) {
        this.mInputs.addAll(inputs);
        return this;
    }

    public File getOutputFile() {
        return this.mOutputFile;
    }

    public boolean isVerbose() {
        return this.mVerbose;
    }

    public boolean isNoOptimize() {
        return this.mNoOptimize;
    }

    public boolean isMultiDex() {
        return this.mMultiDex;
    }

    public File getMainDexList() {
        return this.mMainDexList;
    }

    public Set<File> getInputs() {
        return this.mInputs;
    }

    public JavaProcessInfo build(BuildToolInfo buildToolInfo, DexOptions dexOptions) throws ProcessException {
        Revision buildToolsRevision = buildToolInfo.getRevision();
        Preconditions.checkState((!this.mMultiDex || buildToolsRevision.compareTo(MIN_MULTIDEX_BUILD_TOOLS_REV) >= 0 ? 1 : 0) != 0, (Object)("Multi dex requires Build Tools " + MIN_MULTIDEX_BUILD_TOOLS_REV.toString() + " / Current: " + buildToolsRevision.toShortString()));
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        builder.addEnvironments(this.mEnvironment);
        String dx = buildToolInfo.getPath(BuildToolInfo.PathId.DX_JAR);
        if (dx == null || !new File(dx).isFile()) {
            throw new IllegalStateException("dx.jar is missing");
        }
        builder.setClasspath(dx);
        builder.setMain("com.android.dx.command.Main");
        if (dexOptions.getJavaMaxHeapSize() != null) {
            builder.addJvmArg("-Xmx" + dexOptions.getJavaMaxHeapSize());
        } else {
            builder.addJvmArg("-Xmx1024M");
        }
        builder.addArgs("--dex");
        if (this.mVerbose) {
            builder.addArgs("--verbose");
        }
        if (dexOptions.getJumboMode()) {
            builder.addArgs("--force-jumbo");
        }
        if (this.mNoOptimize) {
            builder.addArgs("--no-optimize");
        }
        if (buildToolsRevision.compareTo(MIN_MULTI_THREADED_DEX_BUILD_TOOLS_REV) >= 0) {
            Integer threadCount = dexOptions.getThreadCount();
            if (threadCount == null) {
                builder.addArgs("--num-threads=4");
            } else {
                builder.addArgs("--num-threads=" + threadCount);
            }
        }
        if (this.mMultiDex) {
            builder.addArgs("--multi-dex");
            if (this.mMainDexList != null) {
                builder.addArgs("--main-dex-list", this.mMainDexList.getAbsolutePath());
            }
        }
        for (String arg : dexOptions.getAdditionalParameters()) {
            builder.addArgs(arg);
        }
        builder.addArgs("--output", this.mOutputFile.getAbsolutePath());
        builder.addArgs(this.getFilesToAdd(buildToolsRevision));
        return builder.createJavaProcess();
    }

    public List<String> getFilesToAdd(Revision buildToolsRevision) throws ProcessException {
        Set existingFiles = Sets.filter(this.mInputs, (Predicate)new Predicate<File>(){

            public boolean apply(File input) {
                return input != null && input.exists();
            }
        });
        if (existingFiles.isEmpty()) {
            throw new ProcessException("No files to pass to dex.");
        }
        Collection files = existingFiles;
        if (buildToolsRevision != null && buildToolsRevision.compareTo(FIXED_DX_MERGER) < 0) {
            ArrayList sortedList = Lists.newArrayList((Iterable)existingFiles);
            Collections.sort(sortedList, new Comparator<File>(){

                @Override
                public int compare(File file, File file2) {
                    boolean file2IsDir = file2.isDirectory();
                    if (file.isDirectory()) {
                        return file2IsDir ? 0 : -1;
                    }
                    if (file2IsDir) {
                        return 1;
                    }
                    long diff = file.length() - file2.length();
                    return diff > 0L ? 1 : (diff < 0L ? -1 : 0);
                }
            });
            files = sortedList;
        }
        ArrayList filePathList = Lists.newArrayListWithCapacity((int)files.size());
        for (File f : files) {
            filePathList.add(f.getAbsolutePath());
        }
        return filePathList;
    }
}

