package app.andriod.thinkfactory.timehelper;

import android.content.Context;
import android.content.res.Resources;

/**
 * Created by Benjamin J on 14-01-2019.
 */
public class TimeHelper {
    private static String format1;
    private static String format2;
    private static String format3;

    public static void initFormats(Context context){
        format1 = getStringResourceValue(context, "FORMAT1");
        format2 = getStringResourceValue(context, "FORMAT2");
        format3 = getStringResourceValue(context, "FORMAT3");
    }

    public static String getFormat1() {
        return format1;
    }

    public static void setFormat1(String format1) {
        TimeHelper.format1 = format1;
    }

    public static String getFormat2() {
        return format2;
    }

    public static void setFormat2(String format2) {
        TimeHelper.format2 = format2;
    }

    public static String getFormat3() {
        return format3;
    }

    public static void setFormat3(String format3) {
        TimeHelper.format3 = format3;
    }

    public static long getCurrentTimeInMillis(){
        return System.currentTimeMillis();
    }

    private static String getStringResourceValue(Context context, String key) {
        if (context != null) {
            final Resources resources = context.getResources();

            if (resources != null) {
                final int id = getResourcesIdentifier(context, key, "string");
                if (id > 0) {
                    String val = resources.getString(id);
                    try {
                        return null == val || "null".equals(val) ? "val not set" : val;
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                    return val;
                }
            }
        }
        return null;
    }

    private static int getResourcesIdentifier(Context context, String key, String resourceType) {
        final Resources resources = context.getResources();
        return resources.getIdentifier(key, resourceType, getResourcePackageName(context));
    }

    private static String getResourcePackageName(Context context) {
        final int iconId = context.getApplicationContext().getApplicationInfo().icon;
        if (iconId > 0) {
            return context.getResources().getResourcePackageName(iconId);
        } else {
            return context.getPackageName();
        }
    }
}
