/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.widget;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.StateListAnimator;
import android.animation.TimeInterpolator;
import android.content.res.ColorStateList;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.InsetDrawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.RippleDrawable;
import android.os.Build;
import android.support.annotation.RequiresApi;
import android.support.design.widget.CircularBorderDrawable;
import android.support.design.widget.CircularBorderDrawableLollipop;
import android.support.design.widget.FloatingActionButtonImpl;
import android.support.design.widget.ShadowDrawableWrapper;
import android.support.design.widget.ShadowViewDelegate;
import android.support.design.widget.VisibilityAwareImageButton;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.util.Property;
import android.view.View;
import java.util.ArrayList;

@RequiresApi(value=21)
class FloatingActionButtonLollipop
extends FloatingActionButtonImpl {
    private InsetDrawable mInsetDrawable;

    FloatingActionButtonLollipop(VisibilityAwareImageButton view, ShadowViewDelegate shadowViewDelegate) {
        super(view, shadowViewDelegate);
    }

    @Override
    void setBackgroundDrawable(ColorStateList backgroundTint, PorterDuff.Mode backgroundTintMode, int rippleColor, int borderWidth) {
        Drawable rippleContent;
        this.mShapeDrawable = DrawableCompat.wrap((Drawable)this.createShapeDrawable());
        DrawableCompat.setTintList((Drawable)this.mShapeDrawable, (ColorStateList)backgroundTint);
        if (backgroundTintMode != null) {
            DrawableCompat.setTintMode((Drawable)this.mShapeDrawable, (PorterDuff.Mode)backgroundTintMode);
        }
        if (borderWidth > 0) {
            this.mBorderDrawable = this.createBorderDrawable(borderWidth, backgroundTint);
            rippleContent = new LayerDrawable(new Drawable[]{this.mBorderDrawable, this.mShapeDrawable});
        } else {
            this.mBorderDrawable = null;
            rippleContent = this.mShapeDrawable;
        }
        this.mContentBackground = this.mRippleDrawable = new RippleDrawable(ColorStateList.valueOf((int)rippleColor), rippleContent, null);
        this.mShadowViewDelegate.setBackgroundDrawable(this.mRippleDrawable);
    }

    @Override
    void setRippleColor(int rippleColor) {
        if (this.mRippleDrawable instanceof RippleDrawable) {
            ((RippleDrawable)this.mRippleDrawable).setColor(ColorStateList.valueOf((int)rippleColor));
        } else {
            super.setRippleColor(rippleColor);
        }
    }

    @Override
    void onElevationsChanged(float elevation, float pressedTranslationZ) {
        if (Build.VERSION.SDK_INT == 21) {
            if (this.mView.isEnabled()) {
                this.mView.setElevation(elevation);
                if (this.mView.isFocused() || this.mView.isPressed()) {
                    this.mView.setTranslationZ(pressedTranslationZ);
                } else {
                    this.mView.setTranslationZ(0.0f);
                }
            } else {
                this.mView.setElevation(0.0f);
                this.mView.setTranslationZ(0.0f);
            }
        } else {
            StateListAnimator stateListAnimator = new StateListAnimator();
            AnimatorSet set = new AnimatorSet();
            set.play((Animator)ObjectAnimator.ofFloat((Object)((Object)this.mView), (String)"elevation", (float[])new float[]{elevation}).setDuration(0L)).with((Animator)ObjectAnimator.ofFloat((Object)((Object)this.mView), (Property)View.TRANSLATION_Z, (float[])new float[]{pressedTranslationZ}).setDuration(100L));
            set.setInterpolator((TimeInterpolator)ANIM_INTERPOLATOR);
            stateListAnimator.addState(PRESSED_ENABLED_STATE_SET, (Animator)set);
            set = new AnimatorSet();
            set.play((Animator)ObjectAnimator.ofFloat((Object)((Object)this.mView), (String)"elevation", (float[])new float[]{elevation}).setDuration(0L)).with((Animator)ObjectAnimator.ofFloat((Object)((Object)this.mView), (Property)View.TRANSLATION_Z, (float[])new float[]{pressedTranslationZ}).setDuration(100L));
            set.setInterpolator((TimeInterpolator)ANIM_INTERPOLATOR);
            stateListAnimator.addState(FOCUSED_ENABLED_STATE_SET, (Animator)set);
            set = new AnimatorSet();
            ArrayList<ObjectAnimator> animators = new ArrayList<ObjectAnimator>();
            animators.add(ObjectAnimator.ofFloat((Object)((Object)this.mView), (String)"elevation", (float[])new float[]{elevation}).setDuration(0L));
            if (Build.VERSION.SDK_INT >= 22 && Build.VERSION.SDK_INT <= 24) {
                animators.add(ObjectAnimator.ofFloat((Object)((Object)this.mView), (Property)View.TRANSLATION_Z, (float[])new float[]{this.mView.getTranslationZ()}).setDuration(100L));
            }
            animators.add(ObjectAnimator.ofFloat((Object)((Object)this.mView), (Property)View.TRANSLATION_Z, (float[])new float[]{0.0f}).setDuration(100L));
            set.playSequentially((Animator[])animators.toArray(new ObjectAnimator[0]));
            set.setInterpolator((TimeInterpolator)ANIM_INTERPOLATOR);
            stateListAnimator.addState(ENABLED_STATE_SET, (Animator)set);
            set = new AnimatorSet();
            set.play((Animator)ObjectAnimator.ofFloat((Object)((Object)this.mView), (String)"elevation", (float[])new float[]{0.0f}).setDuration(0L)).with((Animator)ObjectAnimator.ofFloat((Object)((Object)this.mView), (Property)View.TRANSLATION_Z, (float[])new float[]{0.0f}).setDuration(0L));
            set.setInterpolator((TimeInterpolator)ANIM_INTERPOLATOR);
            stateListAnimator.addState(EMPTY_STATE_SET, (Animator)set);
            this.mView.setStateListAnimator(stateListAnimator);
        }
        if (this.mShadowViewDelegate.isCompatPaddingEnabled()) {
            this.updatePadding();
        }
    }

    @Override
    public float getElevation() {
        return this.mView.getElevation();
    }

    @Override
    void onCompatShadowChanged() {
        this.updatePadding();
    }

    @Override
    void onPaddingUpdated(Rect padding) {
        if (this.mShadowViewDelegate.isCompatPaddingEnabled()) {
            this.mInsetDrawable = new InsetDrawable(this.mRippleDrawable, padding.left, padding.top, padding.right, padding.bottom);
            this.mShadowViewDelegate.setBackgroundDrawable((Drawable)this.mInsetDrawable);
        } else {
            this.mShadowViewDelegate.setBackgroundDrawable(this.mRippleDrawable);
        }
    }

    @Override
    void onDrawableStateChanged(int[] state) {
    }

    @Override
    void jumpDrawableToCurrentState() {
    }

    @Override
    boolean requirePreDrawListener() {
        return false;
    }

    @Override
    CircularBorderDrawable newCircularDrawable() {
        return new CircularBorderDrawableLollipop();
    }

    @Override
    GradientDrawable newGradientDrawableForShape() {
        return new AlwaysStatefulGradientDrawable();
    }

    @Override
    void getPadding(Rect rect) {
        if (this.mShadowViewDelegate.isCompatPaddingEnabled()) {
            float radius = this.mShadowViewDelegate.getRadius();
            float maxShadowSize = this.getElevation() + this.mPressedTranslationZ;
            int hPadding = (int)Math.ceil(ShadowDrawableWrapper.calculateHorizontalPadding(maxShadowSize, radius, false));
            int vPadding = (int)Math.ceil(ShadowDrawableWrapper.calculateVerticalPadding(maxShadowSize, radius, false));
            rect.set(hPadding, vPadding, hPadding, vPadding);
        } else {
            rect.set(0, 0, 0, 0);
        }
    }

    static class AlwaysStatefulGradientDrawable
    extends GradientDrawable {
        AlwaysStatefulGradientDrawable() {
        }

        public boolean isStateful() {
            return true;
        }
    }
}

