/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet.prober;

import org.mozilla.universalchardet.prober.Big5Prober;
import org.mozilla.universalchardet.prober.CharsetProber;
import org.mozilla.universalchardet.prober.EUCJPProber;
import org.mozilla.universalchardet.prober.EUCKRProber;
import org.mozilla.universalchardet.prober.EUCTWProber;
import org.mozilla.universalchardet.prober.GB18030Prober;
import org.mozilla.universalchardet.prober.SJISProber;
import org.mozilla.universalchardet.prober.UTF8Prober;

public final class MBCSGroupProber
extends CharsetProber {
    private CharsetProber.ProbingState state;
    private CharsetProber[] probers = new CharsetProber[7];
    private boolean[] isActive = new boolean[7];
    private int bestGuess;
    private int activeNum;

    public MBCSGroupProber() {
        this.probers[0] = new UTF8Prober();
        this.probers[1] = new SJISProber();
        this.probers[2] = new EUCJPProber();
        this.probers[3] = new GB18030Prober();
        this.probers[4] = new EUCKRProber();
        this.probers[5] = new Big5Prober();
        this.probers[6] = new EUCTWProber();
        this.reset();
    }

    public final String getCharSetName() {
        if (this.bestGuess == -1) {
            this.getConfidence();
            if (this.bestGuess == -1) {
                this.bestGuess = 0;
            }
        }
        return this.probers[this.bestGuess].getCharSetName();
    }

    /*
     * WARNING - void declaration
     */
    public final float getConfidence() {
        void var1_1;
        float bestConf = 0.0f;
        if (this.state == CharsetProber.ProbingState.FOUND_IT) {
            return 0.99f;
        }
        if (this.state == CharsetProber.ProbingState.NOT_ME) {
            return 0.01f;
        }
        for (int i = 0; i < this.probers.length; ++i) {
            void var3_3;
            float cf;
            if (!this.isActive[i] || !(bestConf < (cf = this.probers[i].getConfidence()))) continue;
            bestConf = var3_3;
            this.bestGuess = i;
        }
        return (float)var1_1;
    }

    public final CharsetProber.ProbingState getState() {
        return this.state;
    }

    /*
     * WARNING - void declaration
     */
    public final CharsetProber.ProbingState handleData(byte[] buf, int offset, int length) {
        int i;
        boolean keepNext = true;
        byte[] highbyteBuf = new byte[length];
        int highpos = 0;
        int maxPos = offset + length;
        while (i < maxPos) {
            if ((buf[i] & 0x80) != 0) {
                highbyteBuf[highpos++] = buf[i];
                keepNext = true;
            } else if (keepNext) {
                highbyteBuf[highpos++] = buf[i];
                keepNext = false;
            }
            ++i;
        }
        for (i = 0; i < this.probers.length; ++i) {
            void var1_1;
            if (!this.isActive[i]) continue;
            CharsetProber.ProbingState st = this.probers[i].handleData(highbyteBuf, 0, highpos);
            if (st == CharsetProber.ProbingState.FOUND_IT) {
                this.bestGuess = i;
                this.state = CharsetProber.ProbingState.FOUND_IT;
                break;
            }
            if (var1_1 != CharsetProber.ProbingState.NOT_ME) continue;
            this.isActive[i] = false;
            --this.activeNum;
            if (this.activeNum > 0) continue;
            this.state = CharsetProber.ProbingState.NOT_ME;
            break;
        }
        return this.state;
    }

    public final void reset() {
        this.activeNum = 0;
        for (int i = 0; i < this.probers.length; ++i) {
            this.probers[i].reset();
            this.isActive[i] = true;
            ++this.activeNum;
        }
        this.bestGuess = -1;
        this.state = CharsetProber.ProbingState.DETECTING;
    }
}

