/*
 * Decompiled with CFR 0.152.
 */
package com.google.repacked.apache.commons.io;

import com.google.repacked.apache.commons.io.Charsets;
import com.google.repacked.apache.commons.io.output.StringBuilderWriter;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public final class IOUtils {
    public static void closeQuietly(InputStream input) {
        IOUtils.closeQuietly((Closeable)input);
    }

    public static void closeQuietly(OutputStream output) {
        IOUtils.closeQuietly((Closeable)output);
    }

    private static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                Closeable closeable2;
                closeable2.close();
            }
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public static List<String> readLines(InputStream input) throws IOException {
        return IOUtils.readLines(input, Charset.defaultCharset());
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> readLines(InputStream input, Charset encoding) throws IOException {
        void var1_1;
        Closeable closeable;
        closeable = new InputStreamReader((InputStream)closeable, Charsets.toCharset((Charset)var1_1));
        return IOUtils.readLines((Reader)closeable);
    }

    /*
     * WARNING - void declaration
     */
    private static List<String> readLines(Reader input) throws IOException {
        void var1_1;
        Reader reader = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
        ArrayList<String> list = new ArrayList<String>();
        String line = ((BufferedReader)reader).readLine();
        while (line != null) {
            list.add(line);
            line = ((BufferedReader)reader).readLine();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static void write(String data, OutputStream output) throws IOException {
        void var1_1;
        IOUtils.write(data, (OutputStream)var1_1, Charset.defaultCharset());
    }

    /*
     * WARNING - void declaration
     */
    public static void write(String data, OutputStream output, Charset encoding) throws IOException {
        if (data != null) {
            void var2_2;
            String string;
            void var1_1;
            var1_1.write(string.getBytes(Charsets.toCharset((Charset)var2_2)));
        }
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var1_1;
        void var0;
        StringBuilderWriter buf = new StringBuilderWriter(4);
        PrintWriter out = new PrintWriter(buf);
        out.println();
        var0.toString();
        var1_1.close();
    }
}

