/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.processing;

import android.databinding.tool.processing.Scope;
import android.databinding.tool.processing.ScopedErrorReport;
import android.databinding.tool.store.Location;
import android.databinding.tool.util.L;
import com.google.repacked.apache.commons.lang3.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class ScopedException
extends RuntimeException {
    public static final String ERROR_LOG_PREFIX = "****/ data binding error ****";
    public static final String ERROR_LOG_SUFFIX = "****\\ data binding error ****";
    public static final String MSG_KEY = "msg:";
    public static final String LOCATION_KEY = "loc:";
    public static final String FILE_KEY = "file:";
    private static boolean sEncodeOutput = false;
    private ScopedErrorReport mScopedErrorReport;
    private String mScopeLog;

    /*
     * WARNING - void declaration
     */
    public ScopedException(String message, Object ... args) {
        super(message == null ? "unknown data binding exception" : (args.length == 0 ? message : String.format((String)var1_1, (Object[])var2_2)));
        void var2_2;
        void var1_1;
        this.mScopedErrorReport = Scope.createReport();
        this.mScopeLog = L.isDebugEnabled() ? Scope.produceScopeLog() : null;
    }

    /*
     * WARNING - void declaration
     */
    ScopedException(String message, ScopedErrorReport scopedErrorReport) {
        super((String)var1_1);
        void var2_2;
        void var1_1;
        this.mScopedErrorReport = var2_2;
    }

    public String getBareMessage() {
        return super.getMessage();
    }

    @Override
    public String getMessage() {
        if (sEncodeOutput) {
            return this.createEncodedMessage();
        }
        return this.createHumanReadableMessage();
    }

    /*
     * WARNING - void declaration
     */
    private String createHumanReadableMessage() {
        void var2_2;
        ScopedErrorReport scopedError = this.getScopedErrorReport();
        StringBuilder sb = new StringBuilder();
        sb.append(super.getMessage()).append("\nfile://").append(scopedError.getFilePath());
        if (scopedError.getLocations() != null && scopedError.getLocations().size() > 0) {
            void var1_1;
            sb.append(" Line:");
            sb.append(var1_1.getLocations().get((int)0).startLine);
        }
        sb.append("\n");
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    private String createEncodedMessage() {
        void var2_2;
        ScopedErrorReport scopedError = this.getScopedErrorReport();
        StringBuilder sb = new StringBuilder();
        sb.append("****/ data binding error ****msg:").append(super.getMessage()).append("\nfile:").append(scopedError.getFilePath()).append("\n");
        if (scopedError.getLocations() != null) {
            for (Location location : scopedError.getLocations()) {
                void var3_3;
                sb.append(LOCATION_KEY).append(var3_3.toUserReadableString()).append("\n");
            }
        }
        sb.append(ERROR_LOG_SUFFIX);
        return StringUtils.join(StringUtils.split(var2_2.toString(), System.lineSeparator()), " ");
    }

    public ScopedErrorReport getScopedErrorReport() {
        return this.mScopedErrorReport;
    }

    public boolean isValid() {
        return this.mScopedErrorReport.isValid();
    }

    /*
     * WARNING - void declaration
     */
    public static ScopedException createFromOutput(String output) {
        void var2_2;
        void var1_1;
        void var3_4;
        String message22;
        String file = "";
        ArrayList<Location> locations = new ArrayList<Location>();
        int msgStart = output.indexOf(MSG_KEY);
        if (msgStart < 0) {
            message22 = output;
        } else {
            void message22;
            int fileStart = output.indexOf(FILE_KEY, (int)(message22 + 4));
            if (fileStart < 0) {
                message22 = output;
            } else {
                message22 = output.substring((int)(message22 + 4), fileStart);
                int locStart = output.indexOf(LOCATION_KEY, fileStart + 5);
                if (locStart < 0) {
                    file = output.substring(fileStart + 5);
                } else {
                    file = output.substring(fileStart + 5, locStart);
                    int nextLoc = 0;
                    while (nextLoc >= 0) {
                        void loc22;
                        nextLoc = output.indexOf(LOCATION_KEY, locStart + 4);
                        Location loc22 = nextLoc < 0 ? Location.fromUserReadableString(output.substring(locStart + 4)) : Location.fromUserReadableString(output.substring((int)(loc22 + 4), nextLoc));
                        if (loc22 != null && loc22.isValid()) {
                            locations.add(loc22);
                        }
                        int n = nextLoc;
                    }
                }
            }
        }
        return new ScopedException(var3_4.trim(), new ScopedErrorReport(StringUtils.isEmpty(file) ? null : var1_1.trim(), (List<Location>)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public static List<ScopedException> extractErrors(String output) {
        void var1_1;
        ArrayList<ScopedException> errors = new ArrayList<ScopedException>();
        int index = output.indexOf(ERROR_LOG_PREFIX);
        int limit = output.length();
        while (index >= 0 && index < limit) {
            int end = output.indexOf(ERROR_LOG_SUFFIX, index + 29);
            if (end == -1) {
                errors.add(ScopedException.createFromOutput(output.substring(index + 29)));
                break;
            }
            errors.add(ScopedException.createFromOutput(output.substring(index + 29, end)));
            index = output.indexOf(ERROR_LOG_PREFIX, end + 29);
        }
        return var1_1;
    }

    public static void encodeOutput(boolean encodeOutput) {
        sEncodeOutput = encodeOutput;
    }
}

