/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.processing;

import android.databinding.tool.processing.ScopedErrorReport;
import android.databinding.tool.processing.ScopedException;
import android.databinding.tool.processing.scopes.FileScopeProvider;
import android.databinding.tool.processing.scopes.LocationScopeProvider;
import android.databinding.tool.processing.scopes.ScopeProvider;
import android.databinding.tool.store.Location;
import android.databinding.tool.util.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class Scope {
    private static ThreadLocal<ScopeEntry> sScopeItems = new ThreadLocal();
    static List<ScopedException> sDeferredExceptions = new ArrayList<ScopedException>();

    public static void enter(Location location) {
        Location location2;
        Scope.enter(new LocationScopeProvider(){

            @Override
            public final List<Location> provideScopeLocation() {
                return Arrays.asList(location2);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static void enter(ScopeProvider scopeProvider) {
        ScopeEntry scopeEntry;
        void var1_1;
        ScopeEntry peek = sScopeItems.get();
        ScopeEntry entry = new ScopeEntry(scopeProvider, (ScopeEntry)var1_1);
        sScopeItems.set(scopeEntry);
    }

    /*
     * WARNING - void declaration
     */
    public static void exit() {
        void var0;
        ScopeEntry entry = sScopeItems.get();
        Preconditions.checkNotNull(entry, "Inconsistent scope exit", new Object[0]);
        sScopeItems.set(var0.mParent);
    }

    public static void defer(ScopedException exception) {
        ScopedException scopedException;
        sDeferredExceptions.add(scopedException);
    }

    /*
     * WARNING - void declaration
     */
    private static void registerErrorInternal(String msg, int scopeIndex, ScopeProvider ... scopeProviders) {
        if (scopeProviders == null || scopeProviders.length <= scopeIndex) {
            Scope.defer(new ScopedException(msg, new Object[0]));
            return;
        }
        if (scopeProviders[scopeIndex] == null) {
            Scope.registerErrorInternal(msg, scopeIndex + 1, scopeProviders);
            return;
        }
        try {
            void var2_3;
            void var1_2;
            String string;
            Scope.enter(scopeProviders[scopeIndex]);
            Scope.registerErrorInternal(string, (int)(var1_2 + true), (ScopeProvider[])var2_3);
            return;
        }
        finally {
            Scope.exit();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void registerError(String msg, ScopeProvider ... scopeProviders) {
        void var1_1;
        Scope.registerErrorInternal(msg, 0, (ScopeProvider[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void assertNoError() {
        void var0;
        if (sDeferredExceptions.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        HashSet<ScopedException> messages = new HashSet<ScopedException>();
        for (ScopedException scopedException : sDeferredExceptions) {
            String message = scopedException.getMessage();
            if (messages.contains(message)) continue;
            sb.append(message).append("\n");
            messages.add(scopedException);
        }
        throw new RuntimeException("Found data binding errors.\n" + var0.toString());
    }

    /*
     * WARNING - void declaration
     */
    static String produceScopeLog() {
        void var0;
        StringBuilder sb = new StringBuilder();
        sb.append("full scope log\n");
        ScopeEntry top = sScopeItems.get();
        while (top != null) {
            ScopeProvider provider = top.mProvider;
            sb.append("---").append(provider).append("\n");
            if (provider instanceof FileScopeProvider) {
                sb.append("file:").append(((FileScopeProvider)provider).provideScopeFilePath()).append("\n");
            }
            if (provider instanceof LocationScopeProvider) {
                LocationScopeProvider loc = (LocationScopeProvider)provider;
                sb.append("loc:");
                List<Location> locations = loc.provideScopeLocation();
                if (locations == null) {
                    sb.append("null\n");
                } else {
                    for (Location location : locations) {
                        void var3_3;
                        sb.append(var3_3).append("\n");
                    }
                }
            }
            top = top.mParent;
        }
        sb.append("---\n");
        return var0.toString();
    }

    /*
     * WARNING - void declaration
     */
    static ScopedErrorReport createReport() {
        void var2_2;
        void var1_1;
        ScopeEntry top = sScopeItems.get();
        String filePath = null;
        List<Location> locations = null;
        while (top != null && (filePath == null || locations == null)) {
            ScopeProvider provider = top.mProvider;
            if (locations == null && provider instanceof LocationScopeProvider) {
                locations = Scope.findAbsoluteLocationFrom(top, (LocationScopeProvider)provider);
            }
            if (filePath == null && provider instanceof FileScopeProvider) {
                void var3_3;
                filePath = ((FileScopeProvider)var3_3).provideScopeFilePath();
            }
            top = top.mParent;
        }
        return new ScopedErrorReport((String)var1_1, (List<Location>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static List<Location> findAbsoluteLocationFrom(ScopeEntry entry, LocationScopeProvider top) {
        void var2_2;
        List<Location> locations = top.provideScopeLocation();
        if (locations == null || locations.isEmpty()) {
            return null;
        }
        if (locations.size() == 1) {
            return Arrays.asList(locations.get(0).toAbsoluteLocation());
        }
        ArrayList<Location> chosen = new ArrayList<Location>();
        for (Location location : locations) {
            Location absLocation = location.toAbsoluteLocation();
            if (!Scope.validatedContained(entry.mParent, absLocation)) continue;
            chosen.add(absLocation);
        }
        if (chosen.isEmpty()) {
            void var1_1;
            return var1_1;
        }
        return var2_2;
    }

    private static boolean validatedContained(ScopeEntry parent, Location absLocation) {
        Location location;
        while (true) {
            if (parent == null) {
                return true;
            }
            ScopeProvider provider = ((ScopeEntry)parent).mProvider;
            if (provider instanceof LocationScopeProvider) break;
            parent = ((ScopeEntry)parent).mParent;
        }
        parent = Scope.findAbsoluteLocationFrom((ScopeEntry)parent, (LocationScopeProvider)((Object)location));
        Iterator<Location> i$ = parent.iterator();
        while (i$.hasNext()) {
            location = (Location)i$.next();
            if (!location.contains(absLocation)) continue;
            return true;
        }
        return false;
    }

    static class ScopeEntry {
        ScopeProvider mProvider;
        ScopeEntry mParent;

        /*
         * WARNING - void declaration
         */
        public ScopeEntry(ScopeProvider scopeProvider, ScopeEntry parent) {
            void var2_2;
            void var1_1;
            this.mProvider = var1_1;
            this.mParent = var2_2;
        }
    }
}

