/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool;

import android.databinding.tool.processing.Scope;
import android.databinding.tool.util.L;
import com.google.common.base.Preconditions;
import com.google.repacked.apache.commons.io.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.bundling.Jar;

public class DataBindingExcludeGeneratedTask
extends DefaultTask {
    private String appPackage;
    private String infoClassQualifiedName;
    @Input
    private File generatedClassListFile;
    private boolean isLibrary;
    private Jar packageTask;
    private final String EXCLUDE_PATTERN = "android/databinding/layouts/*.*";

    /*
     * WARNING - void declaration
     */
    public void setAppPackage(String appPackage) {
        void var1_1;
        this.appPackage = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setInfoClassQualifiedName(String infoClassQualifiedName) {
        void var1_1;
        this.infoClassQualifiedName = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setLibrary(boolean isLibrary) {
        void var1_1;
        this.isLibrary = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setPackageTask(Jar packageTask) {
        void var1_1;
        this.packageTask = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setGeneratedClassListFile(File generatedClassListFile) {
        void var1_1;
        this.generatedClassListFile = var1_1;
    }

    public String getAppPackage() {
        return this.appPackage;
    }

    public String getInfoClassQualifiedName() {
        return this.infoClassQualifiedName;
    }

    public File getGeneratedClassListFile() {
        return this.generatedClassListFile;
    }

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public void excludeGenerated() {
        L.d("Excluding generated classes from jar. Is library ? %s", this.isLibrary);
        Object appPkgAsClass = this.appPackage.replace('.', '/');
        String infoClassAsClass = this.infoClassQualifiedName.replace('.', '/');
        this.exclude(infoClassAsClass + ".class");
        this.exclude("android/databinding/layouts/*.*");
        if (this.isLibrary) {
            this.exclude((String)appPkgAsClass + "/BR.*");
            appPkgAsClass = this.readGeneratedClasses();
            Iterator<String> i$ = appPkgAsClass.iterator();
            while (i$.hasNext()) {
                void var2_2;
                String klass = i$.next();
                this.exclude(var2_2.replace('.', '/') + ".class");
            }
        }
        Scope.assertNoError();
        L.d("Excluding generated classes from library jar is done.", new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    private void exclude(String pattern) {
        void var1_1;
        L.d("exclude %s", pattern);
        this.packageTask.exclude(new String[]{var1_1});
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    private List<String> readGeneratedClasses() {
        List<String> list;
        Preconditions.checkNotNull((Object)this.generatedClassListFile, (Object)"Data binding exclude generated task is not configured properly");
        Preconditions.checkArgument((boolean)this.generatedClassListFile.exists(), (String)"Generated class list does not exist %s", (Object[])new Object[]{this.generatedClassListFile.getAbsolutePath()});
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.generatedClassListFile);
            list = IOUtils.readLines(fis);
        }
        catch (FileNotFoundException fileNotFoundException) {
            FileNotFoundException fileNotFoundException2 = fileNotFoundException;
            L.e(fileNotFoundException, "Unable to read generated class list from %s", this.generatedClassListFile.getAbsoluteFile());
            IOUtils.closeQuietly(fis);
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            L.e(iOException, "Unexpected exception while reading %s", this.generatedClassListFile.getAbsoluteFile());
            {
                catch (Throwable throwable) {
                    void var1_1;
                    IOUtils.closeQuietly((InputStream)var1_1);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly(fis);
        }
        IOUtils.closeQuietly(fis);
        return list;
        Preconditions.checkState((boolean)false, (Object)"Could not read data binding generated class list");
        return null;
    }
}

