/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.util;

import android.databinding.tool.processing.ScopedException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;

public class L {
    private static boolean sEnableDebug = false;
    private static final Client sSystemClient;
    private static Client sClient;

    public static void setClient(Client systemClient) {
        sClient = systemClient;
    }

    public static void setDebugLog(boolean enabled) {
        sEnableDebug = enabled;
    }

    public static void d(String msg, Object ... args) {
        if (sEnableDebug) {
            L.printMessage(null, Diagnostic.Kind.NOTE, String.format(msg, args));
        }
    }

    public static void d(Element element, String msg, Object ... args) {
        if (sEnableDebug) {
            L.printMessage(element, Diagnostic.Kind.NOTE, String.format(msg, args));
        }
    }

    public static void d(Throwable t, String msg, Object ... args) {
        if (sEnableDebug) {
            L.printMessage(null, Diagnostic.Kind.NOTE, String.format(msg, args) + " " + L.getStackTrace(t));
        }
    }

    public static void w(String msg, Object ... args) {
        L.printMessage(null, Diagnostic.Kind.WARNING, String.format(msg, args));
    }

    public static void w(Element element, String msg, Object ... args) {
        L.printMessage(element, Diagnostic.Kind.WARNING, String.format(msg, args));
    }

    public static void w(Throwable t, String msg, Object ... args) {
        L.printMessage(null, Diagnostic.Kind.WARNING, String.format(msg, args) + " " + L.getStackTrace(t));
    }

    private static void tryToThrowScoped(Throwable t, String fullMessage) {
        ScopedException ex;
        if (t instanceof ScopedException && (ex = (ScopedException)t).isValid()) {
            throw ex;
        }
        ex = new ScopedException(fullMessage, new Object[0]);
        if (ex.isValid()) {
            throw ex;
        }
    }

    public static void e(String msg, Object ... args) {
        String fullMsg = String.format(msg, args);
        L.tryToThrowScoped(null, fullMsg);
        L.printMessage(null, Diagnostic.Kind.ERROR, fullMsg);
    }

    public static void e(Element element, String msg, Object ... args) {
        String fullMsg = String.format(msg, args);
        L.tryToThrowScoped(null, fullMsg);
        L.printMessage(element, Diagnostic.Kind.ERROR, fullMsg);
    }

    public static void e(Throwable t, String msg, Object ... args) {
        String fullMsg = String.format(msg, args);
        L.tryToThrowScoped(t, fullMsg);
        L.printMessage(null, Diagnostic.Kind.ERROR, fullMsg + " " + L.getStackTrace(t));
    }

    private static void printMessage(Element element, Diagnostic.Kind kind, String message) {
        ScopedException ex;
        if (kind == Diagnostic.Kind.WARNING && (ex = new ScopedException(message, new Object[0])).isValid()) {
            sClient.printMessage(kind, ex.createHumanReadableMessage(), element);
            return;
        }
        sClient.printMessage(kind, message, element);
        if (kind == Diagnostic.Kind.ERROR) {
            throw new RuntimeException("failure, see logs for details.\n" + message);
        }
    }

    public static boolean isDebugEnabled() {
        return sEnableDebug;
    }

    private static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        try (PrintWriter pw = new PrintWriter(sw);){
            t.printStackTrace(pw);
        }
        return sw.toString();
    }

    static {
        sClient = sSystemClient = new Client(){

            @Override
            public void printMessage(Diagnostic.Kind kind, String message, Element element) {
                if (kind == Diagnostic.Kind.ERROR) {
                    System.err.println(message);
                } else {
                    System.out.println(message);
                }
            }
        };
    }

    public static interface Client {
        public void printMessage(Diagnostic.Kind var1, String var2, Element var3);
    }
}

