/*
 * Decompiled with CFR 0.152.
 */
package com.android.component.mvp.fragment.container;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.util.Log;
import android.view.View;
import com.android.component.mvp.fragment.IComponent;
import com.android.component.mvp.fragment.IComponentBehavior;
import com.android.component.mvp.fragment.MTComponent;
import com.android.component.mvp.fragment.config.BaseContainerConfig;
import com.android.component.mvp.fragment.config.ConfigMaker;
import com.android.component.mvp.fragment.container.IComponentContainer;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;

public abstract class AbstractComponentContainer<T extends BaseContainerConfig>
extends MTComponent
implements IComponentContainer {
    private static final String TAG = "ComponentContainer";
    private Map<Class<? extends IComponent>, IComponent> mChilds = new HashMap<Class<? extends IComponent>, IComponent>();
    private Queue<IComponent> mViewUnInitedChilds = new LinkedList<IComponent>();
    private Class<? extends BaseContainerConfig> mConfigClazz;
    private T mConfig;
    private ConfigMaker mConfigMaker;

    public void setup(ConfigMaker configMaker) {
        this.mConfigMaker = configMaker;
        this.mConfigClazz = configMaker.ofConfig(this.getClass());
        try {
            this.mConfig = this.mConfigClazz.newInstance();
        }
        catch (Fragment.InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        this.onContainerInitSuccess(this.getActivity(), this.getArguments());
        this.initComponentConfig();
    }

    private void onContainerInitSuccess(FragmentActivity activity, Bundle arguments) {
        if (this.mConfig != null) {
            ((BaseContainerConfig)this.mConfig).onContainerInit((Activity)activity, arguments);
        }
    }

    @Override
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        this.prepareCommitComponents();
    }

    private void prepareCommitComponents() {
        FragmentManager fragmentManager = this.getChildFragmentManager();
        FragmentTransaction fragmentTransaction = fragmentManager.beginTransaction();
        for (Map.Entry<Class<? extends IComponent>, IComponent> entry : this.mChilds.entrySet()) {
            Class<? extends IComponent> componentClz = entry.getKey();
            IComponent component = entry.getValue();
            int resId = this.mConfigMaker.wrapper(componentClz).resId(this.mConfigClazz);
            boolean initHidden = this.mConfigMaker.wrapper(componentClz).initHidden(this.mConfigClazz);
            Fragment fragment = component.getContent();
            Log.i((String)TAG, (String)("commits content: " + fragment + ", resId: " + resId + ", initHidden: " + initHidden));
            if (initHidden) {
                fragmentTransaction.add(resId, fragment, component.getClass().getSimpleName()).hide(fragment);
            } else {
                fragmentTransaction.replace(resId, fragment, component.getClass().getSimpleName());
            }
            this.mViewUnInitedChilds.add(component);
        }
        fragmentTransaction.commitAllowingStateLoss();
    }

    private void initComponentConfig() {
        if (this.mConfigClazz == null) {
            return;
        }
        List<Class<? extends IComponent>> components = this.mConfigMaker.ofComponents(this.mConfigClazz);
        for (Class<? extends IComponent> com : components) {
            IComponent component = this.mConfigMaker.ofComponent(com);
            component.attachContainer(this);
            this.mChilds.put(com, component);
        }
    }

    @Override
    public <C extends IComponent> C getComponent(Class<C> pClass) {
        IComponent component = this.mChilds.get(pClass);
        if (component == null) {
            Collection<IComponent> components = this.mChilds.values();
            for (IComponent item : components) {
                C ret;
                if (!(item instanceof IComponentContainer) || (ret = ((IComponentContainer)((Object)item)).getComponent(pClass)) == null) continue;
                return ret;
            }
        }
        return (C)component;
    }

    @Override
    public <B extends IComponentBehavior> B findBehavior(Class<B> bClass) {
        Collection<IComponent> components = this.mChilds.values();
        for (IComponent behavior : components) {
            Class<?>[] classes;
            for (Class<?> clz : classes = behavior.getClass().getInterfaces()) {
                if (clz != bClass) continue;
                return (B)((IComponentBehavior)((Object)this.mChilds.get(behavior.getClass())));
            }
        }
        return null;
    }

    @Override
    public void onComponentViewCreated(Class<? extends IComponent> clz) {
        IComponent component = this.mChilds.get(clz);
        if (component != null && this.mViewUnInitedChilds.contains(component)) {
            Log.i((String)TAG, (String)("onComponentViewCreated: " + clz.getSimpleName()));
            this.mViewUnInitedChilds.remove(component);
        }
        if (this.mViewUnInitedChilds.isEmpty()) {
            this.onContainerViewInitSuccess();
        }
    }

    protected void onContainerViewInitSuccess() {
        for (Map.Entry<Class<? extends IComponent>, IComponent> entry : this.mChilds.entrySet()) {
            entry.getValue().onContainerInflated();
        }
    }

    public <C extends IComponent> boolean addComponent(Class<C> comClass) {
        C component = this.mConfigMaker.ofComponent(comClass);
        if (component != null) {
            component.attachContainer(this);
            this.mChilds.put((Class<? extends IComponent>)comClass, (IComponent)component);
            FragmentManager fragmentManager = this.getChildFragmentManager();
            FragmentTransaction fragmentTransaction = fragmentManager.beginTransaction();
            int resId = this.mConfigMaker.wrapper(comClass).resId(this.mConfigClazz);
            boolean initHidden = this.mConfigMaker.wrapper(comClass).initHidden(this.mConfigClazz);
            Fragment fragment = component.getContent();
            Log.i((String)TAG, (String)("addComponent content: " + fragment + ", resId: " + resId + ", initHidden: " + initHidden));
            if (initHidden) {
                fragmentTransaction.detach(fragment).add(resId, fragment, component.getClass().getSimpleName());
            } else {
                fragmentTransaction.replace(resId, fragment, component.getClass().getSimpleName());
            }
            fragmentTransaction.commitAllowingStateLoss();
            return true;
        }
        return false;
    }

    public <C extends IComponent> C removeComponent(Class<C> pClass) {
        IComponent component = this.mChilds.get(pClass);
        if (component != null) {
            Log.i((String)TAG, (String)("removeComponent content: " + component.getContent()));
            this.getChildFragmentManager().beginTransaction().remove(component.getContent()).commitAllowingStateLoss();
        }
        return (C)component;
    }
}

