/*
 * Decompiled with CFR 0.152.
 */
package com.android.component.mvp.fragment.config;

import android.app.Activity;
import com.android.component.mvp.fragment.ComponentWrapper;
import com.android.component.mvp.fragment.IComponent;
import com.android.component.mvp.fragment.config.BaseContainerConfig;
import com.android.component.mvp.fragment.config.ContainerConfig;
import com.android.component.mvp.fragment.container.AbstractComponentContainer;
import com.android.component.mvp.fragment.container.ContainerWrapper;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class ConfigClassFactory {
    protected Map<Class<? extends Activity>, Class<? extends ContainerWrapper>> mActivityConfigs = new ConcurrentHashMap<Class<? extends Activity>, Class<? extends ContainerWrapper>>();
    protected Map<Class<? extends AbstractComponentContainer>, Class<? extends BaseContainerConfig>> mContainerConfigs = new ConcurrentHashMap<Class<? extends AbstractComponentContainer>, Class<? extends BaseContainerConfig>>();
    protected Map<Class<? extends ContainerConfig>, List<Class<? extends IComponent>>> mCompontents = new ConcurrentHashMap<Class<? extends ContainerConfig>, List<Class<? extends IComponent>>>();
    protected Map<Class<? extends IComponent>, Class<? extends ComponentWrapper>> mComponentWrappers = new ConcurrentHashMap<Class<? extends IComponent>, Class<? extends ComponentWrapper>>();

    public ConfigClassFactory() {
        this.initClzMap();
    }

    public abstract void initClzMap();

    public Class<? extends BaseContainerConfig> containerConfigClass(Class<? extends AbstractComponentContainer> containerClz) {
        return this.mContainerConfigs.get(containerClz);
    }

    public Class<? extends ContainerWrapper> containerClass(Class<? extends Activity> activityClz) {
        return this.mActivityConfigs.get(activityClz);
    }

    public List<Class<? extends IComponent>> componentClasses(Class<? extends ContainerConfig> containerConfigClz) {
        return this.mCompontents.get(containerConfigClz);
    }

    public Class<? extends ComponentWrapper> componentWrapperClass(Class<? extends IComponent> componentClz) {
        return this.mComponentWrappers.get(componentClz);
    }

    public final <T extends IComponent> ComponentWrapper<T> create(Class<? extends IComponent> componentClz) {
        Class<? extends ComponentWrapper> wrapperClz = this.mComponentWrappers.get(componentClz);
        if (wrapperClz != null) {
            try {
                return wrapperClz.newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

