package com.android.component.mvp.fragment;


import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.android.component.mvp.fragment.container.IComponentContainer;
import com.android.component.mvp.mvp.MvpSniper;
import com.android.component.mvp.mvp.view.MvpView;

/**
 * @data         2018/7/24
 * @author       zhuqian(zaki)
 * @Description  组件
 */
public abstract class MTComponent extends Fragment implements IComponent, MvpView {
    protected View mRootView;
    protected IComponentContainer mAttachContainer; //依附的容器
    protected Activity mActivity;
    protected Handler mHandler = new Handler();
    protected boolean isContainerInflated = false;

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        MvpSniper.bind(this);
        this.mActivity = getActivity();
    }

    @Override
    public Fragment getContent() {
        return this;
    }

    @Override
    public void showSelf() {
        if (!getFragmentManager().isDestroyed() && isHidden())
            getFragmentManager().beginTransaction().show(this).commitAllowingStateLoss();
    }

    @Override
    public void hideSelf() {
        if (!getFragmentManager().isDestroyed() && !isHidden())
            getFragmentManager().beginTransaction().hide(this).commitAllowingStateLoss();
    }

    @Override
    public void attachContainer(@NonNull IComponentContainer container) {
        this.mAttachContainer = container;
    }

    @Nullable
    protected  <V extends View> V findViewById(int id) {
        if (mRootView != null) {
            return mRootView.findViewById(id);
        }
        return null;
    }


    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        mRootView = inflater.inflate(ofLayoutId(), container, false);
        initView(mRootView);
        return mRootView;
    }

    protected void finishActivity() {
        if (mActivity != null && !mActivity.isFinishing()) {
            mActivity.finish();
        }
    }

    public <B extends IComponentBehavior> B findBehavior(Class<B> bClass) {
        if (mAttachContainer != null) {
            return mAttachContainer.findBehavior(bClass);
        }
        return null;
    }

    public <C extends IComponent> C getComponent(Class<C> pClass) {
        if (mAttachContainer != null) {
            return mAttachContainer.getComponent(pClass);
        }
        return null;
    }

    @Override
    public IComponentContainer getContainer() {
        return mAttachContainer;
    }

    @Override
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        if (mAttachContainer != null) {
            mAttachContainer.onComponentViewCreated(getClass());
        }
    }

    @Override
    public void onContainerInflated() {
        this.isContainerInflated = true;
    }

    /**
     * 必须返回layout id
     *
     * @return
     */
    protected abstract int ofLayoutId();

    protected abstract void initView(View rootView);
}
