package com.android.billingclient.util;

import static com.android.billingclient.util.BillingHelper.RESPONSE_BUY_INTENT;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import android.os.ResultReceiver;
import com.android.billingclient.api.BillingClient;
import com.android.billingclient.api.BillingClient.BillingResponse;
import com.android.billingclient.api.BillingClientImpl;
import com.android.billingclient.api.PurchasesUpdatedListener;

/**
 * An invisible activity that handles the result from {@link BillingClient#launchBillingFlow} event
 * and delivers parsed result through the {@link PurchasesUpdatedListener} interface implementation
 * reported to the {@link BillingClientImpl} constructor.
 */
public class ProxyBillingActivity extends Activity {

  public static final String RECEIVER_EXTRA = "receiver_extra";
  private static final String TAG = "ProxyBillingActivity";
  private static final int REQUEST_CODE = 100;

  private ResultReceiver mResultReceiver;

  @Override
  protected void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);

    BillingHelper.logVerbose(TAG, "Launching Play Store billing flow");
    PendingIntent pendingIntent = getIntent().getParcelableExtra(RESPONSE_BUY_INTENT);
    mResultReceiver = getIntent().getParcelableExtra(RECEIVER_EXTRA);

    try {
      startIntentSenderForResult(
          pendingIntent.getIntentSender(), REQUEST_CODE, new Intent(), 0, 0, 0);
    } catch (IntentSender.SendIntentException e) {
      BillingHelper.logWarn(TAG, "Got exception while trying to start a purchase flow: " + e);
      mResultReceiver.send(BillingResponse.ERROR, null);
      finish();
    }
  }

  @Override
  protected void onActivityResult(int requestCode, int resultCode, Intent data) {
    super.onActivityResult(requestCode, resultCode, data);

    if (requestCode == REQUEST_CODE) {
      int responseCode = BillingHelper.getResponseCodeFromIntent(data, TAG);
      if (resultCode != RESULT_OK || responseCode != BillingResponse.OK) {
        BillingHelper.logWarn(
            TAG,
            "Got purchases updated result with resultCode "
                + resultCode
                + " and billing's responseCode: "
                + responseCode);
      }
      mResultReceiver.send(responseCode, (data == null) ? null : data.getExtras());
    } else {
      BillingHelper.logWarn(
          TAG, "Got onActivityResult with wrong requestCode: " + requestCode + "; skipping...");
    }
    // Need to finish this invisible activity once we sent back the result
    finish();
  }
}
