/*
 * Decompiled with CFR 0.152.
 */
package com.android.billingclient.api;

import android.text.TextUtils;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class SkuDetails {
    private final String mOriginalJson;
    private final JSONObject mParsedJson;

    public SkuDetails(String jsonSkuDetails) throws JSONException {
        this.mOriginalJson = jsonSkuDetails;
        this.mParsedJson = new JSONObject(this.mOriginalJson);
    }

    public String getOriginalJson() {
        return this.mOriginalJson;
    }

    public String getSku() {
        return this.mParsedJson.optString("productId");
    }

    public String getType() {
        return this.mParsedJson.optString("type");
    }

    public String getPrice() {
        return this.mParsedJson.optString("price");
    }

    public long getPriceAmountMicros() {
        return this.mParsedJson.optLong("price_amount_micros");
    }

    public String getPriceCurrencyCode() {
        return this.mParsedJson.optString("price_currency_code");
    }

    public String getTitle() {
        return this.mParsedJson.optString("title");
    }

    public String getDescription() {
        return this.mParsedJson.optString("description");
    }

    public String getSubscriptionPeriod() {
        return this.mParsedJson.optString("subscriptionPeriod");
    }

    public String getFreeTrialPeriod() {
        return this.mParsedJson.optString("freeTrialPeriod");
    }

    public String getIntroductoryPrice() {
        return this.mParsedJson.optString("introductoryPrice");
    }

    public String getIntroductoryPriceAmountMicros() {
        return this.mParsedJson.optString("introductoryPriceAmountMicros");
    }

    public String getIntroductoryPricePeriod() {
        return this.mParsedJson.optString("introductoryPricePeriod");
    }

    public String getIntroductoryPriceCycles() {
        return this.mParsedJson.optString("introductoryPriceCycles");
    }

    public boolean isRewarded() {
        return this.mParsedJson.has("rewardToken");
    }

    String rewardToken() {
        return this.mParsedJson.optString("rewardToken");
    }

    public String toString() {
        return "SkuDetails: " + this.mOriginalJson;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SkuDetails details = (SkuDetails)o;
        return TextUtils.equals((CharSequence)this.mOriginalJson, (CharSequence)details.mOriginalJson);
    }

    public int hashCode() {
        return this.mOriginalJson.hashCode();
    }

    public static class SkuDetailsResult {
        private List<SkuDetails> mSkuDetailsList;
        private int mResponseCode;

        public SkuDetailsResult(int responseCode, List<SkuDetails> skuDetailsList) {
            this.mSkuDetailsList = skuDetailsList;
            this.mResponseCode = responseCode;
        }

        public List<SkuDetails> getSkuDetailsList() {
            return this.mSkuDetailsList;
        }

        public int getResponseCode() {
            return this.mResponseCode;
        }
    }
}

