/*
 * Decompiled with CFR 0.152.
 */
package com.android.actionsheetdialog;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.TypedArray;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.ArrayRes;
import android.support.annotation.StringRes;
import android.support.annotation.StyleRes;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.android.actionsheetdialog.R;
import java.util.ArrayList;
import java.util.List;

public class ActionSheetDialog
extends AlertDialog {
    private static final String TAG = "ActionSheetDialog";

    protected ActionSheetDialog(Context context) {
        super(context);
    }

    protected ActionSheetDialog(Context context, boolean cancelable, DialogInterface.OnCancelListener cancelListener) {
        super(context, cancelable, cancelListener);
    }

    protected ActionSheetDialog(Context context, @StyleRes int themeResId) {
        super(context, themeResId);
    }

    public Button getButton(int whichButton) {
        return super.getButton(whichButton);
    }

    public static class ActionSheetBuilder
    extends AlertDialog.Builder {
        private Context mContext;
        private String mTitle;
        private String mMessage;
        private String mNegativeText;
        private String mPositiveText;
        private boolean mCancelable;
        private List<ActionSheetItem> mActionSheetItems;
        private DialogInterface.OnClickListener mNegativeClickListener;
        private DialogInterface.OnClickListener mPositiveClickListener;
        private ActionSheetDialog mActionSheetDialog;
        private int mTitleTextColor;
        private int mTitleTextSize;
        private int mTitleHeight;
        private Drawable mTitleDivider;
        private int mTitleDividerInset;
        private int mTitleDividerHeight;
        private int mMessageTextColor;
        private int mMessageTextSize;
        private int mMessageHeight;
        private Drawable mMessageDivider;
        private int mMessageDividerInset;
        private int mMessageDividerHeight;
        private int mItemTextColor;
        private int mItemTextSize;
        private int mItemHeight;
        private Drawable mItemDivider;
        private int mItemDividerInset;
        private int mItemDividerHeight;
        private int mPositiveTextColor;
        private int mPositiveTextSize;
        private int mPositiveHeight;
        private int mCancelTextColor;
        private int mCancelTextSize;
        private int mCancelHeight;
        private int mCancelTopMargin;
        private Drawable mCancelBackground;
        private int mLayoutMargins;
        private int mSheetMargins;
        private Drawable mContentBackground;
        private int mWindowAnimationId;
        private static final int DEFAULT_VALUE = -1;
        TextView mTitleView;
        ImageView mTitleDividerView;
        TextView mMessageView;
        ImageView mMessageDividerView;
        LinearLayout mSheetItemContainer;
        TextView mCancelView;
        TextView mPositiveView;
        SheetItemOnClickListener mSheetItemOnClickListener = new SheetItemOnClickListener();

        public ActionSheetBuilder(Context context) {
            super(context);
            this.mContext = context;
            this.mActionSheetItems = new ArrayList<ActionSheetItem>();
            TypedArray defaultTypedArray = context.obtainStyledAttributes(R.style.ActionSheetDialogBase, R.styleable.ActionSheetDialog);
            if (null != defaultTypedArray) {
                this.initDefaultAttributes(defaultTypedArray);
                defaultTypedArray.recycle();
            }
        }

        public ActionSheetBuilder(Context context, int themeResId) {
            this(context);
            TypedArray typedArray = context.obtainStyledAttributes(themeResId, R.styleable.ActionSheetDialog);
            if (null != typedArray) {
                this.initAttributes(typedArray);
                typedArray.recycle();
            }
        }

        private void initAttributes(TypedArray typedArray) {
            if (null != typedArray) {
                this.mTitleTextColor = typedArray.getColor(R.styleable.ActionSheetDialog_titleTextColor, this.mTitleTextColor);
                this.mTitleTextSize = typedArray.getDimensionPixelSize(R.styleable.ActionSheetDialog_titleTextSize, this.mTitleTextSize);
                this.mTitleHeight = typedArray.getDimensionPixelSize(R.styleable.ActionSheetDialog_titleHeight, this.mTitleHeight);
                this.mTitleDivider = typedArray.getDrawable(R.styleable.ActionSheetDialog_titleDivider);
                this.mTitleDividerInset = typedArray.getDimensionPixelSize(R.styleable.ActionSheetDialog_titleDividerInset, this.mTitleDividerInset);
                this.mTitleDividerHeight = typedArray.getDimensionPixelSize(R.styleable.ActionSheetDialog_titleDividerHeight, this.mTitleDividerHeight);
                this.mMessageTextColor = typedArray.getColor(R.styleable.ActionSheetDialog_messageTextColor, this.mMessageTextColor);
                this.mMessageTextSize = typedArray.getDimensionPixelSize(R.styleable.ActionSheetDialog_messageTextSize, this.mMessageTextSize);
                this.mMessageHeight = typedArray.getDimensionPixelSize(R.styleable.ActionSheetDialog_messageHeight, this.mMessageHeight);
                this.mMessageDivider = typedArray.getDrawable(R.styleable.ActionSheetDialog_messageDivider);
                this.mMessageDividerInset = typedArray.getDimensionPixelSize(R.styleable.ActionSheetDialog_messageDividerInset, this.mMessageDividerInset);
                this.mMessageDividerHeight = typedArray.getDimensionPixelSize(R.styleable.ActionSheetDialog_messageDividerHeight, this.mMessageDividerHeight);
                this.mItemTextColor = typedArray.getColor(R.styleable.ActionSheetDialog_itemTextColor, this.mItemTextColor);
                this.mItemTextSize = typedArray.getDimensionPixelSize(R.styleable.ActionSheetDialog_itemTextSize, this.mItemTextSize);
                this.mItemHeight = typedArray.getDimensionPixelSize(R.styleable.ActionSheetDialog_itemHeight, this.mItemHeight);
                this.mItemDivider = typedArray.getDrawable(R.styleable.ActionSheetDialog_itemDivider);
                this.mItemDividerInset = typedArray.getDimensionPixelSize(R.styleable.ActionSheetDialog_itemDividerInset, this.mItemDividerInset);
                this.mItemDividerHeight = typedArray.getDimensionPixelSize(R.styleable.ActionSheetDialog_itemDividerHeight, this.mItemDividerHeight);
                this.mPositiveTextColor = typedArray.getColor(R.styleable.ActionSheetDialog_positiveTextColor, this.mPositiveTextColor);
                this.mPositiveTextSize = typedArray.getDimensionPixelSize(R.styleable.ActionSheetDialog_positiveTextSize, this.mPositiveTextSize);
                this.mPositiveHeight = typedArray.getDimensionPixelSize(R.styleable.ActionSheetDialog_positiveHeight, this.mPositiveHeight);
                this.mCancelTextColor = typedArray.getColor(R.styleable.ActionSheetDialog_cancelTextColor, this.mCancelTextColor);
                this.mCancelTextSize = typedArray.getDimensionPixelSize(R.styleable.ActionSheetDialog_cancelTextSize, this.mCancelTextSize);
                this.mCancelHeight = typedArray.getDimensionPixelSize(R.styleable.ActionSheetDialog_cancelHeight, this.mCancelHeight);
                this.mCancelBackground = typedArray.getDrawable(R.styleable.ActionSheetDialog_cancelBackground);
                this.mCancelTopMargin = typedArray.getDimensionPixelSize(R.styleable.ActionSheetDialog_cancelTopMargins, this.mCancelTopMargin);
                this.mSheetMargins = typedArray.getDimensionPixelSize(R.styleable.ActionSheetDialog_sheetMargins, this.mSheetMargins);
                this.mContentBackground = typedArray.getDrawable(R.styleable.ActionSheetDialog_contentBackground);
                this.mWindowAnimationId = typedArray.getResourceId(R.styleable.ActionSheetDialog_windowAnimations, this.mWindowAnimationId);
            }
        }

        private void initDefaultAttributes(TypedArray defaultTypedArray) {
            if (null != defaultTypedArray) {
                this.mTitleTextColor = defaultTypedArray.getColor(R.styleable.ActionSheetDialog_titleTextColor, -1);
                this.mTitleTextSize = defaultTypedArray.getDimensionPixelSize(R.styleable.ActionSheetDialog_titleTextSize, -1);
                this.mTitleHeight = defaultTypedArray.getDimensionPixelSize(R.styleable.ActionSheetDialog_titleHeight, -1);
                this.mTitleDivider = defaultTypedArray.getDrawable(R.styleable.ActionSheetDialog_titleDivider);
                this.mTitleDividerInset = defaultTypedArray.getDimensionPixelSize(R.styleable.ActionSheetDialog_titleDividerInset, -1);
                this.mTitleDividerHeight = defaultTypedArray.getDimensionPixelSize(R.styleable.ActionSheetDialog_titleDividerHeight, -1);
                this.mMessageTextColor = defaultTypedArray.getColor(R.styleable.ActionSheetDialog_messageTextColor, -1);
                this.mMessageTextSize = defaultTypedArray.getDimensionPixelSize(R.styleable.ActionSheetDialog_messageTextSize, -1);
                this.mMessageHeight = defaultTypedArray.getDimensionPixelSize(R.styleable.ActionSheetDialog_messageHeight, -1);
                this.mMessageDivider = defaultTypedArray.getDrawable(R.styleable.ActionSheetDialog_messageDivider);
                this.mMessageDividerInset = defaultTypedArray.getDimensionPixelSize(R.styleable.ActionSheetDialog_messageDividerInset, -1);
                this.mMessageDividerHeight = defaultTypedArray.getDimensionPixelSize(R.styleable.ActionSheetDialog_messageDividerHeight, -1);
                this.mItemTextColor = defaultTypedArray.getColor(R.styleable.ActionSheetDialog_itemTextColor, -1);
                this.mItemTextSize = defaultTypedArray.getDimensionPixelSize(R.styleable.ActionSheetDialog_itemTextSize, -1);
                this.mItemHeight = defaultTypedArray.getDimensionPixelSize(R.styleable.ActionSheetDialog_itemHeight, -1);
                this.mItemDivider = defaultTypedArray.getDrawable(R.styleable.ActionSheetDialog_itemDivider);
                this.mItemDividerInset = defaultTypedArray.getDimensionPixelSize(R.styleable.ActionSheetDialog_itemDividerInset, -1);
                this.mItemDividerHeight = defaultTypedArray.getDimensionPixelSize(R.styleable.ActionSheetDialog_itemDividerHeight, -1);
                this.mPositiveTextColor = defaultTypedArray.getColor(R.styleable.ActionSheetDialog_positiveTextColor, -1);
                this.mPositiveTextSize = defaultTypedArray.getDimensionPixelSize(R.styleable.ActionSheetDialog_positiveTextSize, -1);
                this.mPositiveHeight = defaultTypedArray.getDimensionPixelSize(R.styleable.ActionSheetDialog_positiveHeight, -1);
                this.mCancelTextColor = defaultTypedArray.getColor(R.styleable.ActionSheetDialog_cancelTextColor, -1);
                this.mCancelTextSize = defaultTypedArray.getDimensionPixelSize(R.styleable.ActionSheetDialog_cancelTextSize, -1);
                this.mCancelHeight = defaultTypedArray.getDimensionPixelSize(R.styleable.ActionSheetDialog_cancelHeight, -1);
                this.mCancelBackground = defaultTypedArray.getDrawable(R.styleable.ActionSheetDialog_cancelBackground);
                this.mCancelTopMargin = defaultTypedArray.getDimensionPixelSize(R.styleable.ActionSheetDialog_cancelTopMargins, -1);
                this.mSheetMargins = defaultTypedArray.getDimensionPixelSize(R.styleable.ActionSheetDialog_sheetMargins, -1);
                this.mContentBackground = defaultTypedArray.getDrawable(R.styleable.ActionSheetDialog_contentBackground);
                this.mWindowAnimationId = defaultTypedArray.getResourceId(R.styleable.ActionSheetDialog_windowAnimations, -1);
            }
        }

        public ActionSheetBuilder setCancelable(boolean cancelable) {
            this.mCancelable = cancelable;
            return this;
        }

        public ActionSheetBuilder setMessage(CharSequence message) {
            this.mMessage = (String)message;
            return this;
        }

        public ActionSheetBuilder setMessage(@StringRes int messageId) {
            this.mMessage = this.mContext.getString(messageId);
            return this;
        }

        public ActionSheetBuilder setTitle(CharSequence title) {
            this.mTitle = (String)title;
            return this;
        }

        public ActionSheetBuilder setTitle(@StringRes int titleId) {
            this.mTitle = this.mContext.getString(titleId);
            return this;
        }

        public ActionSheetBuilder setNegativeButton(CharSequence text, DialogInterface.OnClickListener listener) {
            this.mNegativeText = (String)text;
            this.mNegativeClickListener = listener;
            this.mCancelable = true;
            return this;
        }

        public ActionSheetBuilder setPositiveButton(CharSequence text, DialogInterface.OnClickListener listener) {
            this.mPositiveText = (String)text;
            this.mPositiveClickListener = listener;
            return this;
        }

        public ActionSheetBuilder setItems(CharSequence[] items, DialogInterface.OnClickListener listener) {
            for (int i = 0; i < items.length; ++i) {
                ActionSheetItem item = new ActionSheetItem((String)items[i], listener);
                this.mActionSheetItems.add(item);
            }
            return this;
        }

        public ActionSheetBuilder setItems(@ArrayRes int itemsId, DialogInterface.OnClickListener listener) {
            this.setItems(this.mContext.getResources().getStringArray(itemsId), listener);
            return this;
        }

        public ActionSheetDialog create() {
            this.mActionSheetDialog = new ActionSheetDialog(this.mContext);
            Window window = this.mActionSheetDialog.getWindow();
            window.setGravity(80);
            window.setWindowAnimations(this.mWindowAnimationId);
            WindowManager.LayoutParams params = window.getAttributes();
            params.y = this.dpToPx(8.0f);
            params.x = 0;
            WindowManager windowManager = (WindowManager)this.getContext().getSystemService("window");
            int width = windowManager.getDefaultDisplay().getWidth();
            params.width = width - 2 * this.mSheetMargins;
            ColorDrawable drawable = new ColorDrawable();
            drawable.setAlpha(0);
            window.setBackgroundDrawable((Drawable)drawable);
            this.mActionSheetDialog.setCancelable(this.mCancelable);
            if (this.mCancelable) {
                this.mActionSheetDialog.setCanceledOnTouchOutside(true);
            }
            this.initViews();
            return this.mActionSheetDialog;
        }

        private void initViews() {
            View rootView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.layout_action_sheet_dialog, null);
            this.mTitleView = (TextView)rootView.findViewById(R.id.tv_title);
            this.mTitleDividerView = (ImageView)rootView.findViewById(R.id.title_divider);
            this.mMessageView = (TextView)rootView.findViewById(R.id.tv_message);
            this.mMessageDividerView = (ImageView)rootView.findViewById(R.id.message_divider);
            this.mSheetItemContainer = (LinearLayout)rootView.findViewById(R.id.scrollView_sheet_list);
            this.mCancelView = (TextView)rootView.findViewById(R.id.tv_cancel);
            this.handleTitle();
            this.handleMessage();
            this.handleContent();
            this.handleCancel();
            this.handlePositive();
            this.mActionSheetDialog.setView(rootView);
        }

        private ImageView createDivider(Drawable background, int inset) {
            ImageView divider = new ImageView(this.mContext);
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
            Log.d((String)ActionSheetDialog.TAG, (String)("createDivider: inset = " + inset));
            params.setMargins(inset, 0, inset, 0);
            divider.setLayoutParams((ViewGroup.LayoutParams)params);
            divider.setBackground(background);
            divider.setMinimumHeight(this.mItemDividerHeight);
            return divider;
        }

        private void handlePositive() {
            if (null != this.mPositiveText) {
                this.mPositiveView = new TextView(this.mContext);
                this.mPositiveView.setGravity(17);
                ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, -2);
                this.mPositiveView.setLayoutParams(params);
                this.mPositiveView.setText((CharSequence)this.mPositiveText);
                this.mPositiveView.setTextSize(0, (float)this.mPositiveTextSize);
                this.mPositiveView.setTextColor(this.mPositiveTextColor);
                this.mPositiveView.setTag((Object)-1);
                this.mPositiveView.setOnClickListener((View.OnClickListener)this.mSheetItemOnClickListener);
                this.mPositiveView.setMinHeight(this.mPositiveHeight);
                this.mSheetItemContainer.addView((View)this.createDivider(this.mItemDivider, this.mItemDividerInset));
                this.mSheetItemContainer.addView((View)this.mPositiveView);
            }
        }

        private void handleCancel() {
            if (null != this.mCancelView && this.mCancelable) {
                this.mCancelView.setMinHeight(this.mCancelHeight);
                this.mCancelView.setTextColor(this.mCancelTextColor);
                this.mCancelView.setTextSize(0, (float)this.mCancelTextSize);
                if (null != this.mCancelBackground) {
                    this.mCancelView.setBackground(this.mCancelBackground);
                }
                LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
                params.setMargins(0, this.mCancelTopMargin, 0, 0);
                this.mCancelView.setLayoutParams((ViewGroup.LayoutParams)params);
                if (null != this.mNegativeText) {
                    this.mCancelView.setText((CharSequence)this.mNegativeText);
                }
                this.mCancelView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (null != ActionSheetBuilder.this.mNegativeClickListener) {
                            ActionSheetBuilder.this.mNegativeClickListener.onClick((DialogInterface)ActionSheetBuilder.this.mActionSheetDialog, -2);
                        }
                        ActionSheetBuilder.this.mActionSheetDialog.dismiss();
                    }
                });
            }
        }

        private void handleContent() {
            if (null == this.mActionSheetItems || this.mActionSheetItems.isEmpty()) {
                this.mSheetItemContainer.setVisibility(8);
            } else {
                int size = this.mActionSheetItems.size();
                for (int i = 0; i < size; ++i) {
                    ActionSheetItem item = this.mActionSheetItems.get(i);
                    TextView sheetItemView = new TextView(this.mContext);
                    sheetItemView.setGravity(17);
                    ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, -2);
                    sheetItemView.setLayoutParams(params);
                    sheetItemView.setText((CharSequence)item.text);
                    sheetItemView.setMinHeight(this.mItemHeight);
                    sheetItemView.setTextSize(0, (float)this.mItemTextSize);
                    sheetItemView.setTextColor(this.mItemTextColor);
                    sheetItemView.setTag((Object)i);
                    sheetItemView.setOnClickListener((View.OnClickListener)this.mSheetItemOnClickListener);
                    this.mSheetItemContainer.addView((View)sheetItemView);
                    if (i >= size - 1) continue;
                    this.mSheetItemContainer.addView((View)this.createDivider(this.mItemDivider, this.mItemDividerInset));
                }
            }
        }

        private void handleMessage() {
            if (null != this.mMessageView) {
                if (null == this.mMessage) {
                    this.mMessageView.setVisibility(8);
                    this.mMessageDividerView.setVisibility(8);
                } else {
                    this.mMessageDividerView.setBackground(this.mMessageDivider);
                    this.mMessageDividerView.setMinimumHeight(this.mMessageDividerHeight);
                    LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
                    params.setMargins(this.mMessageDividerInset, 0, this.mMessageDividerInset, 0);
                    this.mMessageDividerView.setLayoutParams((ViewGroup.LayoutParams)params);
                    this.mMessageView.setMinHeight(this.mMessageHeight);
                    this.mMessageView.setGravity(17);
                    this.mMessageView.setTextSize(0, (float)this.mMessageTextSize);
                    this.mMessageView.setTextColor(this.mMessageTextColor);
                    this.mMessageView.setText((CharSequence)this.mMessage);
                }
            }
        }

        private void handleTitle() {
            if (null != this.mTitleView) {
                if (null == this.mTitle) {
                    this.mTitleView.setVisibility(8);
                    this.mTitleDividerView.setVisibility(8);
                } else {
                    this.mTitleDividerView.setBackground(this.mTitleDivider);
                    this.mTitleDividerView.setMinimumHeight(this.mTitleDividerHeight);
                    LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
                    params.setMargins(this.mTitleDividerInset, 0, this.mTitleDividerInset, 0);
                    this.mTitleDividerView.setLayoutParams((ViewGroup.LayoutParams)params);
                    this.mTitleView.setMinHeight(this.mTitleHeight);
                    this.mTitleView.setGravity(17);
                    this.mTitleView.setTextColor(this.mTitleTextColor);
                    this.mTitleView.setTextSize(0, (float)this.mTitleTextSize);
                    this.mTitleView.setText((CharSequence)this.mTitle);
                }
            }
        }

        public int dpToPx(float dp) {
            float scale = this.mContext.getResources().getDisplayMetrics().density;
            return (int)(dp * scale + 0.5f);
        }

        public int spToPx(float sp) {
            float scale = this.mContext.getResources().getDisplayMetrics().scaledDensity;
            return (int)(sp * scale + 0.5f);
        }

        private class SheetItemOnClickListener
        implements View.OnClickListener {
            private SheetItemOnClickListener() {
            }

            public void onClick(View v) {
                int tag = (Integer)v.getTag();
                Log.d((String)ActionSheetDialog.TAG, (String)("onClick: tag = " + tag));
                if (-1 == tag) {
                    if (null != ActionSheetBuilder.this.mPositiveClickListener) {
                        ActionSheetBuilder.this.mPositiveClickListener.onClick((DialogInterface)ActionSheetBuilder.this.mActionSheetDialog, -1);
                        ActionSheetBuilder.this.mActionSheetDialog.dismiss();
                    }
                    ActionSheetBuilder.this.mActionSheetDialog.dismiss();
                } else {
                    ((ActionSheetItem)((ActionSheetBuilder)ActionSheetBuilder.this).mActionSheetItems.get((int)tag)).listener.onClick((DialogInterface)ActionSheetBuilder.this.mActionSheetDialog, tag);
                }
            }
        }

        public static interface ActionSheetItemClickListener {
            public void onClick(int var1);
        }

        static class ActionSheetItem {
            String text;
            DialogInterface.OnClickListener listener;

            public ActionSheetItem(String text, DialogInterface.OnClickListener listener) {
                this.text = text;
                this.listener = listener;
            }
        }
    }
}

