/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.runtime.serialization.util;

import com.amazonaws.services.lambda.runtime.serialization.util.Functions;
import com.amazonaws.services.lambda.runtime.serialization.util.ReflectUtil;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Scanner;

public class SerializeUtil {
    private static final HashMap<String, Class> cachedClasses = new HashMap();

    public static String convertStreamToString(InputStream inputStream) {
        Scanner s = new Scanner(inputStream).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    public static Class loadCustomerClass(String className, ClassLoader customerClassLoader) {
        Class<?> cachedClass = cachedClasses.get(className);
        if (cachedClass == null) {
            cachedClass = ReflectUtil.loadClass(customerClassLoader, className);
            cachedClasses.put(className, cachedClass);
        }
        return cachedClass;
    }

    public static <T> T deserializeDateTime(Class<T> dateTimeClass, String dateTimeString) {
        Functions.R1<T, String> parseMethod = ReflectUtil.loadStaticR1(dateTimeClass, "parse", true, dateTimeClass, String.class);
        return parseMethod.call(dateTimeString);
    }

    public static <T> String serializeDateTime(T dateTime, ClassLoader classLoader) {
        Class dateTimeFormatterClass = SerializeUtil.loadCustomerClass("org.joda.time.format.DateTimeFormatter", classLoader);
        Class dateTimeFormatClass = SerializeUtil.loadCustomerClass("org.joda.time.format.ISODateTimeFormat", classLoader);
        Class readableInstantInterface = SerializeUtil.loadCustomerClass("org.joda.time.ReadableInstant", classLoader);
        return SerializeUtil.serializeDateTimeHelper(dateTime, dateTimeFormatterClass, dateTimeFormatClass, readableInstantInterface);
    }

    private static <S extends V, T, U, V> String serializeDateTimeHelper(S dateTime, Class<T> dateTimeFormatterClass, Class<U> dateTimeFormatClass, Class<V> readableInstantInterface) {
        Functions.R0<T> dateTimeFormatterConstructor = ReflectUtil.loadStaticR0(dateTimeFormatClass, "dateTime", true, dateTimeFormatterClass);
        T dateTimeFormatter = dateTimeFormatterConstructor.call();
        Functions.R1<String, V> printMethod = ReflectUtil.bindInstanceR1(dateTimeFormatter, "print", true, String.class, readableInstantInterface);
        return printMethod.call(dateTime);
    }
}

