/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.textract.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.textract.model.transform.AdapterMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Adapter
implements Serializable,
Cloneable,
StructuredPojo {
    private String adapterId;
    private List<String> pages;
    private String version;

    public void setAdapterId(String adapterId) {
        this.adapterId = adapterId;
    }

    public String getAdapterId() {
        return this.adapterId;
    }

    public Adapter withAdapterId(String adapterId) {
        this.setAdapterId(adapterId);
        return this;
    }

    public List<String> getPages() {
        return this.pages;
    }

    public void setPages(Collection<String> pages) {
        if (pages == null) {
            this.pages = null;
            return;
        }
        this.pages = new ArrayList<String>(pages);
    }

    public Adapter withPages(String ... pages) {
        if (this.pages == null) {
            this.setPages(new ArrayList<String>(pages.length));
        }
        for (String ele : pages) {
            this.pages.add(ele);
        }
        return this;
    }

    public Adapter withPages(Collection<String> pages) {
        this.setPages(pages);
        return this;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public Adapter withVersion(String version) {
        this.setVersion(version);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAdapterId() != null) {
            sb.append("AdapterId: ").append(this.getAdapterId()).append(",");
        }
        if (this.getPages() != null) {
            sb.append("Pages: ").append(this.getPages()).append(",");
        }
        if (this.getVersion() != null) {
            sb.append("Version: ").append(this.getVersion());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Adapter)) {
            return false;
        }
        Adapter other = (Adapter)obj;
        if (other.getAdapterId() == null ^ this.getAdapterId() == null) {
            return false;
        }
        if (other.getAdapterId() != null && !other.getAdapterId().equals(this.getAdapterId())) {
            return false;
        }
        if (other.getPages() == null ^ this.getPages() == null) {
            return false;
        }
        if (other.getPages() != null && !other.getPages().equals(this.getPages())) {
            return false;
        }
        if (other.getVersion() == null ^ this.getVersion() == null) {
            return false;
        }
        return other.getVersion() == null || other.getVersion().equals(this.getVersion());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAdapterId() == null ? 0 : this.getAdapterId().hashCode());
        hashCode = 31 * hashCode + (this.getPages() == null ? 0 : this.getPages().hashCode());
        hashCode = 31 * hashCode + (this.getVersion() == null ? 0 : this.getVersion().hashCode());
        return hashCode;
    }

    public Adapter clone() {
        try {
            return (Adapter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AdapterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

