/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.test.util;

import com.amazonaws.test.util.RandomInputStream;
import java.io.IOException;

public class UnreliableRandomInputStream
extends RandomInputStream {
    private static final boolean DEBUG = false;
    private boolean hasTriggeredAnException = false;

    public UnreliableRandomInputStream(long lengthInBytes) {
        super(lengthInBytes);
    }

    @Override
    public int read() throws IOException {
        this.triggerException();
        int read = super.read();
        return read;
    }

    private void triggerException() throws IOException {
        if (this.remainingBytes <= this.lengthInBytes / 2L && !this.hasTriggeredAnException) {
            this.hasTriggeredAnException = true;
            String msg = "UnreliableBogusInputStream fired an IOException after reading " + this.getBytesRead() + " bytes.";
            throw new IOException(msg);
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.triggerException();
        int read = super.read(b, off, len);
        return read;
    }
}

