/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.test.util;

import com.amazonaws.test.util.RandomInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class RandomTempFile
extends File {
    private static final long serialVersionUID = -8232143353692832238L;
    private static final String TEMP_DIR = System.getProperty("java.io.tmpdir");
    private final boolean binaryData;

    public RandomTempFile(String filename, long sizeInBytes) throws IOException {
        this(filename, sizeInBytes, false);
    }

    public RandomTempFile(String filename, long sizeInBytes, boolean binaryData) throws IOException {
        super(TEMP_DIR + File.separator + System.currentTimeMillis() + "-" + filename);
        this.binaryData = binaryData;
        this.createFile(sizeInBytes);
        System.out.println("RandomTempFile " + this + " created.");
    }

    public RandomTempFile(File root, String filename, long sizeInBytes) throws IOException {
        super(root, filename);
        this.binaryData = false;
        this.createFile(sizeInBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createFile(long sizeInBytes) throws IOException {
        this.deleteOnExit();
        FileOutputStream outputStream = new FileOutputStream(this);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        RandomInputStream inputStream = new RandomInputStream(sizeInBytes, this.binaryData);
        try {
            byte[] buffer = new byte[1024];
            int bytesRead = -1;
            while ((bytesRead = inputStream.read(buffer)) > -1) {
                bufferedOutputStream.write(buffer, 0, bytesRead);
            }
        }
        finally {
            bufferedOutputStream.close();
            outputStream.close();
            inputStream.close();
        }
    }
}

