/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.stepfunctions.builder.internal.validation;

import com.amazonaws.services.stepfunctions.builder.internal.validation.Problem;
import com.amazonaws.services.stepfunctions.builder.internal.validation.ValidationException;
import java.util.ArrayList;
import java.util.List;

final class ProblemReporter {
    private final List<Problem> problems = new ArrayList<Problem>();

    ProblemReporter() {
    }

    public void report(Problem problem) {
        this.problems.add(problem);
    }

    public boolean hasProblems() {
        return this.problems.size() > 0;
    }

    public ValidationException getException() {
        StringBuilder exceptionMessage = new StringBuilder();
        for (Problem problem : this.problems) {
            exceptionMessage.append(String.format("\n%s: %s", problem.getContext().getPath(), problem.getMessage()));
        }
        return new ValidationException(exceptionMessage.toString());
    }
}

