/*
 * Copyright 2010-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 *  http://aws.amazon.com/apache2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
package com.amazonaws.services.sns.util;

public enum SignatureVersion {
    SHA1("1", "SHA1withRSA"),
    SHA256("2", "SHA256withRSA");

    private final String value;
    private final String algorithm;

    SignatureVersion(final String value, final String algorithm) {
        this.value = value;
        this.algorithm = algorithm;
    }

    public static SignatureVersion fromValue(String value) {
        for (SignatureVersion signatureVersion : SignatureVersion.values()) {
            if (signatureVersion.value.equals(value)) {
                return signatureVersion;
            }
        }
        throw new RuntimeException("Invalid SignatureVersion value");
    }

    public String getValue() {
        return this.value;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }
}
