/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53recoveryreadiness.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.route53recoveryreadiness.model.Recommendation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class GetArchitectureRecommendationsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private Date lastAuditTimestamp;
    private String nextToken;
    private List<Recommendation> recommendations;

    public void setLastAuditTimestamp(Date lastAuditTimestamp) {
        this.lastAuditTimestamp = lastAuditTimestamp;
    }

    public Date getLastAuditTimestamp() {
        return this.lastAuditTimestamp;
    }

    public GetArchitectureRecommendationsResult withLastAuditTimestamp(Date lastAuditTimestamp) {
        this.setLastAuditTimestamp(lastAuditTimestamp);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public GetArchitectureRecommendationsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<Recommendation> getRecommendations() {
        return this.recommendations;
    }

    public void setRecommendations(Collection<Recommendation> recommendations) {
        if (recommendations == null) {
            this.recommendations = null;
            return;
        }
        this.recommendations = new ArrayList<Recommendation>(recommendations);
    }

    public GetArchitectureRecommendationsResult withRecommendations(Recommendation ... recommendations) {
        if (this.recommendations == null) {
            this.setRecommendations(new ArrayList<Recommendation>(recommendations.length));
        }
        for (Recommendation ele : recommendations) {
            this.recommendations.add(ele);
        }
        return this;
    }

    public GetArchitectureRecommendationsResult withRecommendations(Collection<Recommendation> recommendations) {
        this.setRecommendations(recommendations);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLastAuditTimestamp() != null) {
            sb.append("LastAuditTimestamp: ").append(this.getLastAuditTimestamp()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getRecommendations() != null) {
            sb.append("Recommendations: ").append(this.getRecommendations());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetArchitectureRecommendationsResult)) {
            return false;
        }
        GetArchitectureRecommendationsResult other = (GetArchitectureRecommendationsResult)obj;
        if (other.getLastAuditTimestamp() == null ^ this.getLastAuditTimestamp() == null) {
            return false;
        }
        if (other.getLastAuditTimestamp() != null && !other.getLastAuditTimestamp().equals(this.getLastAuditTimestamp())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getRecommendations() == null ^ this.getRecommendations() == null) {
            return false;
        }
        return other.getRecommendations() == null || other.getRecommendations().equals(this.getRecommendations());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLastAuditTimestamp() == null ? 0 : this.getLastAuditTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getRecommendations() == null ? 0 : this.getRecommendations().hashCode());
        return hashCode;
    }

    public GetArchitectureRecommendationsResult clone() {
        try {
            return (GetArchitectureRecommendationsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

