/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.keyspaces;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.keyspaces.AmazonKeyspacesAsync;
import com.amazonaws.services.keyspaces.AmazonKeyspacesAsyncClientBuilder;
import com.amazonaws.services.keyspaces.AmazonKeyspacesClient;
import com.amazonaws.services.keyspaces.model.CreateKeyspaceRequest;
import com.amazonaws.services.keyspaces.model.CreateKeyspaceResult;
import com.amazonaws.services.keyspaces.model.CreateTableRequest;
import com.amazonaws.services.keyspaces.model.CreateTableResult;
import com.amazonaws.services.keyspaces.model.DeleteKeyspaceRequest;
import com.amazonaws.services.keyspaces.model.DeleteKeyspaceResult;
import com.amazonaws.services.keyspaces.model.DeleteTableRequest;
import com.amazonaws.services.keyspaces.model.DeleteTableResult;
import com.amazonaws.services.keyspaces.model.GetKeyspaceRequest;
import com.amazonaws.services.keyspaces.model.GetKeyspaceResult;
import com.amazonaws.services.keyspaces.model.GetTableRequest;
import com.amazonaws.services.keyspaces.model.GetTableResult;
import com.amazonaws.services.keyspaces.model.ListKeyspacesRequest;
import com.amazonaws.services.keyspaces.model.ListKeyspacesResult;
import com.amazonaws.services.keyspaces.model.ListTablesRequest;
import com.amazonaws.services.keyspaces.model.ListTablesResult;
import com.amazonaws.services.keyspaces.model.ListTagsForResourceRequest;
import com.amazonaws.services.keyspaces.model.ListTagsForResourceResult;
import com.amazonaws.services.keyspaces.model.RestoreTableRequest;
import com.amazonaws.services.keyspaces.model.RestoreTableResult;
import com.amazonaws.services.keyspaces.model.TagResourceRequest;
import com.amazonaws.services.keyspaces.model.TagResourceResult;
import com.amazonaws.services.keyspaces.model.UntagResourceRequest;
import com.amazonaws.services.keyspaces.model.UntagResourceResult;
import com.amazonaws.services.keyspaces.model.UpdateTableRequest;
import com.amazonaws.services.keyspaces.model.UpdateTableResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonKeyspacesAsyncClient
extends AmazonKeyspacesClient
implements AmazonKeyspacesAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonKeyspacesAsyncClientBuilder asyncBuilder() {
        return AmazonKeyspacesAsyncClientBuilder.standard();
    }

    AmazonKeyspacesAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonKeyspacesAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateKeyspaceResult> createKeyspaceAsync(CreateKeyspaceRequest request) {
        return this.createKeyspaceAsync(request, null);
    }

    @Override
    public Future<CreateKeyspaceResult> createKeyspaceAsync(CreateKeyspaceRequest request, final AsyncHandler<CreateKeyspaceRequest, CreateKeyspaceResult> asyncHandler) {
        final CreateKeyspaceRequest finalRequest = (CreateKeyspaceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateKeyspaceResult>(){

            @Override
            public CreateKeyspaceResult call() throws Exception {
                CreateKeyspaceResult result = null;
                try {
                    result = AmazonKeyspacesAsyncClient.this.executeCreateKeyspace(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateTableResult> createTableAsync(CreateTableRequest request) {
        return this.createTableAsync(request, null);
    }

    @Override
    public Future<CreateTableResult> createTableAsync(CreateTableRequest request, final AsyncHandler<CreateTableRequest, CreateTableResult> asyncHandler) {
        final CreateTableRequest finalRequest = (CreateTableRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateTableResult>(){

            @Override
            public CreateTableResult call() throws Exception {
                CreateTableResult result = null;
                try {
                    result = AmazonKeyspacesAsyncClient.this.executeCreateTable(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteKeyspaceResult> deleteKeyspaceAsync(DeleteKeyspaceRequest request) {
        return this.deleteKeyspaceAsync(request, null);
    }

    @Override
    public Future<DeleteKeyspaceResult> deleteKeyspaceAsync(DeleteKeyspaceRequest request, final AsyncHandler<DeleteKeyspaceRequest, DeleteKeyspaceResult> asyncHandler) {
        final DeleteKeyspaceRequest finalRequest = (DeleteKeyspaceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteKeyspaceResult>(){

            @Override
            public DeleteKeyspaceResult call() throws Exception {
                DeleteKeyspaceResult result = null;
                try {
                    result = AmazonKeyspacesAsyncClient.this.executeDeleteKeyspace(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteTableResult> deleteTableAsync(DeleteTableRequest request) {
        return this.deleteTableAsync(request, null);
    }

    @Override
    public Future<DeleteTableResult> deleteTableAsync(DeleteTableRequest request, final AsyncHandler<DeleteTableRequest, DeleteTableResult> asyncHandler) {
        final DeleteTableRequest finalRequest = (DeleteTableRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteTableResult>(){

            @Override
            public DeleteTableResult call() throws Exception {
                DeleteTableResult result = null;
                try {
                    result = AmazonKeyspacesAsyncClient.this.executeDeleteTable(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetKeyspaceResult> getKeyspaceAsync(GetKeyspaceRequest request) {
        return this.getKeyspaceAsync(request, null);
    }

    @Override
    public Future<GetKeyspaceResult> getKeyspaceAsync(GetKeyspaceRequest request, final AsyncHandler<GetKeyspaceRequest, GetKeyspaceResult> asyncHandler) {
        final GetKeyspaceRequest finalRequest = (GetKeyspaceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetKeyspaceResult>(){

            @Override
            public GetKeyspaceResult call() throws Exception {
                GetKeyspaceResult result = null;
                try {
                    result = AmazonKeyspacesAsyncClient.this.executeGetKeyspace(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetTableResult> getTableAsync(GetTableRequest request) {
        return this.getTableAsync(request, null);
    }

    @Override
    public Future<GetTableResult> getTableAsync(GetTableRequest request, final AsyncHandler<GetTableRequest, GetTableResult> asyncHandler) {
        final GetTableRequest finalRequest = (GetTableRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetTableResult>(){

            @Override
            public GetTableResult call() throws Exception {
                GetTableResult result = null;
                try {
                    result = AmazonKeyspacesAsyncClient.this.executeGetTable(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListKeyspacesResult> listKeyspacesAsync(ListKeyspacesRequest request) {
        return this.listKeyspacesAsync(request, null);
    }

    @Override
    public Future<ListKeyspacesResult> listKeyspacesAsync(ListKeyspacesRequest request, final AsyncHandler<ListKeyspacesRequest, ListKeyspacesResult> asyncHandler) {
        final ListKeyspacesRequest finalRequest = (ListKeyspacesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListKeyspacesResult>(){

            @Override
            public ListKeyspacesResult call() throws Exception {
                ListKeyspacesResult result = null;
                try {
                    result = AmazonKeyspacesAsyncClient.this.executeListKeyspaces(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTablesResult> listTablesAsync(ListTablesRequest request) {
        return this.listTablesAsync(request, null);
    }

    @Override
    public Future<ListTablesResult> listTablesAsync(ListTablesRequest request, final AsyncHandler<ListTablesRequest, ListTablesResult> asyncHandler) {
        final ListTablesRequest finalRequest = (ListTablesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTablesResult>(){

            @Override
            public ListTablesResult call() throws Exception {
                ListTablesResult result = null;
                try {
                    result = AmazonKeyspacesAsyncClient.this.executeListTables(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AmazonKeyspacesAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RestoreTableResult> restoreTableAsync(RestoreTableRequest request) {
        return this.restoreTableAsync(request, null);
    }

    @Override
    public Future<RestoreTableResult> restoreTableAsync(RestoreTableRequest request, final AsyncHandler<RestoreTableRequest, RestoreTableResult> asyncHandler) {
        final RestoreTableRequest finalRequest = (RestoreTableRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RestoreTableResult>(){

            @Override
            public RestoreTableResult call() throws Exception {
                RestoreTableResult result = null;
                try {
                    result = AmazonKeyspacesAsyncClient.this.executeRestoreTable(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AmazonKeyspacesAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AmazonKeyspacesAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateTableResult> updateTableAsync(UpdateTableRequest request) {
        return this.updateTableAsync(request, null);
    }

    @Override
    public Future<UpdateTableResult> updateTableAsync(UpdateTableRequest request, final AsyncHandler<UpdateTableRequest, UpdateTableResult> asyncHandler) {
        final UpdateTableRequest finalRequest = (UpdateTableRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateTableResult>(){

            @Override
            public UpdateTableResult call() throws Exception {
                UpdateTableResult result = null;
                try {
                    result = AmazonKeyspacesAsyncClient.this.executeUpdateTable(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

