/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kendra.model.TableCell;
import com.amazonaws.services.kendra.model.transform.TableRowMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TableRow
implements Serializable,
Cloneable,
StructuredPojo {
    private List<TableCell> cells;

    public List<TableCell> getCells() {
        return this.cells;
    }

    public void setCells(Collection<TableCell> cells) {
        if (cells == null) {
            this.cells = null;
            return;
        }
        this.cells = new ArrayList<TableCell>(cells);
    }

    public TableRow withCells(TableCell ... cells) {
        if (this.cells == null) {
            this.setCells(new ArrayList<TableCell>(cells.length));
        }
        for (TableCell ele : cells) {
            this.cells.add(ele);
        }
        return this;
    }

    public TableRow withCells(Collection<TableCell> cells) {
        this.setCells(cells);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCells() != null) {
            sb.append("Cells: ").append(this.getCells());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableRow)) {
            return false;
        }
        TableRow other = (TableRow)obj;
        if (other.getCells() == null ^ this.getCells() == null) {
            return false;
        }
        return other.getCells() == null || other.getCells().equals(this.getCells());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCells() == null ? 0 : this.getCells().hashCode());
        return hashCode;
    }

    public TableRow clone() {
        try {
            return (TableRow)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TableRowMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

