/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.imagebuilder.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.imagebuilder.model.ImageVersion;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListImagesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String requestId;
    private List<ImageVersion> imageVersionList;
    private String nextToken;

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public ListImagesResult withRequestId(String requestId) {
        this.setRequestId(requestId);
        return this;
    }

    public List<ImageVersion> getImageVersionList() {
        return this.imageVersionList;
    }

    public void setImageVersionList(Collection<ImageVersion> imageVersionList) {
        if (imageVersionList == null) {
            this.imageVersionList = null;
            return;
        }
        this.imageVersionList = new ArrayList<ImageVersion>(imageVersionList);
    }

    public ListImagesResult withImageVersionList(ImageVersion ... imageVersionList) {
        if (this.imageVersionList == null) {
            this.setImageVersionList(new ArrayList<ImageVersion>(imageVersionList.length));
        }
        for (ImageVersion ele : imageVersionList) {
            this.imageVersionList.add(ele);
        }
        return this;
    }

    public ListImagesResult withImageVersionList(Collection<ImageVersion> imageVersionList) {
        this.setImageVersionList(imageVersionList);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListImagesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRequestId() != null) {
            sb.append("RequestId: ").append(this.getRequestId()).append(",");
        }
        if (this.getImageVersionList() != null) {
            sb.append("ImageVersionList: ").append(this.getImageVersionList()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListImagesResult)) {
            return false;
        }
        ListImagesResult other = (ListImagesResult)obj;
        if (other.getRequestId() == null ^ this.getRequestId() == null) {
            return false;
        }
        if (other.getRequestId() != null && !other.getRequestId().equals(this.getRequestId())) {
            return false;
        }
        if (other.getImageVersionList() == null ^ this.getImageVersionList() == null) {
            return false;
        }
        if (other.getImageVersionList() != null && !other.getImageVersionList().equals(this.getImageVersionList())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRequestId() == null ? 0 : this.getRequestId().hashCode());
        hashCode = 31 * hashCode + (this.getImageVersionList() == null ? 0 : this.getImageVersionList().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListImagesResult clone() {
        try {
            return (ListImagesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

