/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.greengrassv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.greengrassv2.model.transform.ComponentCandidateMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ComponentCandidate
implements Serializable,
Cloneable,
StructuredPojo {
    private String componentName;
    private String componentVersion;
    private Map<String, String> versionRequirements;

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public ComponentCandidate withComponentName(String componentName) {
        this.setComponentName(componentName);
        return this;
    }

    public void setComponentVersion(String componentVersion) {
        this.componentVersion = componentVersion;
    }

    public String getComponentVersion() {
        return this.componentVersion;
    }

    public ComponentCandidate withComponentVersion(String componentVersion) {
        this.setComponentVersion(componentVersion);
        return this;
    }

    public Map<String, String> getVersionRequirements() {
        return this.versionRequirements;
    }

    public void setVersionRequirements(Map<String, String> versionRequirements) {
        this.versionRequirements = versionRequirements;
    }

    public ComponentCandidate withVersionRequirements(Map<String, String> versionRequirements) {
        this.setVersionRequirements(versionRequirements);
        return this;
    }

    public ComponentCandidate addVersionRequirementsEntry(String key, String value) {
        if (null == this.versionRequirements) {
            this.versionRequirements = new HashMap<String, String>();
        }
        if (this.versionRequirements.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.versionRequirements.put(key, value);
        return this;
    }

    public ComponentCandidate clearVersionRequirementsEntries() {
        this.versionRequirements = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getComponentName() != null) {
            sb.append("ComponentName: ").append(this.getComponentName()).append(",");
        }
        if (this.getComponentVersion() != null) {
            sb.append("ComponentVersion: ").append(this.getComponentVersion()).append(",");
        }
        if (this.getVersionRequirements() != null) {
            sb.append("VersionRequirements: ").append(this.getVersionRequirements());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentCandidate)) {
            return false;
        }
        ComponentCandidate other = (ComponentCandidate)obj;
        if (other.getComponentName() == null ^ this.getComponentName() == null) {
            return false;
        }
        if (other.getComponentName() != null && !other.getComponentName().equals(this.getComponentName())) {
            return false;
        }
        if (other.getComponentVersion() == null ^ this.getComponentVersion() == null) {
            return false;
        }
        if (other.getComponentVersion() != null && !other.getComponentVersion().equals(this.getComponentVersion())) {
            return false;
        }
        if (other.getVersionRequirements() == null ^ this.getVersionRequirements() == null) {
            return false;
        }
        return other.getVersionRequirements() == null || other.getVersionRequirements().equals(this.getVersionRequirements());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getComponentName() == null ? 0 : this.getComponentName().hashCode());
        hashCode = 31 * hashCode + (this.getComponentVersion() == null ? 0 : this.getComponentVersion().hashCode());
        hashCode = 31 * hashCode + (this.getVersionRequirements() == null ? 0 : this.getVersionRequirements().hashCode());
        return hashCode;
    }

    public ComponentCandidate clone() {
        try {
            return (ComponentCandidate)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComponentCandidateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

