/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.elasticache.model.NodeSnapshot;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Snapshot
implements Serializable {
    private String snapshotName;
    private String cacheClusterId;
    private String snapshotStatus;
    private String snapshotSource;
    private String cacheNodeType;
    private String engine;
    private String engineVersion;
    private Integer numCacheNodes;
    private String preferredAvailabilityZone;
    private Date cacheClusterCreateTime;
    private String preferredMaintenanceWindow;
    private String topicArn;
    private Integer port;
    private String cacheParameterGroupName;
    private String cacheSubnetGroupName;
    private String vpcId;
    private Boolean autoMinorVersionUpgrade;
    private Integer snapshotRetentionLimit;
    private String snapshotWindow;
    private ListWithAutoConstructFlag<NodeSnapshot> nodeSnapshots;

    public String getSnapshotName() {
        return this.snapshotName;
    }

    public void setSnapshotName(String snapshotName) {
        this.snapshotName = snapshotName;
    }

    public Snapshot withSnapshotName(String snapshotName) {
        this.snapshotName = snapshotName;
        return this;
    }

    public String getCacheClusterId() {
        return this.cacheClusterId;
    }

    public void setCacheClusterId(String cacheClusterId) {
        this.cacheClusterId = cacheClusterId;
    }

    public Snapshot withCacheClusterId(String cacheClusterId) {
        this.cacheClusterId = cacheClusterId;
        return this;
    }

    public String getSnapshotStatus() {
        return this.snapshotStatus;
    }

    public void setSnapshotStatus(String snapshotStatus) {
        this.snapshotStatus = snapshotStatus;
    }

    public Snapshot withSnapshotStatus(String snapshotStatus) {
        this.snapshotStatus = snapshotStatus;
        return this;
    }

    public String getSnapshotSource() {
        return this.snapshotSource;
    }

    public void setSnapshotSource(String snapshotSource) {
        this.snapshotSource = snapshotSource;
    }

    public Snapshot withSnapshotSource(String snapshotSource) {
        this.snapshotSource = snapshotSource;
        return this;
    }

    public String getCacheNodeType() {
        return this.cacheNodeType;
    }

    public void setCacheNodeType(String cacheNodeType) {
        this.cacheNodeType = cacheNodeType;
    }

    public Snapshot withCacheNodeType(String cacheNodeType) {
        this.cacheNodeType = cacheNodeType;
        return this;
    }

    public String getEngine() {
        return this.engine;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public Snapshot withEngine(String engine) {
        this.engine = engine;
        return this;
    }

    public String getEngineVersion() {
        return this.engineVersion;
    }

    public void setEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
    }

    public Snapshot withEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
        return this;
    }

    public Integer getNumCacheNodes() {
        return this.numCacheNodes;
    }

    public void setNumCacheNodes(Integer numCacheNodes) {
        this.numCacheNodes = numCacheNodes;
    }

    public Snapshot withNumCacheNodes(Integer numCacheNodes) {
        this.numCacheNodes = numCacheNodes;
        return this;
    }

    public String getPreferredAvailabilityZone() {
        return this.preferredAvailabilityZone;
    }

    public void setPreferredAvailabilityZone(String preferredAvailabilityZone) {
        this.preferredAvailabilityZone = preferredAvailabilityZone;
    }

    public Snapshot withPreferredAvailabilityZone(String preferredAvailabilityZone) {
        this.preferredAvailabilityZone = preferredAvailabilityZone;
        return this;
    }

    public Date getCacheClusterCreateTime() {
        return this.cacheClusterCreateTime;
    }

    public void setCacheClusterCreateTime(Date cacheClusterCreateTime) {
        this.cacheClusterCreateTime = cacheClusterCreateTime;
    }

    public Snapshot withCacheClusterCreateTime(Date cacheClusterCreateTime) {
        this.cacheClusterCreateTime = cacheClusterCreateTime;
        return this;
    }

    public String getPreferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.preferredMaintenanceWindow = preferredMaintenanceWindow;
    }

    public Snapshot withPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        return this;
    }

    public String getTopicArn() {
        return this.topicArn;
    }

    public void setTopicArn(String topicArn) {
        this.topicArn = topicArn;
    }

    public Snapshot withTopicArn(String topicArn) {
        this.topicArn = topicArn;
        return this;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Snapshot withPort(Integer port) {
        this.port = port;
        return this;
    }

    public String getCacheParameterGroupName() {
        return this.cacheParameterGroupName;
    }

    public void setCacheParameterGroupName(String cacheParameterGroupName) {
        this.cacheParameterGroupName = cacheParameterGroupName;
    }

    public Snapshot withCacheParameterGroupName(String cacheParameterGroupName) {
        this.cacheParameterGroupName = cacheParameterGroupName;
        return this;
    }

    public String getCacheSubnetGroupName() {
        return this.cacheSubnetGroupName;
    }

    public void setCacheSubnetGroupName(String cacheSubnetGroupName) {
        this.cacheSubnetGroupName = cacheSubnetGroupName;
    }

    public Snapshot withCacheSubnetGroupName(String cacheSubnetGroupName) {
        this.cacheSubnetGroupName = cacheSubnetGroupName;
        return this;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public Snapshot withVpcId(String vpcId) {
        this.vpcId = vpcId;
        return this;
    }

    public Boolean isAutoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
        this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
    }

    public Snapshot withAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
        this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        return this;
    }

    public Boolean getAutoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public Integer getSnapshotRetentionLimit() {
        return this.snapshotRetentionLimit;
    }

    public void setSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
        this.snapshotRetentionLimit = snapshotRetentionLimit;
    }

    public Snapshot withSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
        this.snapshotRetentionLimit = snapshotRetentionLimit;
        return this;
    }

    public String getSnapshotWindow() {
        return this.snapshotWindow;
    }

    public void setSnapshotWindow(String snapshotWindow) {
        this.snapshotWindow = snapshotWindow;
    }

    public Snapshot withSnapshotWindow(String snapshotWindow) {
        this.snapshotWindow = snapshotWindow;
        return this;
    }

    public List<NodeSnapshot> getNodeSnapshots() {
        if (this.nodeSnapshots == null) {
            this.nodeSnapshots = new ListWithAutoConstructFlag();
            this.nodeSnapshots.setAutoConstruct(true);
        }
        return this.nodeSnapshots;
    }

    public void setNodeSnapshots(Collection<NodeSnapshot> nodeSnapshots) {
        if (nodeSnapshots == null) {
            this.nodeSnapshots = null;
            return;
        }
        ListWithAutoConstructFlag nodeSnapshotsCopy = new ListWithAutoConstructFlag(nodeSnapshots.size());
        nodeSnapshotsCopy.addAll(nodeSnapshots);
        this.nodeSnapshots = nodeSnapshotsCopy;
    }

    public Snapshot withNodeSnapshots(NodeSnapshot ... nodeSnapshots) {
        if (this.getNodeSnapshots() == null) {
            this.setNodeSnapshots(new ArrayList<NodeSnapshot>(nodeSnapshots.length));
        }
        for (NodeSnapshot value : nodeSnapshots) {
            this.getNodeSnapshots().add(value);
        }
        return this;
    }

    public Snapshot withNodeSnapshots(Collection<NodeSnapshot> nodeSnapshots) {
        if (nodeSnapshots == null) {
            this.nodeSnapshots = null;
        } else {
            ListWithAutoConstructFlag nodeSnapshotsCopy = new ListWithAutoConstructFlag(nodeSnapshots.size());
            nodeSnapshotsCopy.addAll(nodeSnapshots);
            this.nodeSnapshots = nodeSnapshotsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSnapshotName() != null) {
            sb.append("SnapshotName: " + this.getSnapshotName() + ",");
        }
        if (this.getCacheClusterId() != null) {
            sb.append("CacheClusterId: " + this.getCacheClusterId() + ",");
        }
        if (this.getSnapshotStatus() != null) {
            sb.append("SnapshotStatus: " + this.getSnapshotStatus() + ",");
        }
        if (this.getSnapshotSource() != null) {
            sb.append("SnapshotSource: " + this.getSnapshotSource() + ",");
        }
        if (this.getCacheNodeType() != null) {
            sb.append("CacheNodeType: " + this.getCacheNodeType() + ",");
        }
        if (this.getEngine() != null) {
            sb.append("Engine: " + this.getEngine() + ",");
        }
        if (this.getEngineVersion() != null) {
            sb.append("EngineVersion: " + this.getEngineVersion() + ",");
        }
        if (this.getNumCacheNodes() != null) {
            sb.append("NumCacheNodes: " + this.getNumCacheNodes() + ",");
        }
        if (this.getPreferredAvailabilityZone() != null) {
            sb.append("PreferredAvailabilityZone: " + this.getPreferredAvailabilityZone() + ",");
        }
        if (this.getCacheClusterCreateTime() != null) {
            sb.append("CacheClusterCreateTime: " + this.getCacheClusterCreateTime() + ",");
        }
        if (this.getPreferredMaintenanceWindow() != null) {
            sb.append("PreferredMaintenanceWindow: " + this.getPreferredMaintenanceWindow() + ",");
        }
        if (this.getTopicArn() != null) {
            sb.append("TopicArn: " + this.getTopicArn() + ",");
        }
        if (this.getPort() != null) {
            sb.append("Port: " + this.getPort() + ",");
        }
        if (this.getCacheParameterGroupName() != null) {
            sb.append("CacheParameterGroupName: " + this.getCacheParameterGroupName() + ",");
        }
        if (this.getCacheSubnetGroupName() != null) {
            sb.append("CacheSubnetGroupName: " + this.getCacheSubnetGroupName() + ",");
        }
        if (this.getVpcId() != null) {
            sb.append("VpcId: " + this.getVpcId() + ",");
        }
        if (this.isAutoMinorVersionUpgrade() != null) {
            sb.append("AutoMinorVersionUpgrade: " + this.isAutoMinorVersionUpgrade() + ",");
        }
        if (this.getSnapshotRetentionLimit() != null) {
            sb.append("SnapshotRetentionLimit: " + this.getSnapshotRetentionLimit() + ",");
        }
        if (this.getSnapshotWindow() != null) {
            sb.append("SnapshotWindow: " + this.getSnapshotWindow() + ",");
        }
        if (this.getNodeSnapshots() != null) {
            sb.append("NodeSnapshots: " + this.getNodeSnapshots());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSnapshotName() == null ? 0 : this.getSnapshotName().hashCode());
        hashCode = 31 * hashCode + (this.getCacheClusterId() == null ? 0 : this.getCacheClusterId().hashCode());
        hashCode = 31 * hashCode + (this.getSnapshotStatus() == null ? 0 : this.getSnapshotStatus().hashCode());
        hashCode = 31 * hashCode + (this.getSnapshotSource() == null ? 0 : this.getSnapshotSource().hashCode());
        hashCode = 31 * hashCode + (this.getCacheNodeType() == null ? 0 : this.getCacheNodeType().hashCode());
        hashCode = 31 * hashCode + (this.getEngine() == null ? 0 : this.getEngine().hashCode());
        hashCode = 31 * hashCode + (this.getEngineVersion() == null ? 0 : this.getEngineVersion().hashCode());
        hashCode = 31 * hashCode + (this.getNumCacheNodes() == null ? 0 : this.getNumCacheNodes().hashCode());
        hashCode = 31 * hashCode + (this.getPreferredAvailabilityZone() == null ? 0 : this.getPreferredAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.getCacheClusterCreateTime() == null ? 0 : this.getCacheClusterCreateTime().hashCode());
        hashCode = 31 * hashCode + (this.getPreferredMaintenanceWindow() == null ? 0 : this.getPreferredMaintenanceWindow().hashCode());
        hashCode = 31 * hashCode + (this.getTopicArn() == null ? 0 : this.getTopicArn().hashCode());
        hashCode = 31 * hashCode + (this.getPort() == null ? 0 : this.getPort().hashCode());
        hashCode = 31 * hashCode + (this.getCacheParameterGroupName() == null ? 0 : this.getCacheParameterGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getCacheSubnetGroupName() == null ? 0 : this.getCacheSubnetGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getVpcId() == null ? 0 : this.getVpcId().hashCode());
        hashCode = 31 * hashCode + (this.isAutoMinorVersionUpgrade() == null ? 0 : this.isAutoMinorVersionUpgrade().hashCode());
        hashCode = 31 * hashCode + (this.getSnapshotRetentionLimit() == null ? 0 : this.getSnapshotRetentionLimit().hashCode());
        hashCode = 31 * hashCode + (this.getSnapshotWindow() == null ? 0 : this.getSnapshotWindow().hashCode());
        hashCode = 31 * hashCode + (this.getNodeSnapshots() == null ? 0 : this.getNodeSnapshots().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Snapshot)) {
            return false;
        }
        Snapshot other = (Snapshot)obj;
        if (other.getSnapshotName() == null ^ this.getSnapshotName() == null) {
            return false;
        }
        if (other.getSnapshotName() != null && !other.getSnapshotName().equals(this.getSnapshotName())) {
            return false;
        }
        if (other.getCacheClusterId() == null ^ this.getCacheClusterId() == null) {
            return false;
        }
        if (other.getCacheClusterId() != null && !other.getCacheClusterId().equals(this.getCacheClusterId())) {
            return false;
        }
        if (other.getSnapshotStatus() == null ^ this.getSnapshotStatus() == null) {
            return false;
        }
        if (other.getSnapshotStatus() != null && !other.getSnapshotStatus().equals(this.getSnapshotStatus())) {
            return false;
        }
        if (other.getSnapshotSource() == null ^ this.getSnapshotSource() == null) {
            return false;
        }
        if (other.getSnapshotSource() != null && !other.getSnapshotSource().equals(this.getSnapshotSource())) {
            return false;
        }
        if (other.getCacheNodeType() == null ^ this.getCacheNodeType() == null) {
            return false;
        }
        if (other.getCacheNodeType() != null && !other.getCacheNodeType().equals(this.getCacheNodeType())) {
            return false;
        }
        if (other.getEngine() == null ^ this.getEngine() == null) {
            return false;
        }
        if (other.getEngine() != null && !other.getEngine().equals(this.getEngine())) {
            return false;
        }
        if (other.getEngineVersion() == null ^ this.getEngineVersion() == null) {
            return false;
        }
        if (other.getEngineVersion() != null && !other.getEngineVersion().equals(this.getEngineVersion())) {
            return false;
        }
        if (other.getNumCacheNodes() == null ^ this.getNumCacheNodes() == null) {
            return false;
        }
        if (other.getNumCacheNodes() != null && !other.getNumCacheNodes().equals(this.getNumCacheNodes())) {
            return false;
        }
        if (other.getPreferredAvailabilityZone() == null ^ this.getPreferredAvailabilityZone() == null) {
            return false;
        }
        if (other.getPreferredAvailabilityZone() != null && !other.getPreferredAvailabilityZone().equals(this.getPreferredAvailabilityZone())) {
            return false;
        }
        if (other.getCacheClusterCreateTime() == null ^ this.getCacheClusterCreateTime() == null) {
            return false;
        }
        if (other.getCacheClusterCreateTime() != null && !other.getCacheClusterCreateTime().equals(this.getCacheClusterCreateTime())) {
            return false;
        }
        if (other.getPreferredMaintenanceWindow() == null ^ this.getPreferredMaintenanceWindow() == null) {
            return false;
        }
        if (other.getPreferredMaintenanceWindow() != null && !other.getPreferredMaintenanceWindow().equals(this.getPreferredMaintenanceWindow())) {
            return false;
        }
        if (other.getTopicArn() == null ^ this.getTopicArn() == null) {
            return false;
        }
        if (other.getTopicArn() != null && !other.getTopicArn().equals(this.getTopicArn())) {
            return false;
        }
        if (other.getPort() == null ^ this.getPort() == null) {
            return false;
        }
        if (other.getPort() != null && !other.getPort().equals(this.getPort())) {
            return false;
        }
        if (other.getCacheParameterGroupName() == null ^ this.getCacheParameterGroupName() == null) {
            return false;
        }
        if (other.getCacheParameterGroupName() != null && !other.getCacheParameterGroupName().equals(this.getCacheParameterGroupName())) {
            return false;
        }
        if (other.getCacheSubnetGroupName() == null ^ this.getCacheSubnetGroupName() == null) {
            return false;
        }
        if (other.getCacheSubnetGroupName() != null && !other.getCacheSubnetGroupName().equals(this.getCacheSubnetGroupName())) {
            return false;
        }
        if (other.getVpcId() == null ^ this.getVpcId() == null) {
            return false;
        }
        if (other.getVpcId() != null && !other.getVpcId().equals(this.getVpcId())) {
            return false;
        }
        if (other.isAutoMinorVersionUpgrade() == null ^ this.isAutoMinorVersionUpgrade() == null) {
            return false;
        }
        if (other.isAutoMinorVersionUpgrade() != null && !other.isAutoMinorVersionUpgrade().equals(this.isAutoMinorVersionUpgrade())) {
            return false;
        }
        if (other.getSnapshotRetentionLimit() == null ^ this.getSnapshotRetentionLimit() == null) {
            return false;
        }
        if (other.getSnapshotRetentionLimit() != null && !other.getSnapshotRetentionLimit().equals(this.getSnapshotRetentionLimit())) {
            return false;
        }
        if (other.getSnapshotWindow() == null ^ this.getSnapshotWindow() == null) {
            return false;
        }
        if (other.getSnapshotWindow() != null && !other.getSnapshotWindow().equals(this.getSnapshotWindow())) {
            return false;
        }
        if (other.getNodeSnapshots() == null ^ this.getNodeSnapshots() == null) {
            return false;
        }
        return other.getNodeSnapshots() == null || other.getNodeSnapshots().equals(this.getNodeSnapshots());
    }
}

