/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticache.model.CreateUserGroupRequest;
import com.amazonaws.services.elasticache.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateUserGroupRequestMarshaller
implements Marshaller<Request<CreateUserGroupRequest>, CreateUserGroupRequest> {
    public Request<CreateUserGroupRequest> marshall(CreateUserGroupRequest createUserGroupRequest) {
        if (createUserGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createUserGroupRequest, "AmazonElastiCache");
        request.addParameter("Action", "CreateUserGroup");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (createUserGroupRequest.getUserGroupId() != null) {
            request.addParameter("UserGroupId", StringUtils.fromString((String)createUserGroupRequest.getUserGroupId()));
        }
        if (createUserGroupRequest.getEngine() != null) {
            request.addParameter("Engine", StringUtils.fromString((String)createUserGroupRequest.getEngine()));
        }
        if (!createUserGroupRequest.getUserIds().isEmpty() || !((SdkInternalList)createUserGroupRequest.getUserIds()).isAutoConstruct()) {
            SdkInternalList userIdsList = (SdkInternalList)createUserGroupRequest.getUserIds();
            int userIdsListIndex = 1;
            for (String userIdsListValue : userIdsList) {
                if (userIdsListValue != null) {
                    request.addParameter("UserIds.member." + userIdsListIndex, StringUtils.fromString((String)userIdsListValue));
                }
                ++userIdsListIndex;
            }
        }
        if (!createUserGroupRequest.getTags().isEmpty() || !((SdkInternalList)createUserGroupRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)createUserGroupRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue != null) {
                    if (tagsListValue.getKey() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.getKey()));
                    }
                    if (tagsListValue.getValue() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.getValue()));
                    }
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

