/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datazone.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.datazone.model.DeploymentStatus;
import com.amazonaws.services.datazone.model.DeploymentType;
import com.amazonaws.services.datazone.model.EnvironmentError;
import com.amazonaws.services.datazone.model.transform.DeploymentMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Deployment
implements Serializable,
Cloneable,
StructuredPojo {
    private String deploymentId;
    private String deploymentStatus;
    private String deploymentType;
    private EnvironmentError failureReason;
    private Boolean isDeploymentComplete;
    private List<String> messages;

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public Deployment withDeploymentId(String deploymentId) {
        this.setDeploymentId(deploymentId);
        return this;
    }

    public void setDeploymentStatus(String deploymentStatus) {
        this.deploymentStatus = deploymentStatus;
    }

    public String getDeploymentStatus() {
        return this.deploymentStatus;
    }

    public Deployment withDeploymentStatus(String deploymentStatus) {
        this.setDeploymentStatus(deploymentStatus);
        return this;
    }

    public Deployment withDeploymentStatus(DeploymentStatus deploymentStatus) {
        this.deploymentStatus = deploymentStatus.toString();
        return this;
    }

    public void setDeploymentType(String deploymentType) {
        this.deploymentType = deploymentType;
    }

    public String getDeploymentType() {
        return this.deploymentType;
    }

    public Deployment withDeploymentType(String deploymentType) {
        this.setDeploymentType(deploymentType);
        return this;
    }

    public Deployment withDeploymentType(DeploymentType deploymentType) {
        this.deploymentType = deploymentType.toString();
        return this;
    }

    public void setFailureReason(EnvironmentError failureReason) {
        this.failureReason = failureReason;
    }

    public EnvironmentError getFailureReason() {
        return this.failureReason;
    }

    public Deployment withFailureReason(EnvironmentError failureReason) {
        this.setFailureReason(failureReason);
        return this;
    }

    public void setIsDeploymentComplete(Boolean isDeploymentComplete) {
        this.isDeploymentComplete = isDeploymentComplete;
    }

    public Boolean getIsDeploymentComplete() {
        return this.isDeploymentComplete;
    }

    public Deployment withIsDeploymentComplete(Boolean isDeploymentComplete) {
        this.setIsDeploymentComplete(isDeploymentComplete);
        return this;
    }

    public Boolean isDeploymentComplete() {
        return this.isDeploymentComplete;
    }

    public List<String> getMessages() {
        return this.messages;
    }

    public void setMessages(Collection<String> messages) {
        if (messages == null) {
            this.messages = null;
            return;
        }
        this.messages = new ArrayList<String>(messages);
    }

    public Deployment withMessages(String ... messages) {
        if (this.messages == null) {
            this.setMessages(new ArrayList<String>(messages.length));
        }
        for (String ele : messages) {
            this.messages.add(ele);
        }
        return this;
    }

    public Deployment withMessages(Collection<String> messages) {
        this.setMessages(messages);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDeploymentId() != null) {
            sb.append("DeploymentId: ").append(this.getDeploymentId()).append(",");
        }
        if (this.getDeploymentStatus() != null) {
            sb.append("DeploymentStatus: ").append(this.getDeploymentStatus()).append(",");
        }
        if (this.getDeploymentType() != null) {
            sb.append("DeploymentType: ").append(this.getDeploymentType()).append(",");
        }
        if (this.getFailureReason() != null) {
            sb.append("FailureReason: ").append(this.getFailureReason()).append(",");
        }
        if (this.getIsDeploymentComplete() != null) {
            sb.append("IsDeploymentComplete: ").append(this.getIsDeploymentComplete()).append(",");
        }
        if (this.getMessages() != null) {
            sb.append("Messages: ").append(this.getMessages());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Deployment)) {
            return false;
        }
        Deployment other = (Deployment)obj;
        if (other.getDeploymentId() == null ^ this.getDeploymentId() == null) {
            return false;
        }
        if (other.getDeploymentId() != null && !other.getDeploymentId().equals(this.getDeploymentId())) {
            return false;
        }
        if (other.getDeploymentStatus() == null ^ this.getDeploymentStatus() == null) {
            return false;
        }
        if (other.getDeploymentStatus() != null && !other.getDeploymentStatus().equals(this.getDeploymentStatus())) {
            return false;
        }
        if (other.getDeploymentType() == null ^ this.getDeploymentType() == null) {
            return false;
        }
        if (other.getDeploymentType() != null && !other.getDeploymentType().equals(this.getDeploymentType())) {
            return false;
        }
        if (other.getFailureReason() == null ^ this.getFailureReason() == null) {
            return false;
        }
        if (other.getFailureReason() != null && !other.getFailureReason().equals(this.getFailureReason())) {
            return false;
        }
        if (other.getIsDeploymentComplete() == null ^ this.getIsDeploymentComplete() == null) {
            return false;
        }
        if (other.getIsDeploymentComplete() != null && !other.getIsDeploymentComplete().equals(this.getIsDeploymentComplete())) {
            return false;
        }
        if (other.getMessages() == null ^ this.getMessages() == null) {
            return false;
        }
        return other.getMessages() == null || other.getMessages().equals(this.getMessages());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDeploymentId() == null ? 0 : this.getDeploymentId().hashCode());
        hashCode = 31 * hashCode + (this.getDeploymentStatus() == null ? 0 : this.getDeploymentStatus().hashCode());
        hashCode = 31 * hashCode + (this.getDeploymentType() == null ? 0 : this.getDeploymentType().hashCode());
        hashCode = 31 * hashCode + (this.getFailureReason() == null ? 0 : this.getFailureReason().hashCode());
        hashCode = 31 * hashCode + (this.getIsDeploymentComplete() == null ? 0 : this.getIsDeploymentComplete().hashCode());
        hashCode = 31 * hashCode + (this.getMessages() == null ? 0 : this.getMessages().hashCode());
        return hashCode;
    }

    public Deployment clone() {
        try {
            return (Deployment)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeploymentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

