/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connect.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.connect.model.AttachedFile;
import com.amazonaws.services.connect.model.AttachedFileError;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchGetAttachedFileMetadataResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<AttachedFile> files;
    private List<AttachedFileError> errors;

    public List<AttachedFile> getFiles() {
        return this.files;
    }

    public void setFiles(Collection<AttachedFile> files) {
        if (files == null) {
            this.files = null;
            return;
        }
        this.files = new ArrayList<AttachedFile>(files);
    }

    public BatchGetAttachedFileMetadataResult withFiles(AttachedFile ... files) {
        if (this.files == null) {
            this.setFiles(new ArrayList<AttachedFile>(files.length));
        }
        for (AttachedFile ele : files) {
            this.files.add(ele);
        }
        return this;
    }

    public BatchGetAttachedFileMetadataResult withFiles(Collection<AttachedFile> files) {
        this.setFiles(files);
        return this;
    }

    public List<AttachedFileError> getErrors() {
        return this.errors;
    }

    public void setErrors(Collection<AttachedFileError> errors) {
        if (errors == null) {
            this.errors = null;
            return;
        }
        this.errors = new ArrayList<AttachedFileError>(errors);
    }

    public BatchGetAttachedFileMetadataResult withErrors(AttachedFileError ... errors) {
        if (this.errors == null) {
            this.setErrors(new ArrayList<AttachedFileError>(errors.length));
        }
        for (AttachedFileError ele : errors) {
            this.errors.add(ele);
        }
        return this;
    }

    public BatchGetAttachedFileMetadataResult withErrors(Collection<AttachedFileError> errors) {
        this.setErrors(errors);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFiles() != null) {
            sb.append("Files: ").append(this.getFiles()).append(",");
        }
        if (this.getErrors() != null) {
            sb.append("Errors: ").append(this.getErrors());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetAttachedFileMetadataResult)) {
            return false;
        }
        BatchGetAttachedFileMetadataResult other = (BatchGetAttachedFileMetadataResult)obj;
        if (other.getFiles() == null ^ this.getFiles() == null) {
            return false;
        }
        if (other.getFiles() != null && !other.getFiles().equals(this.getFiles())) {
            return false;
        }
        if (other.getErrors() == null ^ this.getErrors() == null) {
            return false;
        }
        return other.getErrors() == null || other.getErrors().equals(this.getErrors());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFiles() == null ? 0 : this.getFiles().hashCode());
        hashCode = 31 * hashCode + (this.getErrors() == null ? 0 : this.getErrors().hashCode());
        return hashCode;
    }

    public BatchGetAttachedFileMetadataResult clone() {
        try {
            return (BatchGetAttachedFileMetadataResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

