/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codepipeline.model.ArtifactDetail;
import com.amazonaws.services.codepipeline.model.RuleTypeId;
import com.amazonaws.services.codepipeline.model.transform.RuleExecutionInputMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RuleExecutionInput
implements Serializable,
Cloneable,
StructuredPojo {
    private RuleTypeId ruleTypeId;
    private Map<String, String> configuration;
    private Map<String, String> resolvedConfiguration;
    private String roleArn;
    private String region;
    private List<ArtifactDetail> inputArtifacts;

    public void setRuleTypeId(RuleTypeId ruleTypeId) {
        this.ruleTypeId = ruleTypeId;
    }

    public RuleTypeId getRuleTypeId() {
        return this.ruleTypeId;
    }

    public RuleExecutionInput withRuleTypeId(RuleTypeId ruleTypeId) {
        this.setRuleTypeId(ruleTypeId);
        return this;
    }

    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Map<String, String> configuration) {
        this.configuration = configuration;
    }

    public RuleExecutionInput withConfiguration(Map<String, String> configuration) {
        this.setConfiguration(configuration);
        return this;
    }

    public RuleExecutionInput addConfigurationEntry(String key, String value) {
        if (null == this.configuration) {
            this.configuration = new HashMap<String, String>();
        }
        if (this.configuration.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.configuration.put(key, value);
        return this;
    }

    public RuleExecutionInput clearConfigurationEntries() {
        this.configuration = null;
        return this;
    }

    public Map<String, String> getResolvedConfiguration() {
        return this.resolvedConfiguration;
    }

    public void setResolvedConfiguration(Map<String, String> resolvedConfiguration) {
        this.resolvedConfiguration = resolvedConfiguration;
    }

    public RuleExecutionInput withResolvedConfiguration(Map<String, String> resolvedConfiguration) {
        this.setResolvedConfiguration(resolvedConfiguration);
        return this;
    }

    public RuleExecutionInput addResolvedConfigurationEntry(String key, String value) {
        if (null == this.resolvedConfiguration) {
            this.resolvedConfiguration = new HashMap<String, String>();
        }
        if (this.resolvedConfiguration.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.resolvedConfiguration.put(key, value);
        return this;
    }

    public RuleExecutionInput clearResolvedConfigurationEntries() {
        this.resolvedConfiguration = null;
        return this;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public RuleExecutionInput withRoleArn(String roleArn) {
        this.setRoleArn(roleArn);
        return this;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getRegion() {
        return this.region;
    }

    public RuleExecutionInput withRegion(String region) {
        this.setRegion(region);
        return this;
    }

    public List<ArtifactDetail> getInputArtifacts() {
        return this.inputArtifacts;
    }

    public void setInputArtifacts(Collection<ArtifactDetail> inputArtifacts) {
        if (inputArtifacts == null) {
            this.inputArtifacts = null;
            return;
        }
        this.inputArtifacts = new ArrayList<ArtifactDetail>(inputArtifacts);
    }

    public RuleExecutionInput withInputArtifacts(ArtifactDetail ... inputArtifacts) {
        if (this.inputArtifacts == null) {
            this.setInputArtifacts(new ArrayList<ArtifactDetail>(inputArtifacts.length));
        }
        for (ArtifactDetail ele : inputArtifacts) {
            this.inputArtifacts.add(ele);
        }
        return this;
    }

    public RuleExecutionInput withInputArtifacts(Collection<ArtifactDetail> inputArtifacts) {
        this.setInputArtifacts(inputArtifacts);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRuleTypeId() != null) {
            sb.append("RuleTypeId: ").append(this.getRuleTypeId()).append(",");
        }
        if (this.getConfiguration() != null) {
            sb.append("Configuration: ").append(this.getConfiguration()).append(",");
        }
        if (this.getResolvedConfiguration() != null) {
            sb.append("ResolvedConfiguration: ").append(this.getResolvedConfiguration()).append(",");
        }
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: ").append(this.getRoleArn()).append(",");
        }
        if (this.getRegion() != null) {
            sb.append("Region: ").append(this.getRegion()).append(",");
        }
        if (this.getInputArtifacts() != null) {
            sb.append("InputArtifacts: ").append(this.getInputArtifacts());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleExecutionInput)) {
            return false;
        }
        RuleExecutionInput other = (RuleExecutionInput)obj;
        if (other.getRuleTypeId() == null ^ this.getRuleTypeId() == null) {
            return false;
        }
        if (other.getRuleTypeId() != null && !other.getRuleTypeId().equals(this.getRuleTypeId())) {
            return false;
        }
        if (other.getConfiguration() == null ^ this.getConfiguration() == null) {
            return false;
        }
        if (other.getConfiguration() != null && !other.getConfiguration().equals(this.getConfiguration())) {
            return false;
        }
        if (other.getResolvedConfiguration() == null ^ this.getResolvedConfiguration() == null) {
            return false;
        }
        if (other.getResolvedConfiguration() != null && !other.getResolvedConfiguration().equals(this.getResolvedConfiguration())) {
            return false;
        }
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        if (other.getRoleArn() != null && !other.getRoleArn().equals(this.getRoleArn())) {
            return false;
        }
        if (other.getRegion() == null ^ this.getRegion() == null) {
            return false;
        }
        if (other.getRegion() != null && !other.getRegion().equals(this.getRegion())) {
            return false;
        }
        if (other.getInputArtifacts() == null ^ this.getInputArtifacts() == null) {
            return false;
        }
        return other.getInputArtifacts() == null || other.getInputArtifacts().equals(this.getInputArtifacts());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRuleTypeId() == null ? 0 : this.getRuleTypeId().hashCode());
        hashCode = 31 * hashCode + (this.getConfiguration() == null ? 0 : this.getConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getResolvedConfiguration() == null ? 0 : this.getResolvedConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getRegion() == null ? 0 : this.getRegion().hashCode());
        hashCode = 31 * hashCode + (this.getInputArtifacts() == null ? 0 : this.getInputArtifacts().hashCode());
        return hashCode;
    }

    public RuleExecutionInput clone() {
        try {
            return (RuleExecutionInput)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RuleExecutionInputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

