/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.ContentTypeProfileConfig;
import com.amazonaws.services.cloudfront.model.transform.ContentTypeProfilesStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class ContentTypeProfileConfigStaxUnmarshaller
implements Unmarshaller<ContentTypeProfileConfig, StaxUnmarshallerContext> {
    private static ContentTypeProfileConfigStaxUnmarshaller instance;

    public ContentTypeProfileConfig unmarshall(StaxUnmarshallerContext context) throws Exception {
        ContentTypeProfileConfig contentTypeProfileConfig = new ContentTypeProfileConfig();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return contentTypeProfileConfig;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("ForwardWhenContentTypeIsUnknown", targetDepth)) {
                    contentTypeProfileConfig.setForwardWhenContentTypeIsUnknown(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("ContentTypeProfiles", targetDepth)) continue;
                contentTypeProfileConfig.setContentTypeProfiles(ContentTypeProfilesStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return contentTypeProfileConfig;
    }

    public static ContentTypeProfileConfigStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ContentTypeProfileConfigStaxUnmarshaller();
        }
        return instance;
    }
}

