/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.bedrock.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.bedrock.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * ProvisionedModelSummary JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ProvisionedModelSummaryJsonUnmarshaller implements Unmarshaller<ProvisionedModelSummary, JsonUnmarshallerContext> {

    public ProvisionedModelSummary unmarshall(JsonUnmarshallerContext context) throws Exception {
        ProvisionedModelSummary provisionedModelSummary = new ProvisionedModelSummary();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("provisionedModelName", targetDepth)) {
                    context.nextToken();
                    provisionedModelSummary.setProvisionedModelName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("provisionedModelArn", targetDepth)) {
                    context.nextToken();
                    provisionedModelSummary.setProvisionedModelArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("modelArn", targetDepth)) {
                    context.nextToken();
                    provisionedModelSummary.setModelArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("desiredModelArn", targetDepth)) {
                    context.nextToken();
                    provisionedModelSummary.setDesiredModelArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("foundationModelArn", targetDepth)) {
                    context.nextToken();
                    provisionedModelSummary.setFoundationModelArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("modelUnits", targetDepth)) {
                    context.nextToken();
                    provisionedModelSummary.setModelUnits(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("desiredModelUnits", targetDepth)) {
                    context.nextToken();
                    provisionedModelSummary.setDesiredModelUnits(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("status", targetDepth)) {
                    context.nextToken();
                    provisionedModelSummary.setStatus(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("commitmentDuration", targetDepth)) {
                    context.nextToken();
                    provisionedModelSummary.setCommitmentDuration(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("commitmentExpirationTime", targetDepth)) {
                    context.nextToken();
                    provisionedModelSummary.setCommitmentExpirationTime(DateJsonUnmarshallerFactory.getInstance("iso8601").unmarshall(context));
                }
                if (context.testExpression("creationTime", targetDepth)) {
                    context.nextToken();
                    provisionedModelSummary.setCreationTime(DateJsonUnmarshallerFactory.getInstance("iso8601").unmarshall(context));
                }
                if (context.testExpression("lastModifiedTime", targetDepth)) {
                    context.nextToken();
                    provisionedModelSummary.setLastModifiedTime(DateJsonUnmarshallerFactory.getInstance("iso8601").unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return provisionedModelSummary;
    }

    private static ProvisionedModelSummaryJsonUnmarshaller instance;

    public static ProvisionedModelSummaryJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new ProvisionedModelSummaryJsonUnmarshaller();
        return instance;
    }
}
