/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.outposts.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/CreateOutpost" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CreateOutpostRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    private String name;

    private String description;
    /**
     * <p>
     * The ID or the Amazon Resource Name (ARN) of the site.
     * </p>
     * <note>
     * <p>
     * In requests, Amazon Web Services Outposts accepts the Amazon Resource Name (ARN) or an ID for Outposts and sites
     * throughout the Outposts Query API. To address backwards compatibility, the parameter names <code>OutpostID</code>
     * or <code>SiteID</code> remain in use. Despite the parameter name, you can make the request with an ARN.
     * </p>
     * </note>
     */
    private String siteId;

    private String availabilityZone;

    private String availabilityZoneId;
    /**
     * <p>
     * The tags to apply to the Outpost.
     * </p>
     */
    private java.util.Map<String, String> tags;
    /**
     * <p>
     * The type of hardware for this Outpost.
     * </p>
     */
    private String supportedHardwareType;

    /**
     * @param name
     */

    public void setName(String name) {
        this.name = name;
    }

    /**
     * @return
     */

    public String getName() {
        return this.name;
    }

    /**
     * @param name
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateOutpostRequest withName(String name) {
        setName(name);
        return this;
    }

    /**
     * @param description
     */

    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * @return
     */

    public String getDescription() {
        return this.description;
    }

    /**
     * @param description
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateOutpostRequest withDescription(String description) {
        setDescription(description);
        return this;
    }

    /**
     * <p>
     * The ID or the Amazon Resource Name (ARN) of the site.
     * </p>
     * <note>
     * <p>
     * In requests, Amazon Web Services Outposts accepts the Amazon Resource Name (ARN) or an ID for Outposts and sites
     * throughout the Outposts Query API. To address backwards compatibility, the parameter names <code>OutpostID</code>
     * or <code>SiteID</code> remain in use. Despite the parameter name, you can make the request with an ARN.
     * </p>
     * </note>
     * 
     * @param siteId
     *        The ID or the Amazon Resource Name (ARN) of the site. </p> <note>
     *        <p>
     *        In requests, Amazon Web Services Outposts accepts the Amazon Resource Name (ARN) or an ID for Outposts and
     *        sites throughout the Outposts Query API. To address backwards compatibility, the parameter names
     *        <code>OutpostID</code> or <code>SiteID</code> remain in use. Despite the parameter name, you can make the
     *        request with an ARN.
     *        </p>
     */

    public void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    /**
     * <p>
     * The ID or the Amazon Resource Name (ARN) of the site.
     * </p>
     * <note>
     * <p>
     * In requests, Amazon Web Services Outposts accepts the Amazon Resource Name (ARN) or an ID for Outposts and sites
     * throughout the Outposts Query API. To address backwards compatibility, the parameter names <code>OutpostID</code>
     * or <code>SiteID</code> remain in use. Despite the parameter name, you can make the request with an ARN.
     * </p>
     * </note>
     * 
     * @return The ID or the Amazon Resource Name (ARN) of the site. </p> <note>
     *         <p>
     *         In requests, Amazon Web Services Outposts accepts the Amazon Resource Name (ARN) or an ID for Outposts
     *         and sites throughout the Outposts Query API. To address backwards compatibility, the parameter names
     *         <code>OutpostID</code> or <code>SiteID</code> remain in use. Despite the parameter name, you can make the
     *         request with an ARN.
     *         </p>
     */

    public String getSiteId() {
        return this.siteId;
    }

    /**
     * <p>
     * The ID or the Amazon Resource Name (ARN) of the site.
     * </p>
     * <note>
     * <p>
     * In requests, Amazon Web Services Outposts accepts the Amazon Resource Name (ARN) or an ID for Outposts and sites
     * throughout the Outposts Query API. To address backwards compatibility, the parameter names <code>OutpostID</code>
     * or <code>SiteID</code> remain in use. Despite the parameter name, you can make the request with an ARN.
     * </p>
     * </note>
     * 
     * @param siteId
     *        The ID or the Amazon Resource Name (ARN) of the site. </p> <note>
     *        <p>
     *        In requests, Amazon Web Services Outposts accepts the Amazon Resource Name (ARN) or an ID for Outposts and
     *        sites throughout the Outposts Query API. To address backwards compatibility, the parameter names
     *        <code>OutpostID</code> or <code>SiteID</code> remain in use. Despite the parameter name, you can make the
     *        request with an ARN.
     *        </p>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateOutpostRequest withSiteId(String siteId) {
        setSiteId(siteId);
        return this;
    }

    /**
     * @param availabilityZone
     */

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    /**
     * @return
     */

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    /**
     * @param availabilityZone
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateOutpostRequest withAvailabilityZone(String availabilityZone) {
        setAvailabilityZone(availabilityZone);
        return this;
    }

    /**
     * @param availabilityZoneId
     */

    public void setAvailabilityZoneId(String availabilityZoneId) {
        this.availabilityZoneId = availabilityZoneId;
    }

    /**
     * @return
     */

    public String getAvailabilityZoneId() {
        return this.availabilityZoneId;
    }

    /**
     * @param availabilityZoneId
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateOutpostRequest withAvailabilityZoneId(String availabilityZoneId) {
        setAvailabilityZoneId(availabilityZoneId);
        return this;
    }

    /**
     * <p>
     * The tags to apply to the Outpost.
     * </p>
     * 
     * @return The tags to apply to the Outpost.
     */

    public java.util.Map<String, String> getTags() {
        return tags;
    }

    /**
     * <p>
     * The tags to apply to the Outpost.
     * </p>
     * 
     * @param tags
     *        The tags to apply to the Outpost.
     */

    public void setTags(java.util.Map<String, String> tags) {
        this.tags = tags;
    }

    /**
     * <p>
     * The tags to apply to the Outpost.
     * </p>
     * 
     * @param tags
     *        The tags to apply to the Outpost.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateOutpostRequest withTags(java.util.Map<String, String> tags) {
        setTags(tags);
        return this;
    }

    /**
     * Add a single Tags entry
     *
     * @see CreateOutpostRequest#withTags
     * @returns a reference to this object so that method calls can be chained together.
     */

    public CreateOutpostRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new java.util.HashMap<String, String>();
        }
        if (this.tags.containsKey(key))
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        this.tags.put(key, value);
        return this;
    }

    /**
     * Removes all the entries added into Tags.
     *
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateOutpostRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    /**
     * <p>
     * The type of hardware for this Outpost.
     * </p>
     * 
     * @param supportedHardwareType
     *        The type of hardware for this Outpost.
     * @see SupportedHardwareType
     */

    public void setSupportedHardwareType(String supportedHardwareType) {
        this.supportedHardwareType = supportedHardwareType;
    }

    /**
     * <p>
     * The type of hardware for this Outpost.
     * </p>
     * 
     * @return The type of hardware for this Outpost.
     * @see SupportedHardwareType
     */

    public String getSupportedHardwareType() {
        return this.supportedHardwareType;
    }

    /**
     * <p>
     * The type of hardware for this Outpost.
     * </p>
     * 
     * @param supportedHardwareType
     *        The type of hardware for this Outpost.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see SupportedHardwareType
     */

    public CreateOutpostRequest withSupportedHardwareType(String supportedHardwareType) {
        setSupportedHardwareType(supportedHardwareType);
        return this;
    }

    /**
     * <p>
     * The type of hardware for this Outpost.
     * </p>
     * 
     * @param supportedHardwareType
     *        The type of hardware for this Outpost.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see SupportedHardwareType
     */

    public CreateOutpostRequest withSupportedHardwareType(SupportedHardwareType supportedHardwareType) {
        this.supportedHardwareType = supportedHardwareType.toString();
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getName() != null)
            sb.append("Name: ").append(getName()).append(",");
        if (getDescription() != null)
            sb.append("Description: ").append(getDescription()).append(",");
        if (getSiteId() != null)
            sb.append("SiteId: ").append(getSiteId()).append(",");
        if (getAvailabilityZone() != null)
            sb.append("AvailabilityZone: ").append(getAvailabilityZone()).append(",");
        if (getAvailabilityZoneId() != null)
            sb.append("AvailabilityZoneId: ").append(getAvailabilityZoneId()).append(",");
        if (getTags() != null)
            sb.append("Tags: ").append(getTags()).append(",");
        if (getSupportedHardwareType() != null)
            sb.append("SupportedHardwareType: ").append(getSupportedHardwareType());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CreateOutpostRequest == false)
            return false;
        CreateOutpostRequest other = (CreateOutpostRequest) obj;
        if (other.getName() == null ^ this.getName() == null)
            return false;
        if (other.getName() != null && other.getName().equals(this.getName()) == false)
            return false;
        if (other.getDescription() == null ^ this.getDescription() == null)
            return false;
        if (other.getDescription() != null && other.getDescription().equals(this.getDescription()) == false)
            return false;
        if (other.getSiteId() == null ^ this.getSiteId() == null)
            return false;
        if (other.getSiteId() != null && other.getSiteId().equals(this.getSiteId()) == false)
            return false;
        if (other.getAvailabilityZone() == null ^ this.getAvailabilityZone() == null)
            return false;
        if (other.getAvailabilityZone() != null && other.getAvailabilityZone().equals(this.getAvailabilityZone()) == false)
            return false;
        if (other.getAvailabilityZoneId() == null ^ this.getAvailabilityZoneId() == null)
            return false;
        if (other.getAvailabilityZoneId() != null && other.getAvailabilityZoneId().equals(this.getAvailabilityZoneId()) == false)
            return false;
        if (other.getTags() == null ^ this.getTags() == null)
            return false;
        if (other.getTags() != null && other.getTags().equals(this.getTags()) == false)
            return false;
        if (other.getSupportedHardwareType() == null ^ this.getSupportedHardwareType() == null)
            return false;
        if (other.getSupportedHardwareType() != null && other.getSupportedHardwareType().equals(this.getSupportedHardwareType()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getName() == null) ? 0 : getName().hashCode());
        hashCode = prime * hashCode + ((getDescription() == null) ? 0 : getDescription().hashCode());
        hashCode = prime * hashCode + ((getSiteId() == null) ? 0 : getSiteId().hashCode());
        hashCode = prime * hashCode + ((getAvailabilityZone() == null) ? 0 : getAvailabilityZone().hashCode());
        hashCode = prime * hashCode + ((getAvailabilityZoneId() == null) ? 0 : getAvailabilityZoneId().hashCode());
        hashCode = prime * hashCode + ((getTags() == null) ? 0 : getTags().hashCode());
        hashCode = prime * hashCode + ((getSupportedHardwareType() == null) ? 0 : getSupportedHardwareType().hashCode());
        return hashCode;
    }

    @Override
    public CreateOutpostRequest clone() {
        return (CreateOutpostRequest) super.clone();
    }

}
