/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.batch.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.batch.model.transform.EksContainerSecurityContextMarshaller;
import java.io.Serializable;

public class EksContainerSecurityContext
implements Serializable,
Cloneable,
StructuredPojo {
    private Long runAsUser;
    private Long runAsGroup;
    private Boolean privileged;
    private Boolean allowPrivilegeEscalation;
    private Boolean readOnlyRootFilesystem;
    private Boolean runAsNonRoot;

    public void setRunAsUser(Long runAsUser) {
        this.runAsUser = runAsUser;
    }

    public Long getRunAsUser() {
        return this.runAsUser;
    }

    public EksContainerSecurityContext withRunAsUser(Long runAsUser) {
        this.setRunAsUser(runAsUser);
        return this;
    }

    public void setRunAsGroup(Long runAsGroup) {
        this.runAsGroup = runAsGroup;
    }

    public Long getRunAsGroup() {
        return this.runAsGroup;
    }

    public EksContainerSecurityContext withRunAsGroup(Long runAsGroup) {
        this.setRunAsGroup(runAsGroup);
        return this;
    }

    public void setPrivileged(Boolean privileged) {
        this.privileged = privileged;
    }

    public Boolean getPrivileged() {
        return this.privileged;
    }

    public EksContainerSecurityContext withPrivileged(Boolean privileged) {
        this.setPrivileged(privileged);
        return this;
    }

    public Boolean isPrivileged() {
        return this.privileged;
    }

    public void setAllowPrivilegeEscalation(Boolean allowPrivilegeEscalation) {
        this.allowPrivilegeEscalation = allowPrivilegeEscalation;
    }

    public Boolean getAllowPrivilegeEscalation() {
        return this.allowPrivilegeEscalation;
    }

    public EksContainerSecurityContext withAllowPrivilegeEscalation(Boolean allowPrivilegeEscalation) {
        this.setAllowPrivilegeEscalation(allowPrivilegeEscalation);
        return this;
    }

    public Boolean isAllowPrivilegeEscalation() {
        return this.allowPrivilegeEscalation;
    }

    public void setReadOnlyRootFilesystem(Boolean readOnlyRootFilesystem) {
        this.readOnlyRootFilesystem = readOnlyRootFilesystem;
    }

    public Boolean getReadOnlyRootFilesystem() {
        return this.readOnlyRootFilesystem;
    }

    public EksContainerSecurityContext withReadOnlyRootFilesystem(Boolean readOnlyRootFilesystem) {
        this.setReadOnlyRootFilesystem(readOnlyRootFilesystem);
        return this;
    }

    public Boolean isReadOnlyRootFilesystem() {
        return this.readOnlyRootFilesystem;
    }

    public void setRunAsNonRoot(Boolean runAsNonRoot) {
        this.runAsNonRoot = runAsNonRoot;
    }

    public Boolean getRunAsNonRoot() {
        return this.runAsNonRoot;
    }

    public EksContainerSecurityContext withRunAsNonRoot(Boolean runAsNonRoot) {
        this.setRunAsNonRoot(runAsNonRoot);
        return this;
    }

    public Boolean isRunAsNonRoot() {
        return this.runAsNonRoot;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRunAsUser() != null) {
            sb.append("RunAsUser: ").append(this.getRunAsUser()).append(",");
        }
        if (this.getRunAsGroup() != null) {
            sb.append("RunAsGroup: ").append(this.getRunAsGroup()).append(",");
        }
        if (this.getPrivileged() != null) {
            sb.append("Privileged: ").append(this.getPrivileged()).append(",");
        }
        if (this.getAllowPrivilegeEscalation() != null) {
            sb.append("AllowPrivilegeEscalation: ").append(this.getAllowPrivilegeEscalation()).append(",");
        }
        if (this.getReadOnlyRootFilesystem() != null) {
            sb.append("ReadOnlyRootFilesystem: ").append(this.getReadOnlyRootFilesystem()).append(",");
        }
        if (this.getRunAsNonRoot() != null) {
            sb.append("RunAsNonRoot: ").append(this.getRunAsNonRoot());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EksContainerSecurityContext)) {
            return false;
        }
        EksContainerSecurityContext other = (EksContainerSecurityContext)obj;
        if (other.getRunAsUser() == null ^ this.getRunAsUser() == null) {
            return false;
        }
        if (other.getRunAsUser() != null && !other.getRunAsUser().equals(this.getRunAsUser())) {
            return false;
        }
        if (other.getRunAsGroup() == null ^ this.getRunAsGroup() == null) {
            return false;
        }
        if (other.getRunAsGroup() != null && !other.getRunAsGroup().equals(this.getRunAsGroup())) {
            return false;
        }
        if (other.getPrivileged() == null ^ this.getPrivileged() == null) {
            return false;
        }
        if (other.getPrivileged() != null && !other.getPrivileged().equals(this.getPrivileged())) {
            return false;
        }
        if (other.getAllowPrivilegeEscalation() == null ^ this.getAllowPrivilegeEscalation() == null) {
            return false;
        }
        if (other.getAllowPrivilegeEscalation() != null && !other.getAllowPrivilegeEscalation().equals(this.getAllowPrivilegeEscalation())) {
            return false;
        }
        if (other.getReadOnlyRootFilesystem() == null ^ this.getReadOnlyRootFilesystem() == null) {
            return false;
        }
        if (other.getReadOnlyRootFilesystem() != null && !other.getReadOnlyRootFilesystem().equals(this.getReadOnlyRootFilesystem())) {
            return false;
        }
        if (other.getRunAsNonRoot() == null ^ this.getRunAsNonRoot() == null) {
            return false;
        }
        return other.getRunAsNonRoot() == null || other.getRunAsNonRoot().equals(this.getRunAsNonRoot());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRunAsUser() == null ? 0 : this.getRunAsUser().hashCode());
        hashCode = 31 * hashCode + (this.getRunAsGroup() == null ? 0 : this.getRunAsGroup().hashCode());
        hashCode = 31 * hashCode + (this.getPrivileged() == null ? 0 : this.getPrivileged().hashCode());
        hashCode = 31 * hashCode + (this.getAllowPrivilegeEscalation() == null ? 0 : this.getAllowPrivilegeEscalation().hashCode());
        hashCode = 31 * hashCode + (this.getReadOnlyRootFilesystem() == null ? 0 : this.getReadOnlyRootFilesystem().hashCode());
        hashCode = 31 * hashCode + (this.getRunAsNonRoot() == null ? 0 : this.getRunAsNonRoot().hashCode());
        return hashCode;
    }

    public EksContainerSecurityContext clone() {
        try {
            return (EksContainerSecurityContext)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EksContainerSecurityContextMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

