/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dynamodb.preader;

import org.apache.hadoop.dynamodb.util.AbstractTimeSource;

class TokenBucket {
    private final double rate;
    private final double capacity;
    private final AbstractTimeSource time;
    private double tokens;
    private long lastRefill;

    TokenBucket(double refillRateInSeconds, double capacity, AbstractTimeSource time) {
        this.rate = refillRateInSeconds / 1000.0;
        this.capacity = capacity;
        this.time = time;
        this.tokens = capacity;
        this.lastRefill = time.getNanoTime();
    }

    synchronized double acquire(double minTokens, double maxTokens) {
        this.refill();
        double avail = Math.floor(Math.min(maxTokens, this.tokens));
        if (avail >= minTokens) {
            this.tokens -= avail;
            return avail;
        }
        return 0.0;
    }

    public synchronized double forceUpdate(double delta) {
        this.tokens = Math.min(this.tokens + delta, this.capacity);
        return this.tokens;
    }

    private void refill() {
        long nowNano = this.time.getNanoTime();
        long deltaMs = this.time.getTimeDeltaMs(this.lastRefill, nowNano);
        if (deltaMs < 0L) {
            return;
        }
        this.tokens = Math.min(this.tokens + (double)deltaMs * this.rate, this.capacity);
        this.lastRefill = nowNano;
    }
}

