/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.device.ads.Configuration;
import com.amazon.device.ads.JSONUtils;
import com.amazon.device.ads.Metrics;
import com.amazon.device.ads.SISRequest;
import com.amazon.device.ads.SISRequestorCallback;
import com.amazon.device.ads.WebRequest;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

class SISRequestor {
    private final SISRequest[] sisRequests;
    private final SISRequestorCallback sisRequestorCallback;
    private final WebRequest.WebRequestFactory webRequestFactory;
    private final Configuration configuration;
    protected static final String API_LEVEL_ENDPOINT = "/api3";

    public SISRequestor(SISRequestorCallback sisRequestorCallback, SISRequest ... sisRequests) {
        this(new WebRequest.WebRequestFactory(), sisRequestorCallback, Configuration.getInstance(), sisRequests);
    }

    SISRequestor(WebRequest.WebRequestFactory webRequestFactory, SISRequestorCallback sisRequestorCallback, Configuration configuration, SISRequest ... sisRequests) {
        this.webRequestFactory = webRequestFactory;
        this.sisRequestorCallback = sisRequestorCallback;
        this.configuration = configuration;
        this.sisRequests = sisRequests;
    }

    private String getSISEndPoint() {
        String reply = this.configuration.getString(Configuration.ConfigOption.SIS_URL);
        if (reply == null || reply.isEmpty()) {
            reply = "s.amazon-adsystem.com";
        }
        return reply;
    }

    public void startCallSIS() {
        for (SISRequest sisRequest : this.sisRequests) {
            this.callSIS(sisRequest);
        }
        SISRequestorCallback sisRequestorCallback = this.getSisRequestorCallback();
        if (sisRequestorCallback != null) {
            sisRequestorCallback.onSISCallComplete();
        }
    }

    private void callSIS(SISRequest sisRequest) {
        WebRequest.WebResponse response;
        WebRequest request = this.getWebRequest(sisRequest);
        try {
            response = request.makeCall();
        }
        catch (WebRequest.WebRequestException e) {
            return;
        }
        JSONObject jsonPayload = response.getResponseReader().readAsJSON();
        if (jsonPayload == null) {
            return;
        }
        int rcode = JSONUtils.getIntegerFromJSON(jsonPayload, "rcode", 0);
        String msg = JSONUtils.getStringFromJSON(jsonPayload, "msg", "");
        if (rcode == 1 || rcode == 103 || rcode == 101 && msg.equals("103")) {
            sisRequest.getLogger().i("Result - code: %d, msg: %s", rcode, msg);
            sisRequest.onResponseReceived(jsonPayload);
        } else {
            sisRequest.getLogger().w("Result - code: %d, msg: %s", rcode, msg);
        }
    }

    private WebRequest getWebRequest(SISRequest sisRequest) {
        WebRequest request = this.webRequestFactory.createWebRequest();
        request.setExternalLogTag(sisRequest.getLogTag());
        request.setHttpMethod(WebRequest.HttpMethod.POST);
        request.setHost(this.getHostname());
        request.setPath(this.getEndpoint(sisRequest));
        request.enableLog(true);
        HashMap<String, String> postParameters = sisRequest.getPostParameters();
        if (postParameters != null) {
            for (Map.Entry<String, String> postParameter : postParameters.entrySet()) {
                request.putPostParameter(postParameter.getKey(), postParameter.getValue());
            }
        }
        WebRequest.QueryStringParameters queryStringParameters = sisRequest.getQueryParameters();
        request.setQueryStringParameters(queryStringParameters);
        request.setMetricsCollector(Metrics.getInstance().getMetricsCollector());
        request.setServiceCallLatencyMetric(sisRequest.getCallMetricType());
        return request;
    }

    private String getHostname() {
        int endpointIndex;
        String hostname = this.getSISEndPoint();
        if (hostname != null && (endpointIndex = hostname.indexOf("/")) > -1) {
            hostname = hostname.substring(0, endpointIndex);
        }
        return hostname;
    }

    private String getEndpoint(SISRequest sisRequest) {
        String endpoint = this.getSISEndPoint();
        if (endpoint != null) {
            int endpointIndex = endpoint.indexOf("/");
            endpoint = endpointIndex > -1 ? endpoint.substring(endpointIndex) : "";
        }
        endpoint = endpoint + API_LEVEL_ENDPOINT + sisRequest.getPath();
        return endpoint;
    }

    private SISRequestorCallback getSisRequestorCallback() {
        return this.sisRequestorCallback;
    }

    static class SISRequestorFactory {
        SISRequestorFactory() {
        }

        public SISRequestor createSISRequestor(SISRequest ... sisRequests) {
            return this.createSISRequestor((SISRequestorCallback)null, sisRequests);
        }

        public SISRequestor createSISRequestor(SISRequestorCallback sisRequestorCallback, SISRequest ... sisRequests) {
            return new SISRequestor(sisRequestorCallback, sisRequests);
        }
    }
}

