/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.device.ads.AdvertisingIdentifier;
import com.amazon.device.ads.DebugProperties;
import com.amazon.device.ads.Settings;
import com.amazon.device.ads.StringUtils;
import com.amazon.device.ads.WebUtils;

class RegistrationInfo {
    private static final String THIRD_PARTY_APP_NAME = "app";
    private static final String ADID_PREF_NAME = "amzn-ad-id";
    private static final String ADID_ORIGIN_PREF_NAME = "amzn-ad-id-origin";
    private static final String NEW_SIS_DID_REQUESTED_SETTING = "newSISDIDRequested";
    private static final String NON_ADVERTISING_IDENTIFIER_ORIGIN = "non-advertising-identifier";
    private static final String SIS_REGISTRATION_STATUS = "sis_registration_status";
    private String appKey;
    private String appName = "app";

    public String getAppName() {
        return this.appName;
    }

    public void putAppName(String appName) {
        this.appName = WebUtils.getURLEncodedString(appName);
    }

    public String getAdId() {
        return DebugProperties.getInstance().getDebugPropertyAsString("debug.adid", Settings.getInstance().getString(ADID_PREF_NAME, null));
    }

    public boolean isAdIdCurrent(AdvertisingIdentifier.Info advertisingIdentifierInfo) {
        boolean isAdIdOriginatedFromNonAdvertisingIdentifier = RegistrationInfo.isAdIdOriginatedFromNonAdvertisingIdentifier();
        if (advertisingIdentifierInfo.hasAdvertisingIdentifier()) {
            if (isAdIdOriginatedFromNonAdvertisingIdentifier) {
                return false;
            }
            String origin = Settings.getInstance().getString(ADID_ORIGIN_PREF_NAME, null);
            return advertisingIdentifierInfo.getAdvertisingIdentifier().equals(origin);
        }
        return isAdIdOriginatedFromNonAdvertisingIdentifier;
    }

    public boolean hasAdId() {
        return !StringUtils.isNullOrEmpty(this.getAdId());
    }

    public void putAdId(String adId, AdvertisingIdentifier.Info advertisingIdentifierInfo) {
        Settings settings = Settings.getInstance();
        settings.putStringWithNoFlush(ADID_PREF_NAME, adId);
        RegistrationInfo.setOrigin(advertisingIdentifierInfo);
        settings.putBooleanWithNoFlush(NEW_SIS_DID_REQUESTED_SETTING, false);
        settings.flush();
    }

    protected void setSISRegistrationStatus() {
        Settings.getInstance().putBoolean(SIS_REGISTRATION_STATUS, true);
    }

    protected void removeAdId(AdvertisingIdentifier.Info advertisingIdentifierInfo) {
        Settings settings = Settings.getInstance();
        settings.remove(ADID_PREF_NAME);
        RegistrationInfo.setOrigin(advertisingIdentifierInfo);
        settings.putBooleanWithNoFlush(NEW_SIS_DID_REQUESTED_SETTING, false);
        settings.flush();
    }

    protected static void setOrigin(AdvertisingIdentifier.Info advertisingIdentifierInfo) {
        if (advertisingIdentifierInfo.hasAdvertisingIdentifier()) {
            Settings.getInstance().putStringWithNoFlush(ADID_ORIGIN_PREF_NAME, advertisingIdentifierInfo.getAdvertisingIdentifier());
        } else {
            Settings.getInstance().putStringWithNoFlush(ADID_ORIGIN_PREF_NAME, NON_ADVERTISING_IDENTIFIER_ORIGIN);
        }
    }

    public static boolean isAdIdOriginatedFromNonAdvertisingIdentifier() {
        String storedOrigin = Settings.getInstance().getString(ADID_ORIGIN_PREF_NAME, null);
        return storedOrigin == null || NON_ADVERTISING_IDENTIFIER_ORIGIN.equals(storedOrigin);
    }

    public String getAppKey() {
        return DebugProperties.getInstance().getDebugPropertyAsString("debug.appid", this.appKey);
    }

    public void putAppKey(String appKey) {
        if (appKey == null || appKey.length() == 0) {
            throw new IllegalArgumentException("Application Key must not be null or empty.");
        }
        this.appKey = WebUtils.getURLEncodedString(appKey);
    }

    public void requestNewSISDeviceIdentifier() {
        Settings.getInstance().putBoolean(NEW_SIS_DID_REQUESTED_SETTING, true);
    }

    public boolean shouldGetNewSISDeviceIdentifer() {
        return Settings.getInstance().getBoolean(NEW_SIS_DID_REQUESTED_SETTING, false);
    }

    public boolean isRegisteredWithSIS() {
        return this.hasAdId();
    }

    public boolean shouldGetNewSISRegistration() {
        return !Settings.getInstance().getBoolean(SIS_REGISTRATION_STATUS, false);
    }
}

