/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.RelativeLayout;
import com.amazon.device.ads.AdActivity;
import com.amazon.device.ads.AdControlAccessor;
import com.amazon.device.ads.AdControllerFactory;
import com.amazon.device.ads.AdEvent;
import com.amazon.device.ads.AdUtils2;
import com.amazon.device.ads.AndroidBuildInfo;
import com.amazon.device.ads.AndroidTargetUtils;
import com.amazon.device.ads.DisplayUtils;
import com.amazon.device.ads.ExpandProperties;
import com.amazon.device.ads.ForceOrientation;
import com.amazon.device.ads.JSONUtils;
import com.amazon.device.ads.LayoutFactory;
import com.amazon.device.ads.MobileAdsLogger;
import com.amazon.device.ads.MobileAdsLoggerFactory;
import com.amazon.device.ads.OrientationProperties;
import com.amazon.device.ads.Position;
import com.amazon.device.ads.SDKEvent;
import com.amazon.device.ads.SDKEventListener;
import com.amazon.device.ads.Size;
import com.amazon.device.ads.StringUtils;
import com.amazon.device.ads.ViewUtils;
import org.json.JSONObject;

class ModalAdActivityAdapter
implements AdActivity.AdActivityAdapter {
    private static final String LOGTAG = ModalAdActivityAdapter.class.getSimpleName();
    private static final String CONTENT_DESCRIPTION_EXPANSION_VIEW = "expansionView";
    private static final String CONTENT_DESCRIPTION_AD_CONTAINER_VIEW = "adContainerView";
    private final MobileAdsLogger logger;
    private final AdUtils2 adUtils;
    private final JSONUtils.JSONUtilities jsonUtils;
    private final AndroidBuildInfo buildInfo;
    private final LayoutFactory layoutFactory;
    private final ViewUtils viewUtils;
    private Activity activity;
    private AdControlAccessor adControlAccessor;
    private ViewGroup expansionView;
    private ViewGroup adContainerView;
    private String url;
    private final ExpandProperties expandProperties;
    private final OrientationProperties orientationProperties;
    private Size lastReportedSize;

    public ModalAdActivityAdapter() {
        this(new MobileAdsLoggerFactory(), new AdUtils2(), new JSONUtils.JSONUtilities(), new ExpandProperties(), new OrientationProperties(), new AndroidBuildInfo(), new LayoutFactory(), new ViewUtils());
    }

    ModalAdActivityAdapter(MobileAdsLoggerFactory loggerFactory, AdUtils2 adUtils, JSONUtils.JSONUtilities jsonUtils, ExpandProperties expandProperties, OrientationProperties orientationProperties, AndroidBuildInfo buildInfo, LayoutFactory layoutFactory, ViewUtils viewUtils) {
        this.logger = loggerFactory.createMobileAdsLogger(LOGTAG);
        this.adUtils = adUtils;
        this.jsonUtils = jsonUtils;
        this.expandProperties = expandProperties;
        this.orientationProperties = orientationProperties;
        this.buildInfo = buildInfo;
        this.layoutFactory = layoutFactory;
        this.viewUtils = viewUtils;
    }

    @Override
    public void setActivity(Activity activity) {
        this.activity = activity;
    }

    @Override
    public void preOnCreate() {
        this.activity.requestWindowFeature(1);
        this.activity.getWindow().setFlags(1024, 1024);
        AndroidTargetUtils.hideActionAndStatusBars(this.buildInfo, this.activity);
    }

    @Override
    public void onCreate() {
        Intent intent = this.activity.getIntent();
        String url = intent.getStringExtra("url");
        if (!StringUtils.isNullOrWhiteSpace(url)) {
            this.url = url;
        }
        JSONObject expandPropertiesJson = this.jsonUtils.getJSONObjectFromString(intent.getStringExtra("expandProperties"));
        this.expandProperties.fromJSONObject(expandPropertiesJson);
        if (this.url != null) {
            this.expandProperties.setWidth(-1);
            this.expandProperties.setHeight(-1);
        }
        JSONObject orientationPropertiesJson = this.jsonUtils.getJSONObjectFromString(intent.getStringExtra("orientationProperties"));
        this.orientationProperties.fromJSONObject(orientationPropertiesJson);
        AndroidTargetUtils.enableHardwareAcceleration(this.buildInfo, this.activity.getWindow());
        this.adControlAccessor = AdControllerFactory.getCachedAdControlAccessor();
        if (this.adControlAccessor == null) {
            this.logger.e("Failed to show expanded ad due to an error in the Activity.");
            this.activity.finish();
            return;
        }
        this.adControlAccessor.setAdActivity(this.activity);
        this.adControlAccessor.addSDKEventListener(new ModalAdSDKEventListener());
        this.expandAd();
        this.orientationPropertyChange();
        this.adControlAccessor.fireAdEvent(new AdEvent(AdEvent.AdEventType.EXPANDED));
        this.adControlAccessor.injectJavascript("mraidBridge.stateChange('expanded');");
        this.reportSizeChangeEvent();
    }

    private void reportSizeChangeEvent() {
        this.expansionView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                ModalAdActivityAdapter.this.viewUtils.removeOnGlobalLayoutListener(ModalAdActivityAdapter.this.expansionView.getViewTreeObserver(), this);
                Position currentPosition = ModalAdActivityAdapter.this.adControlAccessor.getCurrentPosition();
                if (currentPosition == null) {
                    return;
                }
                Size currentSize = currentPosition.getSize();
                if (currentSize != null && !currentSize.equals(ModalAdActivityAdapter.this.lastReportedSize)) {
                    ModalAdActivityAdapter.this.lastReportedSize = currentSize;
                    ModalAdActivityAdapter.this.adControlAccessor.injectJavascript("mraidBridge.sizeChange(" + currentSize.getWidth() + "," + currentSize.getHeight() + ");");
                }
            }
        });
    }

    private void orientationPropertyChange() {
        if (!this.adControlAccessor.isVisible() || !this.adControlAccessor.isModal()) {
            return;
        }
        if (this.activity == null) {
            this.logger.e("unable to handle orientation property change because the context did not contain an activity");
            return;
        }
        int originalOrientation = this.activity.getRequestedOrientation();
        this.logger.d("Current Orientation: " + originalOrientation);
        switch (this.orientationProperties.getForceOrientation()) {
            case PORTRAIT: {
                this.activity.setRequestedOrientation(7);
                break;
            }
            case LANDSCAPE: {
                this.activity.setRequestedOrientation(6);
                break;
            }
        }
        if (ForceOrientation.NONE.equals((Object)this.orientationProperties.getForceOrientation())) {
            if (this.orientationProperties.isAllowOrientationChange().booleanValue()) {
                this.activity.setRequestedOrientation(-1);
            } else {
                this.activity.setRequestedOrientation(DisplayUtils.determineCanonicalScreenOrientation((Context)this.activity, this.buildInfo));
            }
        }
        int newOrientation = this.activity.getRequestedOrientation();
        this.logger.d("New Orientation: " + newOrientation);
        if (newOrientation != originalOrientation) {
            this.reportSizeChangeEvent();
        }
    }

    @Override
    public void onPause() {
    }

    @Override
    public void onResume() {
    }

    @Override
    public void onStop() {
        if (this.activity.isFinishing() && this.adControlAccessor != null) {
            this.adControlAccessor.closeAd();
        }
    }

    @Override
    public void onDestroy() {
        if (this.adControlAccessor != null) {
            this.adControlAccessor.closeAd();
        }
    }

    @Override
    public void onConfigurationChanged(Configuration configuration) {
        this.reportSizeChangeEvent();
    }

    @Override
    public boolean onBackPressed() {
        if (this.adControlAccessor != null) {
            return this.adControlAccessor.onBackButtonPress();
        }
        return false;
    }

    @Override
    public void onWindowFocusChanged() {
    }

    private void expandAd() {
        if (this.url != null) {
            this.adControlAccessor.stashView();
        }
        Size expandSize = this.computeExpandedSizeInPixels(this.expandProperties);
        this.createExpandedView();
        this.adControlAccessor.moveViewToViewGroup(this.adContainerView, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1), true);
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(expandSize.getWidth(), expandSize.getHeight());
        lp.addRule(13);
        this.expansionView.addView((View)this.adContainerView, (ViewGroup.LayoutParams)lp);
        this.activity.setContentView((View)this.expansionView, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        this.adControlAccessor.enableCloseButton(this.expandProperties.getUseCustomClose() == false);
    }

    private void createExpandedView() {
        this.expansionView = this.layoutFactory.createLayout((Context)this.activity, LayoutFactory.LayoutType.RELATIVE_LAYOUT, CONTENT_DESCRIPTION_EXPANSION_VIEW);
        this.adContainerView = this.layoutFactory.createLayout((Context)this.activity, LayoutFactory.LayoutType.FRAME_LAYOUT, CONTENT_DESCRIPTION_AD_CONTAINER_VIEW);
    }

    private Size computeExpandedSizeInPixels(ExpandProperties expandProperties) {
        this.logger.d("Expanding Ad to " + expandProperties.getWidth() + "x" + expandProperties.getHeight());
        int pixelWidth = this.adUtils.deviceIndependentPixelToPixel(expandProperties.getWidth());
        int pixelHeight = this.adUtils.deviceIndependentPixelToPixel(expandProperties.getHeight());
        return new Size(pixelWidth, pixelHeight);
    }

    private void finishActivity() {
        if (!this.activity.isFinishing()) {
            this.adControlAccessor = null;
            this.activity.finish();
        }
    }

    private class ModalAdSDKEventListener
    implements SDKEventListener {
        private ModalAdSDKEventListener() {
        }

        @Override
        public void onSDKEvent(SDKEvent sdkEvent, AdControlAccessor controller) {
            if (sdkEvent.getEventType().equals((Object)SDKEvent.SDKEventType.CLOSED)) {
                ModalAdActivityAdapter.this.finishActivity();
            }
        }
    }
}

