/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.device.ads.AmazonFireServicesAdapter;
import com.amazon.device.ads.GooglePlayServicesAdapter;
import com.amazon.device.ads.MobileAdsLogger;
import com.amazon.device.ads.MobileAdsLoggerFactory;
import com.amazon.device.ads.ReflectionUtils;
import com.amazon.device.ads.Settings;

class GooglePlayServices {
    private static final String LOGTAG = GooglePlayServices.class.getSimpleName();
    private static final String GPS_AVAILABLE_SETTING = "gps-available";
    private final MobileAdsLogger logger;
    private final ReflectionUtils reflectionUtils;

    public GooglePlayServices() {
        this(new MobileAdsLoggerFactory(), new ReflectionUtils());
    }

    GooglePlayServices(MobileAdsLoggerFactory loggerFactory, ReflectionUtils reflectionUtils) {
        this.logger = loggerFactory.createMobileAdsLogger(LOGTAG);
        this.reflectionUtils = reflectionUtils;
    }

    public AdvertisingInfo getAdvertisingIdentifierInfo() {
        AdvertisingInfo fireAdInfo;
        GooglePlayServicesAdapter googlePlayServices;
        if (!this.isGPSAvailable()) {
            this.logger.v("The Google Play Services Advertising Identifier feature is not available.");
            return AdvertisingInfo.createNotAvailable();
        }
        if (!this.isGPSAvailableSet() && !this.isGoogleAdvertisingClassAvailable()) {
            this.logger.v("The Google Play Services Advertising Identifier feature is not available.");
            this.setGooglePlayServicesAvailable(false);
            return AdvertisingInfo.createNotAvailable();
        }
        AdvertisingInfo advertisingInfo = null;
        if (this.isGoogleAdvertisingClassAvailable() && (googlePlayServices = this.createGooglePlayServicesAdapter()) != null && (advertisingInfo = googlePlayServices.getAdvertisingIdentifierInfo()) != null && advertisingInfo.getAdvertisingIdentifier() != null && !advertisingInfo.getAdvertisingIdentifier().isEmpty()) {
            this.setGooglePlayServicesAvailable(advertisingInfo.isGPSAvailable());
            return advertisingInfo;
        }
        AmazonFireServicesAdapter fireAdapter = this.createAmazonFireServiceAdapter();
        if (fireAdapter != null && (fireAdInfo = fireAdapter.getAdvertisingIdentifierInfo()) != null && fireAdInfo.getAdvertisingIdentifier() != null && !fireAdInfo.getAdvertisingIdentifier().isEmpty()) {
            this.setGooglePlayServicesAvailable(fireAdInfo.isGPSAvailable());
            return fireAdInfo;
        }
        this.logger.v("Advertising Identifier feature is not available.");
        if (advertisingInfo == null || !advertisingInfo.gpsAvailable) {
            this.setGooglePlayServicesAvailable(false);
        }
        return advertisingInfo;
    }

    protected GooglePlayServicesAdapter createGooglePlayServicesAdapter() {
        return new GooglePlayServicesAdapter();
    }

    protected AmazonFireServicesAdapter createAmazonFireServiceAdapter() {
        return AmazonFireServicesAdapter.newAdapter();
    }

    private boolean isGoogleAdvertisingClassAvailable() {
        return this.reflectionUtils.isClassAvailable("com.google.android.gms.ads.identifier.AdvertisingIdClient");
    }

    private boolean isGPSAvailable() {
        return Settings.getInstance().getBoolean(GPS_AVAILABLE_SETTING, true);
    }

    private boolean isGPSAvailableSet() {
        return Settings.getInstance().containsKey(GPS_AVAILABLE_SETTING);
    }

    private void setGooglePlayServicesAvailable(boolean available) {
        Settings.getInstance().putTransientBoolean(GPS_AVAILABLE_SETTING, available);
    }

    static class AdvertisingInfo {
        private boolean gpsAvailable = true;
        private String advertisingIdentifier;
        private boolean limitAdTrackingEnabled;

        protected AdvertisingInfo() {
        }

        static AdvertisingInfo createNotAvailable() {
            return new AdvertisingInfo().setGPSAvailable(false);
        }

        boolean isGPSAvailable() {
            return this.gpsAvailable;
        }

        private AdvertisingInfo setGPSAvailable(boolean gpsAvailable) {
            this.gpsAvailable = gpsAvailable;
            return this;
        }

        String getAdvertisingIdentifier() {
            return this.advertisingIdentifier;
        }

        AdvertisingInfo setAdvertisingIdentifier(String advertisingIdentifier) {
            this.advertisingIdentifier = advertisingIdentifier;
            return this;
        }

        boolean hasAdvertisingIdentifier() {
            return this.getAdvertisingIdentifier() != null;
        }

        boolean isLimitAdTrackingEnabled() {
            return this.limitAdTrackingEnabled;
        }

        AdvertisingInfo setLimitAdTrackingEnabled(boolean limitAdTrackingEnabled) {
            this.limitAdTrackingEnabled = limitAdTrackingEnabled;
            return this;
        }
    }
}

