/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.content.ContentResolver;
import android.content.Context;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.amazon.device.ads.AndroidBuildInfo;
import com.amazon.device.ads.ConnectionInfo;
import com.amazon.device.ads.DisplayUtils;
import com.amazon.device.ads.JSONUtils;
import com.amazon.device.ads.MobileAdsInfoStore;
import com.amazon.device.ads.MobileAdsLogger;
import com.amazon.device.ads.MobileAdsLoggerFactory;
import com.amazon.device.ads.Size;
import com.amazon.device.ads.StringUtils;
import com.amazon.device.ads.UserAgentManager;
import com.amazon.device.ads.WebUtils;
import java.lang.reflect.Field;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;

class DeviceInfo {
    private static final String LOGTAG = DeviceInfo.class.getSimpleName();
    public static final String ORIENTATION_PORTRAIT = "portrait";
    public static final String ORIENTATION_LANDSCAPE = "landscape";
    public static final String ORIENTATION_UNKNOWN = "unknown";
    private static final String dt = "android";
    private static final String os = "Android";
    private String make = Build.MANUFACTURER;
    private String model = Build.MODEL;
    private String osVersion = Build.VERSION.RELEASE;
    private UserAgentManager userAgentManager;
    private String sha1_mac;
    private boolean bad_mac;
    private boolean macFetched;
    private String sha1_serial;
    private boolean bad_serial;
    private boolean serialFetched;
    private String sha1_udid;
    private boolean bad_udid;
    private boolean udidFetched;
    private String scalingFactorAsString;
    private float scalingFactor;
    private String carrier;
    private String country;
    private String networkCountry;
    private String language;
    private Size landscapeScreenSize;
    private Size portraitScreenSize;
    private final MobileAdsLogger logger;
    private final MobileAdsInfoStore infoStore;
    private final AndroidBuildInfo buildInfo;

    public DeviceInfo(Context context, UserAgentManager userAgentManager) {
        this(context, userAgentManager, MobileAdsInfoStore.getInstance(), new MobileAdsLoggerFactory(), new AndroidBuildInfo());
    }

    DeviceInfo(Context context, UserAgentManager userAgentManager, MobileAdsInfoStore infoStore, MobileAdsLoggerFactory loggerFactory, AndroidBuildInfo buildInfo) {
        this.logger = loggerFactory.createMobileAdsLogger(LOGTAG);
        this.infoStore = infoStore;
        this.buildInfo = buildInfo;
        this.setCountry();
        this.setNetworkCountry(context);
        this.setCarrier(context);
        this.setLanguage();
        this.setScalingFactor(context);
        this.userAgentManager = userAgentManager;
    }

    public void setUserAgentManager(UserAgentManager userAgentManager) {
        this.userAgentManager = userAgentManager;
    }

    private void setMacAddressIfNotFetched() {
        if (!this.macFetched) {
            this.setMacAddress();
        }
    }

    protected void setMacAddress() {
        Context context = this.infoStore.getApplicationContext();
        WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
        WifiInfo wifiInfo = null;
        if (wifiManager != null) {
            try {
                wifiInfo = wifiManager.getConnectionInfo();
            }
            catch (SecurityException e) {
                this.logger.d("Unable to get Wifi connection information: %s", e);
            }
            catch (ExceptionInInitializerError e) {
                this.logger.d("Unable to get Wifi connection information: %s", e);
            }
        }
        if (wifiInfo == null) {
            this.sha1_mac = null;
        } else {
            String macAddress = wifiInfo.getMacAddress();
            if (macAddress == null || macAddress.length() == 0) {
                this.sha1_mac = null;
                this.bad_mac = true;
            } else {
                Pattern macAddressPattern = Pattern.compile("((([0-9a-fA-F]){1,2}[-:]){5}([0-9a-fA-F]){1,2})");
                Matcher matcher = macAddressPattern.matcher(macAddress);
                if (!matcher.find()) {
                    this.sha1_mac = null;
                    this.bad_mac = true;
                } else {
                    this.sha1_mac = WebUtils.getURLEncodedString(StringUtils.sha1(macAddress));
                }
            }
        }
        this.macFetched = true;
    }

    private void setSerialIfNotFetched() {
        if (!this.serialFetched) {
            this.setSerial();
        }
    }

    private void setSerial() {
        String serial = null;
        try {
            Field f = Build.class.getDeclaredField("SERIAL");
            serial = (String)f.get(Build.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (serial == null || serial.length() == 0 || serial.equalsIgnoreCase(ORIENTATION_UNKNOWN)) {
            this.bad_serial = true;
        } else {
            this.sha1_serial = WebUtils.getURLEncodedString(StringUtils.sha1(serial));
        }
        this.serialFetched = true;
    }

    private void setUdidIfNotFetched() {
        if (!this.udidFetched) {
            this.setUdid();
        }
    }

    private void setUdid() {
        Context context = this.infoStore.getApplicationContext();
        String udid = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        if (StringUtils.isNullOrEmpty(udid) || udid.equalsIgnoreCase("9774d56d682e549c")) {
            this.sha1_udid = null;
            this.bad_udid = true;
        } else {
            this.sha1_udid = WebUtils.getURLEncodedString(StringUtils.sha1(udid));
        }
        this.udidFetched = true;
    }

    private void setLanguage() {
        String language = Locale.getDefault().getLanguage();
        this.language = language != null && language.length() > 0 ? language : null;
    }

    private void setCountry() {
        String country = Locale.getDefault().getCountry();
        this.country = country != null && country.length() > 0 ? country : null;
    }

    private void setNetworkCountry(Context context) {
        TelephonyManager tManager = (TelephonyManager)context.getSystemService("phone");
        if (tManager != null) {
            String networkCountry = tManager.getNetworkCountryIso();
            this.networkCountry = networkCountry != null && networkCountry.length() > 0 ? networkCountry.toUpperCase() : null;
        }
    }

    private void setCarrier(Context context) {
        TelephonyManager tManager = (TelephonyManager)context.getSystemService("phone");
        if (tManager != null) {
            String carrier = tManager.getNetworkOperatorName();
            this.carrier = carrier != null && carrier.length() > 0 ? carrier : null;
        }
    }

    private void setScalingFactor(Context context) {
        if (this.make.equals("motorola") && this.model.equals("MB502")) {
            this.scalingFactor = 1.0f;
        } else {
            WindowManager windowManager = (WindowManager)context.getSystemService("window");
            DisplayMetrics metrics = new DisplayMetrics();
            windowManager.getDefaultDisplay().getMetrics(metrics);
            this.scalingFactor = metrics.scaledDensity;
        }
        this.scalingFactorAsString = Float.toString(this.scalingFactor);
    }

    public String getDeviceType() {
        return dt;
    }

    public String getMake() {
        return this.make;
    }

    public String getModel() {
        return this.model;
    }

    public String getOS() {
        return os;
    }

    public String getOSVersion() {
        return this.osVersion;
    }

    public String getMacSha1() {
        this.setMacAddressIfNotFetched();
        return this.sha1_mac;
    }

    public boolean isMacBad() {
        this.setMacAddressIfNotFetched();
        return this.bad_mac;
    }

    public String getSerialSha1() {
        this.setSerialIfNotFetched();
        return this.sha1_serial;
    }

    public boolean isSerialBad() {
        this.setSerialIfNotFetched();
        return this.bad_serial;
    }

    public String getUdidSha1() {
        this.setUdidIfNotFetched();
        return this.sha1_udid;
    }

    public boolean isUdidBad() {
        this.setUdidIfNotFetched();
        return this.bad_udid;
    }

    public String getCarrier() {
        return this.carrier;
    }

    public String getCountry() {
        return this.country;
    }

    public String getNetworkCountry() {
        return this.networkCountry;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getScalingFactorAsString() {
        return this.scalingFactorAsString;
    }

    public float getScalingFactorAsFloat() {
        return this.scalingFactor;
    }

    public String getUserAgentString() {
        return this.userAgentManager.getUserAgentString();
    }

    public void setUserAgentString(String ua) {
        this.userAgentManager.setUserAgentString(ua);
    }

    public void populateUserAgentString(Context context) {
        this.userAgentManager.populateUserAgentString(context);
    }

    public String getOrientation() {
        String orientation = null;
        int canonicalOrientation = DisplayUtils.determineCanonicalScreenOrientation(this.infoStore.getApplicationContext(), this.buildInfo);
        switch (canonicalOrientation) {
            case 1: 
            case 9: {
                orientation = ORIENTATION_PORTRAIT;
                break;
            }
            case 0: 
            case 8: {
                orientation = ORIENTATION_LANDSCAPE;
                break;
            }
            default: {
                orientation = ORIENTATION_UNKNOWN;
            }
        }
        return orientation;
    }

    public Size getScreenSize(String orientation) {
        if (orientation.equals(ORIENTATION_PORTRAIT) && this.portraitScreenSize != null) {
            return this.portraitScreenSize;
        }
        if (orientation.equals(ORIENTATION_LANDSCAPE) && this.landscapeScreenSize != null) {
            return this.landscapeScreenSize;
        }
        Context context = this.infoStore.getApplicationContext();
        WindowManager wm = (WindowManager)context.getSystemService("window");
        DisplayMetrics metrics = new DisplayMetrics();
        wm.getDefaultDisplay().getMetrics(metrics);
        String screenSize = String.valueOf(metrics.widthPixels) + "x" + String.valueOf(metrics.heightPixels);
        if (orientation.equals(ORIENTATION_PORTRAIT)) {
            this.portraitScreenSize = new Size(screenSize);
            return this.portraitScreenSize;
        }
        if (orientation.equals(ORIENTATION_LANDSCAPE)) {
            this.landscapeScreenSize = new Size(screenSize);
            return this.landscapeScreenSize;
        }
        return new Size(screenSize);
    }

    public JSONObject getDInfoProperty() {
        JSONObject json = new JSONObject();
        JSONUtils.put(json, "make", this.getMake());
        JSONUtils.put(json, "model", this.getModel());
        JSONUtils.put(json, "os", this.getOS());
        JSONUtils.put(json, "osVersion", this.getOSVersion());
        JSONUtils.put(json, "scalingFactor", this.getScalingFactorAsString());
        JSONUtils.put(json, "language", this.getLanguage());
        JSONUtils.put(json, "country", this.getCountry());
        JSONUtils.put(json, "networkCountry", this.getNetworkCountry());
        JSONUtils.put(json, "carrier", this.getCarrier());
        return json;
    }

    public String toJsonString() {
        String orientation = this.getOrientation();
        return this.toJsonObject(orientation).toString();
    }

    JSONObject toJsonObject(String orientation) {
        JSONObject json = this.getDInfoProperty();
        JSONUtils.put(json, "orientation", orientation);
        JSONUtils.put(json, "screenSize", this.getScreenSize(orientation).toString());
        ConnectionInfo connectionInfo = new ConnectionInfo(this.infoStore);
        JSONUtils.put(json, "connectionType", connectionInfo.getConnectionType());
        return json;
    }
}

