/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.graphics.Rect;
import com.amazon.device.ads.ActionCode;
import com.amazon.device.ads.Ad;
import com.amazon.device.ads.AdData;
import com.amazon.device.ads.AdError;
import com.amazon.device.ads.AdEvent;
import com.amazon.device.ads.AdListenerExecutor;
import com.amazon.device.ads.AdProperties;
import com.amazon.device.ads.MobileAdsLoggerFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class CompositeAdListenerExecutor
extends AdListenerExecutor {
    private final List<AdListenerExecutor> adListenerExecutors = new ArrayList<AdListenerExecutor>();

    public CompositeAdListenerExecutor(MobileAdsLoggerFactory loggerFactory) {
        super(null, loggerFactory);
    }

    public void addAdListenerExecutor(AdListenerExecutor adListenerExecutor) {
        this.adListenerExecutors.add(adListenerExecutor);
    }

    private List<AdListenerExecutor> getAdListenerExecutors() {
        return this.adListenerExecutors;
    }

    @Override
    public void onAdLoaded(Ad ad, AdProperties adProperties) {
        for (AdListenerExecutor adListenerExecutor : this.getAdListenerExecutors()) {
            adListenerExecutor.onAdLoaded(ad, adProperties);
        }
    }

    @Override
    public void onAdFailedToLoad(Ad ad, AdError adError) {
        for (AdListenerExecutor adListenerExecutor : this.getAdListenerExecutors()) {
            adListenerExecutor.onAdFailedToLoad(ad, adError);
        }
    }

    @Override
    public void onAdExpanded(Ad ad) {
        for (AdListenerExecutor adListenerExecutor : this.getAdListenerExecutors()) {
            adListenerExecutor.onAdExpanded(ad);
        }
    }

    @Override
    public void onAdCollapsed(Ad ad) {
        for (AdListenerExecutor adListenerExecutor : this.getAdListenerExecutors()) {
            adListenerExecutor.onAdCollapsed(ad);
        }
    }

    @Override
    public void onAdDismissed(Ad ad) {
        for (AdListenerExecutor adListenerExecutor : this.getAdListenerExecutors()) {
            adListenerExecutor.onAdDismissed(ad);
        }
    }

    @Override
    public void onAdResized(Ad ad, Rect positionOnScreen) {
        for (AdListenerExecutor adListenerExecutor : this.getAdListenerExecutors()) {
            adListenerExecutor.onAdResized(ad, positionOnScreen);
        }
    }

    @Override
    public void onAdExpired(Ad ad) {
        for (AdListenerExecutor adListenerExecutor : this.getAdListenerExecutors()) {
            adListenerExecutor.onAdExpired(ad);
        }
    }

    @Override
    public void onSpecialUrlClicked(Ad ad, String url) {
        for (AdListenerExecutor adListenerExecutor : this.getAdListenerExecutors()) {
            adListenerExecutor.onSpecialUrlClicked(ad, url);
        }
    }

    @Override
    public ActionCode onAdReceived(Ad ad, AdData adData) {
        Iterator<AdListenerExecutor> iterator = this.getAdListenerExecutors().iterator();
        if (iterator.hasNext()) {
            AdListenerExecutor adListenerExecutor = iterator.next();
            return adListenerExecutor.onAdReceived(ad, adData);
        }
        return null;
    }

    @Override
    public void onAdEvent(AdEvent adEvent) {
        for (AdListenerExecutor adListenerExecutor : this.getAdListenerExecutors()) {
            adListenerExecutor.onAdEvent(adEvent);
        }
    }
}

