/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.device.ads.AAXCreative;
import com.amazon.device.ads.AdData;
import com.amazon.device.ads.AdError;
import com.amazon.device.ads.AdProperties;
import com.amazon.device.ads.AdRequest;
import com.amazon.device.ads.AdSlot;
import com.amazon.device.ads.Assets;
import com.amazon.device.ads.DebugProperties;
import com.amazon.device.ads.JSONUtils;
import com.amazon.device.ads.Metrics;
import com.amazon.device.ads.MetricsCollector;
import com.amazon.device.ads.MobileAdsInfoStore;
import com.amazon.device.ads.MobileAdsLogger;
import com.amazon.device.ads.MobileAdsLoggerFactory;
import com.amazon.device.ads.SystemTime;
import com.amazon.device.ads.ThreadUtils;
import com.amazon.device.ads.WebRequest;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

class AdLoader {
    private static final String LOGTAG = AdLoader.class.getSimpleName();
    public static final String DISABLED_APP_SERVER_MESSAGE = "DISABLED_APP";
    public static final int AD_READY_TO_LOAD = 0;
    public static final int AD_FAILED = -1;
    public static final int AD_LOAD_DEFERRED = 1;
    private final AdRequest adRequest;
    private final Map<Integer, AdSlot> slots;
    private int timeout = 20000;
    private AdError error = null;
    private MetricsCollector.CompositeMetricsCollector compositeMetricsCollector = null;
    private final MobileAdsLogger logger;
    private final MobileAdsInfoStore infoStore;
    private final Assets assets;
    private final DebugProperties debugProperties;
    private final ThreadUtils.ThreadRunner threadRunner;
    private final SystemTime systemTime;

    public AdLoader(AdRequest adRequest, Map<Integer, AdSlot> slots) {
        this(adRequest, slots, ThreadUtils.getThreadRunner(), new SystemTime(), Assets.getInstance(), MobileAdsInfoStore.getInstance(), new MobileAdsLoggerFactory(), DebugProperties.getInstance());
    }

    AdLoader(AdRequest adRequest, Map<Integer, AdSlot> slots, ThreadUtils.ThreadRunner threadRunner, SystemTime systemTime, Assets assets, MobileAdsInfoStore infoStore, MobileAdsLoggerFactory loggerFactory, DebugProperties debugProperties) {
        this.adRequest = adRequest;
        this.slots = slots;
        this.threadRunner = threadRunner;
        this.systemTime = systemTime;
        this.assets = assets;
        this.infoStore = infoStore;
        this.logger = loggerFactory.createMobileAdsLogger(LOGTAG);
        this.debugProperties = debugProperties;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void beginFetchAd() {
        this.getCompositeMetricsCollector().stopMetric(Metrics.MetricType.AD_LOAD_LATENCY_LOADAD_TO_FETCH_THREAD_REQUEST_START);
        this.getCompositeMetricsCollector().startMetric(Metrics.MetricType.AD_LOAD_LATENCY_FETCH_THREAD_SPIN_UP);
        this.startFetchAdThread();
    }

    protected void startFetchAdThread() {
        this.threadRunner.execute(new Runnable(){

            @Override
            public void run() {
                AdLoader.this.fetchAd();
                AdLoader.this.beginFinalizeFetchAd();
            }
        }, ThreadUtils.ExecutionStyle.SCHEDULE, ThreadUtils.ExecutionThread.BACKGROUND_THREAD);
    }

    private void beginFinalizeFetchAd() {
        this.threadRunner.execute(new Runnable(){

            @Override
            public void run() {
                AdLoader.this.finalizeFetchAd();
            }
        }, ThreadUtils.ExecutionStyle.SCHEDULE, ThreadUtils.ExecutionThread.MAIN_THREAD);
    }

    protected void fetchAd() {
        WebRequest.WebResponse response;
        this.getCompositeMetricsCollector().stopMetric(Metrics.MetricType.AD_LOAD_LATENCY_FETCH_THREAD_SPIN_UP);
        this.getCompositeMetricsCollector().startMetric(Metrics.MetricType.AD_LOAD_LATENCY_FETCH_THREAD_START_TO_AAX_GET_AD_START);
        if (!this.assets.ensureAssetsCreated()) {
            String msg = "Unable to create the assets needed to display ads";
            this.error = new AdError(AdError.ErrorCode.REQUEST_ERROR, "Unable to create the assets needed to display ads");
            this.logger.e("Unable to create the assets needed to display ads");
            this.setErrorForAllSlots(this.error);
            return;
        }
        try {
            response = this.fetchResponseFromNetwork();
        }
        catch (AdFetchException e) {
            this.error = e.getAdError();
            this.logger.e(e.getAdError().getMessage());
            this.setErrorForAllSlots(this.error);
            return;
        }
        if (!response.isHttpStatusCodeOK()) {
            String msg = response.getHttpStatusCode() + " - " + response.getHttpStatus();
            this.error = new AdError(AdError.ErrorCode.NETWORK_ERROR, msg);
            this.logger.e(msg);
            this.setErrorForAllSlots(this.error);
            return;
        }
        JSONObject jsonResponse = response.getResponseReader().readAsJSON();
        if (jsonResponse == null) {
            String msg = "Unable to parse response";
            this.error = new AdError(AdError.ErrorCode.INTERNAL_ERROR, "Unable to parse response");
            this.logger.e("Unable to parse response");
            this.setErrorForAllSlots(this.error);
            return;
        }
        this.parseResponse(jsonResponse);
        this.getCompositeMetricsCollector().stopMetric(Metrics.MetricType.AD_LOAD_LATENCY_AAX_GET_AD_END_TO_FETCH_THREAD_END);
        this.getCompositeMetricsCollector().startMetric(Metrics.MetricType.AD_LOAD_LATENCY_FINALIZE_FETCH_SPIN_UP);
    }

    private WebRequest getAdRequest() throws AdFetchException {
        this.getCompositeMetricsCollector().startMetric(Metrics.MetricType.AD_LOAD_LATENCY_CREATE_AAX_GET_AD_URL);
        WebRequest request = this.adRequest.getWebRequest();
        this.getCompositeMetricsCollector().stopMetric(Metrics.MetricType.AD_LOAD_LATENCY_CREATE_AAX_GET_AD_URL);
        return request;
    }

    private void parseResponse(JSONObject jsonResponse) {
        long currentTime = this.systemTime.currentTimeMillis();
        String status = JSONUtils.getStringFromJSON(jsonResponse, "status", null);
        HashSet<Integer> slotsNotReceived = new HashSet<Integer>(this.slots.keySet());
        AdError adError = this.getAdError(jsonResponse);
        String errorCode = JSONUtils.getStringFromJSON(jsonResponse, "errorCode", "No Ad Received");
        this.adRequest.setInstrumentationPixelURL(JSONUtils.getStringFromJSON(jsonResponse, "instrPixelURL", null));
        if (status != null && status.equals("ok")) {
            JSONArray adsArray = JSONUtils.getJSONArrayFromJSON(jsonResponse, "ads");
            for (int i = 0; i < adsArray.length(); ++i) {
                long expiration;
                int slotId;
                AdSlot adSlot;
                JSONObject slot = JSONUtils.getJSONObjectFromJSONArray(adsArray, i);
                if (slot == null || (adSlot = this.slots.get(slotId = JSONUtils.getIntegerFromJSON(slot, "slotId", -1))) == null) continue;
                slotsNotReceived.remove(slotId);
                String adPixelUrl = JSONUtils.getStringFromJSON(slot, "instrPixelURL", this.adRequest.getInstrumentationPixelURL());
                AdData adData = new AdData();
                adData.setInstrumentationPixelUrl(adPixelUrl);
                String impPixelUrl = JSONUtils.getStringFromJSON(slot, "impPixelURL", null);
                adData.setImpressionPixelUrl(impPixelUrl);
                if (adSlot.getRequestedAdSize().isAuto()) {
                    adSlot.getMetricsCollector().incrementMetric(Metrics.MetricType.AD_COUNTER_AUTO_AD_SIZE);
                }
                String creative = JSONUtils.getStringFromJSON(slot, "html", "");
                JSONArray creativeTypes = JSONUtils.getJSONArrayFromJSON(slot, "creativeTypes");
                HashSet<AAXCreative> creativeSet = new HashSet<AAXCreative>();
                if (creativeTypes != null) {
                    for (int j = 0; j < creativeTypes.length(); ++j) {
                        int creativeType = JSONUtils.getIntegerFromJSONArray(creativeTypes, j, 0);
                        AAXCreative aaxCreative = AAXCreative.getCreativeType(creativeType);
                        if (aaxCreative != null) {
                            creativeSet.add(aaxCreative);
                            continue;
                        }
                        this.logger.w("%d is not a recognized creative type.", creativeType);
                    }
                }
                if (!AAXCreative.containsPrimaryCreativeType(creativeSet)) {
                    String msg = "No valid creative types found";
                    adSlot.setAdError(new AdError(AdError.ErrorCode.INTERNAL_ERROR, "No valid creative types found"));
                    this.logger.e("No valid creative types found");
                    continue;
                }
                String size = JSONUtils.getStringFromJSON(slot, "size", "");
                if (size != null && (size.equals("9999x9999") || size.equals("interstitial")) && !creativeSet.contains((Object)AAXCreative.INTERSTITIAL)) {
                    creativeSet.add(AAXCreative.INTERSTITIAL);
                }
                int adWidth = 0;
                int adHeight = 0;
                if (!creativeSet.contains((Object)AAXCreative.INTERSTITIAL)) {
                    String[] sizes;
                    boolean sizeIsInvalid = false;
                    String[] stringArray = sizes = size != null ? size.split("x") : null;
                    if (sizes == null || sizes.length != 2) {
                        sizeIsInvalid = true;
                    } else {
                        try {
                            adWidth = Integer.parseInt(sizes[0]);
                            adHeight = Integer.parseInt(sizes[1]);
                        }
                        catch (NumberFormatException e) {
                            sizeIsInvalid = true;
                        }
                    }
                    if (sizeIsInvalid) {
                        String msg = "Server returned an invalid ad size";
                        adSlot.setAdError(new AdError(AdError.ErrorCode.INTERNAL_ERROR, "Server returned an invalid ad size"));
                        this.logger.e("Server returned an invalid ad size");
                        continue;
                    }
                }
                if ((expiration = JSONUtils.getLongFromJSON(slot, "cacheTTL", -1L)) > -1L) {
                    long expirationTimeMs = currentTime + 1000L * expiration;
                    adData.setExpirationTimeMillis(expirationTimeMs);
                }
                AdProperties props = new AdProperties(creativeTypes);
                adData.setHeight(adHeight);
                adData.setWidth(adWidth);
                adData.setCreative(creative);
                adData.setCreativeTypes(creativeSet);
                adData.setProperties(props);
                adData.setFetched(true);
                adSlot.setAdData(adData);
            }
        }
        for (Integer slotId : slotsNotReceived) {
            this.slots.get(slotId).setAdError(adError);
            AdData adData = new AdData();
            adData.setInstrumentationPixelUrl(this.adRequest.getInstrumentationPixelURL());
            this.slots.get(slotId).setAdData(adData);
            this.logger.w("%s; code: %s", adError.getMessage(), errorCode);
        }
    }

    protected AdError getAdError(JSONObject jsonResponse) {
        int noRetryTtlSeconds = this.retrieveNoRetryTtlSeconds(jsonResponse);
        this.infoStore.setNoRetryTtl(noRetryTtlSeconds);
        String errorMsg = JSONUtils.getStringFromJSON(jsonResponse, "errorMessage", "No Ad Received");
        this.infoStore.setIsAppDisabled(errorMsg.equalsIgnoreCase(DISABLED_APP_SERVER_MESSAGE));
        String msg = "Server Message: " + errorMsg;
        AdError adError = null;
        if (noRetryTtlSeconds > 0) {
            this.getCompositeMetricsCollector().publishMetricInMilliseconds(Metrics.MetricType.AD_NO_RETRY_TTL_RECEIVED, noRetryTtlSeconds * 1000);
        }
        if (noRetryTtlSeconds > 0 && !this.infoStore.getIsAppDisabled()) {
            msg = msg + ". Try again in " + noRetryTtlSeconds + " seconds";
            adError = new AdError(AdError.ErrorCode.NO_FILL, msg);
        } else {
            adError = errorMsg.equals("no results") ? new AdError(AdError.ErrorCode.NO_FILL, msg) : new AdError(AdError.ErrorCode.INTERNAL_ERROR, msg);
        }
        return adError;
    }

    private void setErrorForAllSlots(AdError error) {
        for (AdSlot slot : this.slots.values()) {
            slot.setAdError(error);
        }
    }

    protected int retrieveNoRetryTtlSeconds(JSONObject jsonResponse) {
        int noRetryTtlSeconds = JSONUtils.getIntegerFromJSON(jsonResponse, "noretryTTL", 0);
        noRetryTtlSeconds = this.debugProperties.getDebugPropertyAsInteger("debug.noRetryTTL", noRetryTtlSeconds);
        return noRetryTtlSeconds;
    }

    protected void finalizeFetchAd() {
        for (Map.Entry<Integer, AdSlot> entry : this.slots.entrySet()) {
            AdSlot slot = entry.getValue();
            if (!slot.canBeUsed()) {
                this.logger.w("Ad object was destroyed before ad fetching could be finalized. Ad fetching has been aborted.");
                continue;
            }
            slot.getMetricsCollector().stopMetric(Metrics.MetricType.AD_LOAD_LATENCY_FINALIZE_FETCH_SPIN_UP);
            if (!slot.isFetched()) {
                slot.getMetricsCollector().startMetric(Metrics.MetricType.AD_LOAD_LATENCY_FINALIZE_FETCH_START_TO_FAILURE);
                if (slot.getAdError() != null) {
                    slot.adFailed(slot.getAdError());
                    continue;
                }
                slot.adFailed(new AdError(AdError.ErrorCode.INTERNAL_ERROR, "Unknown error occurred."));
                continue;
            }
            slot.getMetricsCollector().startMetric(Metrics.MetricType.AD_LOAD_LATENCY_FINALIZE_FETCH_START_TO_RENDER_START);
            slot.initializeAd();
        }
    }

    protected WebRequest.WebResponse fetchResponseFromNetwork() throws AdFetchException {
        WebRequest request = this.getAdRequest();
        request.setMetricsCollector(this.getCompositeMetricsCollector());
        request.setServiceCallLatencyMetric(Metrics.MetricType.AAX_LATENCY_GET_AD);
        request.setTimeout(this.timeout);
        request.setDisconnectEnabled(false);
        this.getCompositeMetricsCollector().stopMetric(Metrics.MetricType.AD_LOAD_LATENCY_FETCH_THREAD_START_TO_AAX_GET_AD_START);
        WebRequest.WebResponse response = null;
        this.getCompositeMetricsCollector().incrementMetric(Metrics.MetricType.TLS_ENABLED);
        try {
            response = request.makeCall();
        }
        catch (WebRequest.WebRequestException e) {
            AdError error = null;
            error = e.getStatus() == WebRequest.WebRequestStatus.NETWORK_FAILURE ? new AdError(AdError.ErrorCode.NETWORK_ERROR, "Could not contact Ad Server") : (e.getStatus() == WebRequest.WebRequestStatus.NETWORK_TIMEOUT ? new AdError(AdError.ErrorCode.NETWORK_TIMEOUT, "Connection to Ad Server timed out") : new AdError(AdError.ErrorCode.INTERNAL_ERROR, e.getMessage()));
            throw new AdFetchException(error);
        }
        this.getCompositeMetricsCollector().startMetric(Metrics.MetricType.AD_LOAD_LATENCY_AAX_GET_AD_END_TO_FETCH_THREAD_END);
        return response;
    }

    private MetricsCollector getCompositeMetricsCollector() {
        if (this.compositeMetricsCollector == null) {
            ArrayList<MetricsCollector> collectors = new ArrayList<MetricsCollector>();
            for (Map.Entry<Integer, AdSlot> entry : this.slots.entrySet()) {
                collectors.add(entry.getValue().getMetricsCollector());
            }
            this.compositeMetricsCollector = new MetricsCollector.CompositeMetricsCollector(collectors);
        }
        return this.compositeMetricsCollector;
    }

    protected static class AdLoaderFactory {
        protected AdLoaderFactory() {
        }

        public AdLoader createAdLoader(AdRequest adRequest, Map<Integer, AdSlot> slots) {
            return new AdLoader(adRequest, slots);
        }
    }

    protected class AdFetchException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final AdError adError;

        public AdFetchException(AdError adError) {
            this.adError = adError;
        }

        public AdFetchException(AdError adError, Throwable throwable) {
            super(throwable);
            this.adError = adError;
        }

        public AdError getAdError() {
            return this.adError;
        }
    }
}

