/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.amazon.device.ads.Ad;
import com.amazon.device.ads.AdControlCallback;
import com.amazon.device.ads.AdController;
import com.amazon.device.ads.AdControllerFactory;
import com.amazon.device.ads.AdData;
import com.amazon.device.ads.AdError;
import com.amazon.device.ads.AdEvent;
import com.amazon.device.ads.AdListener;
import com.amazon.device.ads.AdListenerExecutor;
import com.amazon.device.ads.AdListenerExecutorFactory;
import com.amazon.device.ads.AdLoadStarter;
import com.amazon.device.ads.AdProperties;
import com.amazon.device.ads.AdRegistration;
import com.amazon.device.ads.AdRegistrationExecutor;
import com.amazon.device.ads.AdSize;
import com.amazon.device.ads.AdSlot;
import com.amazon.device.ads.AdState;
import com.amazon.device.ads.AdTargetingOptions;
import com.amazon.device.ads.AndroidTargetUtils;
import com.amazon.device.ads.ApplicationDefaultPreferences;
import com.amazon.device.ads.ContextUtils;
import com.amazon.device.ads.DefaultAdListener;
import com.amazon.device.ads.Destroyable;
import com.amazon.device.ads.Metrics;
import com.amazon.device.ads.MobileAdsLogger;
import com.amazon.device.ads.MobileAdsLoggerFactory;
import com.amazon.device.ads.NumberUtils;
import com.amazon.device.ads.ThreadUtils;
import java.util.Locale;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

@SuppressLint(value={"InlinedApi"})
public class AdLayout
extends FrameLayout
implements Ad {
    public static final int DEFAULT_TIMEOUT = 20000;
    static final String LAYOUT_NOT_RUN_ERR_MSG = "Can't load an ad because the view size cannot be determined.";
    static final String LAYOUT_PARAMS_NULL_ERR_MSG = "Can't load an ad because layout parameters are blank. Use setLayoutParams() to specify dimensions for this AdLayout.";
    static final String LOADING_IN_PROGRESS_LOG_MSG = "Can't load an ad because an ad is currently loading. Please wait for the ad to finish loading and showing before loading another ad.";
    static final String LOADING_OR_LOADED_LOG_MSG = "Can't load an ad because an ad is currently loading or already loaded. Please wait for the ad to finish loading or showing before loading another ad.";
    private static final String LOGTAG = AdLayout.class.getSimpleName();
    private static final String CONTENT_DESCRIPTION_AD_LAYOUT = "adLayoutObject";
    private BroadcastReceiver screenStateReceiver;
    private boolean isInForeground;
    private final Context context;
    private AdSize adSize;
    private final AdControllerFactory adControllerFactory;
    private AdController adController;
    private boolean hasRegisterBroadcastReciever = false;
    private boolean attached = false;
    private int lastVisibility = 8;
    private AtomicBoolean needsToLoadAdOnLayout = new AtomicBoolean(false);
    private boolean isParentViewMissingAtLoadTime = false;
    private View activityRootView = null;
    private AdTargetingOptions adTargetingOptions = null;
    private boolean isDestroyed = false;
    private boolean isInitialized = false;
    private boolean autoShow = true;
    private View currentView;
    private Destroyable currentDestroyable;
    private AdProperties properties;
    private boolean shouldDisableWebViewHardwareAcceleration;
    private static ScheduledThreadPoolExecutor threadPool;
    private final AdListenerExecutorFactory adListenerExecutorFactory;
    private AdListenerExecutor adListenerExecutor;
    private final MobileAdsLoggerFactory loggerFactory;
    private final MobileAdsLogger logger;
    private final AdRegistrationExecutor adRegistration;
    private final AdLoadStarter adLoadStarter;
    private final AtomicBoolean previousAdExpired = new AtomicBoolean(false);

    public AdLayout(Context context) {
        this(context, AdSize.SIZE_AUTO);
    }

    public AdLayout(Context context, AdSize adSize) {
        this(context, adSize, new MobileAdsLoggerFactory(), new AdControllerFactory(), AdRegistration.getAmazonAdRegistrationExecutor(), new AdLoadStarter());
    }

    AdLayout(Context context, AdSize adSize, MobileAdsLoggerFactory loggerFactory, AdControllerFactory adControllerFactory, AdRegistrationExecutor adRegistration, AdLoadStarter adLoadStarter) {
        this(context, adSize, loggerFactory, new AdListenerExecutorFactory(loggerFactory), adControllerFactory, adRegistration, adLoadStarter);
    }

    AdLayout(Context context, AdSize adSize, MobileAdsLoggerFactory loggerFactory, AdListenerExecutorFactory adListenerExecutorFactory, AdControllerFactory adControllerFactory, AdRegistrationExecutor adRegistration, AdLoadStarter adLoadStarter) {
        super(context);
        this.context = context;
        this.adSize = adSize;
        this.loggerFactory = loggerFactory;
        this.logger = this.loggerFactory.createMobileAdsLogger(LOGTAG);
        this.adListenerExecutorFactory = adListenerExecutorFactory;
        this.adControllerFactory = adControllerFactory;
        this.adRegistration = adRegistration;
        this.adLoadStarter = adLoadStarter;
        if (ApplicationDefaultPreferences.getDefaultPreferences() == null) {
            ApplicationDefaultPreferences.initialize(context);
        }
    }

    public AdLayout(Context context, AttributeSet attrs) {
        this(context, attrs, new MobileAdsLoggerFactory(), new AdControllerFactory(), AdRegistration.getAmazonAdRegistrationExecutor(), new AdLoadStarter());
    }

    AdLayout(Context context, AttributeSet attrs, MobileAdsLoggerFactory loggerFactory, AdControllerFactory adControllerFactory, AdRegistrationExecutor adRegistration, AdLoadStarter adLoadStarter) {
        this(context, attrs, loggerFactory, new AdListenerExecutorFactory(loggerFactory), adControllerFactory, adRegistration, adLoadStarter);
    }

    AdLayout(Context context, AttributeSet attrs, MobileAdsLoggerFactory loggerFactory, AdListenerExecutorFactory adListenerExecutorFactory, AdControllerFactory adControllerFactory, AdRegistrationExecutor adRegistration, AdLoadStarter adLoadStarter) {
        super(context, attrs);
        this.context = context;
        this.adSize = this.determineAdSize(attrs);
        this.loggerFactory = loggerFactory;
        this.logger = this.loggerFactory.createMobileAdsLogger(LOGTAG);
        this.adListenerExecutorFactory = adListenerExecutorFactory;
        this.adControllerFactory = adControllerFactory;
        this.adRegistration = adRegistration;
        this.adLoadStarter = adLoadStarter;
    }

    public AdLayout(Context context, AttributeSet attrs, int defStyle) {
        this(context, attrs, defStyle, new MobileAdsLoggerFactory(), new AdControllerFactory(), AdRegistration.getAmazonAdRegistrationExecutor(), new AdLoadStarter());
    }

    AdLayout(Context context, AttributeSet attrs, int defStyle, MobileAdsLoggerFactory loggerFactory, AdControllerFactory adControllerFactory, AdRegistrationExecutor adRegistration, AdLoadStarter adLoadStarter) {
        this(context, attrs, defStyle, loggerFactory, new AdListenerExecutorFactory(loggerFactory), adControllerFactory, adRegistration, adLoadStarter);
    }

    AdLayout(Context context, AttributeSet attrs, int defStyle, MobileAdsLoggerFactory loggerFactory, AdListenerExecutorFactory adListenerExecutorFactory, AdControllerFactory adControllerFactory, AdRegistrationExecutor adRegistration, AdLoadStarter adLoadStarter) {
        super(context, attrs, defStyle);
        this.context = context;
        this.adSize = this.determineAdSize(attrs);
        this.loggerFactory = loggerFactory;
        this.logger = this.loggerFactory.createMobileAdsLogger(LOGTAG);
        this.adListenerExecutorFactory = adListenerExecutorFactory;
        this.adControllerFactory = adControllerFactory;
        this.adRegistration = adRegistration;
        this.adLoadStarter = adLoadStarter;
    }

    public void setX(float x) {
        super.setX(x);
        this.fireViewableEvent();
    }

    public void setY(float y) {
        super.setY(y);
        this.fireViewableEvent();
    }

    public void setTranslationX(float translationX) {
        super.setTranslationX(translationX);
        this.fireViewableEvent();
    }

    public void setTranslationY(float translationY) {
        super.setTranslationY(translationY);
        this.fireViewableEvent();
    }

    private void fireViewableEvent() {
        if (this.adController != null) {
            this.adController.fireViewableEvent();
        }
    }

    private AdSize determineAdSize(AttributeSet attrs) {
        String oldAdsXmlNamespace;
        String adSizeAttributeName = "adSize";
        String adsXmlNamespace = "http://schemas.android.com/apk/lib/com.amazon.device.ads";
        String adSizeAttributeValue = AdLayout.getAttributeValue(attrs, "http://schemas.android.com/apk/lib/com.amazon.device.ads", "adSize");
        if (adSizeAttributeValue == null && (adSizeAttributeValue = AdLayout.getAttributeValue(attrs, oldAdsXmlNamespace = "http://schemas.android.com/apk/res/" + this.context.getPackageName(), "adSize")) != null) {
            this.logger.forceLog(MobileAdsLogger.Level.WARN, "DEPRECATED - Please use the XML namespace \"http://schemas.android.com/apk/lib/com.amazon.device.ads\" for specifying AdLayout properties.", new Object[0]);
            if (adSizeAttributeValue.toLowerCase(Locale.US).equals("custom")) {
                String msg = "Using \"custom\" or \"CUSTOM\" for the \"adSize\" property is no longer supported. Please specifiy a size or remove the property to use Auto Ad Size.";
                this.logger.forceLog(MobileAdsLogger.Level.ERROR, msg, new Object[0]);
                throw new IllegalArgumentException(msg);
            }
        }
        AdSize adSize = AdLayout.parseAdSize(adSizeAttributeValue);
        return adSize;
    }

    MobileAdsLogger getLogger() {
        return this.logger;
    }

    boolean shouldDisableWebViewHardwareAcceleration() {
        return this.shouldDisableWebViewHardwareAcceleration;
    }

    void setShouldDisableWebViewHardwareAcceleration(boolean shouldDisableWebViewHardwareAcceleration) {
        this.shouldDisableWebViewHardwareAcceleration = shouldDisableWebViewHardwareAcceleration;
        if (this.adController != null) {
            this.adController.requestDisableHardwareAcceleration(this.shouldDisableWebViewHardwareAcceleration);
        }
    }

    void initializeIfNecessary() {
        if (this.isInitialized()) {
            return;
        }
        long initStart = System.nanoTime();
        this.logger.d("Initializing AdLayout.");
        this.adRegistration.initializeAds(this.context);
        this.setContentDescription(CONTENT_DESCRIPTION_AD_LAYOUT);
        if (this.isInEditMode()) {
            TextView textView = new TextView(this.context);
            textView.setText((CharSequence)"AdLayout");
            textView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            textView.setGravity(17);
            this.addView((View)textView);
            this.isInitialized = true;
            return;
        }
        this.isInForeground = this.getVisibility() == 0;
        this.setHorizontalScrollBarEnabled(false);
        this.setVerticalScrollBarEnabled(false);
        this.isInitialized = true;
        if (this.adListenerExecutor == null) {
            this.setListener(null);
        }
        this.initializeAdController();
        if (this.isWebViewDatabaseNull()) {
            this.logger.forceLog(MobileAdsLogger.Level.ERROR, "Disabling ads. Local cache file is inaccessible so ads will fail if we try to create a WebView. Details of this Android bug found at: http://code.google.com/p/android/issues/detail?id=10789", new Object[0]);
            this.isInitialized = false;
            return;
        }
        this.adController.getMetricsCollector().startMetricInMillisecondsFromNanoseconds(Metrics.MetricType.AD_LAYOUT_INITIALIZATION, initStart);
        this.adController.getMetricsCollector().stopMetric(Metrics.MetricType.AD_LAYOUT_INITIALIZATION);
    }

    private void initializeAdController() {
        if (this.adController == null) {
            AdSize size = this.adSize == null ? AdSize.SIZE_AUTO : this.adSize;
            this.setAdController(this.createAdController(size, this.context));
            this.adController.requestDisableHardwareAcceleration(this.shouldDisableWebViewHardwareAcceleration);
        }
    }

    private void setAdController(AdController adController) {
        this.adController = adController;
        this.adController.setCallback(this.createAdControlCallback());
    }

    private AdController getAdController() {
        this.initializeIfNecessary();
        if (this.adController == null) {
            this.initializeAdController();
        }
        return this.adController;
    }

    private static String getAttributeValue(AttributeSet attrs, String namespace, String name) {
        return attrs.getAttributeValue(namespace, name);
    }

    private static AdSize parseAdSize(String string) {
        AdSize adSize = AdSize.SIZE_AUTO;
        if (string != null) {
            if ((string = string.toLowerCase(Locale.US)).equals("autonoscale")) {
                adSize = AdSize.SIZE_AUTO_NO_SCALE;
            } else if (!string.equals("auto")) {
                String[] sizes = string.split("x");
                int width = 0;
                int height = 0;
                if (sizes.length == 2) {
                    width = NumberUtils.parseInt(sizes[0], width);
                    height = NumberUtils.parseInt(sizes[1], height);
                }
                adSize = new AdSize(width, height);
            }
        }
        return adSize;
    }

    private AdController createAdController(AdSize size, Context context) {
        return this.adControllerFactory.buildAdController(context, size);
    }

    AdControlCallback createAdControlCallback() {
        return new AdLayoutAdControlCallback();
    }

    boolean isWebViewDatabaseNull() {
        return !this.getAdController().canShowViews();
    }

    AdData getAdData() {
        return this.getAdController().getAdData();
    }

    boolean isInitialized() {
        return this.isInitialized;
    }

    private void registerScreenStateBroadcastReceiver() {
        if (this.hasRegisterBroadcastReciever) {
            return;
        }
        this.hasRegisterBroadcastReciever = true;
        this.screenStateReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                if (intent.getAction().equals("android.intent.action.SCREEN_OFF") && AdLayout.this.isInForeground) {
                    AdLayout.this.getAdController().closeAd();
                }
            }
        };
        IntentFilter filter = new IntentFilter("android.intent.action.SCREEN_OFF");
        filter.addAction("android.intent.action.USER_PRESENT");
        this.context.getApplicationContext().registerReceiver(this.screenStateReceiver, filter);
    }

    private void unregisterScreenStateBroadcastReceiver() {
        if (this.hasRegisterBroadcastReciever) {
            this.hasRegisterBroadcastReciever = false;
            this.context.getApplicationContext().unregisterReceiver(this.screenStateReceiver);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.isInEditMode()) {
            return;
        }
        this.attached = true;
        this.registerScreenStateBroadcastReceiver();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.attached = false;
        this.unregisterScreenStateBroadcastReceiver();
    }

    protected void onWindowVisibilityChanged(int visibility) {
        if (this.attached && this.lastVisibility != visibility) {
            if (visibility != 0) {
                this.isInForeground = false;
                this.collapseAd();
                this.unregisterScreenStateBroadcastReceiver();
            } else if (visibility == 0) {
                this.isInForeground = true;
            }
        }
    }

    private void collapseAd() {
        if (this.getAdController().getAdState().equals((Object)AdState.EXPANDED)) {
            ThreadUtils.scheduleOnMainThread(new Runnable(){

                @Override
                public void run() {
                    if (AdLayout.this.getAdController().getAdState().equals((Object)AdState.EXPANDED)) {
                        AdLayout.this.getAdController().closeAd();
                    }
                }
            });
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        if (this.isDestroyed) {
            return;
        }
        int width = right - left;
        int height = bottom - top;
        super.onLayout(changed, left, top, right, bottom);
        if (this.isInEditMode()) {
            return;
        }
        this.getAdController().setWindowDimensions(width, height);
        if (this.getAndSetNeedsToLoadAdOnLayout(false)) {
            this.startAdLoadUponLayout();
        }
    }

    private void startAdLoadUponLayout() {
        AdTargetingOptions options = this.adTargetingOptions;
        AdSlot adSlot = new AdSlot(this.getAdController(), options).setDeferredLoad(true);
        this.adLoadStarter.loadAds(this.getAdController().getTimeout(), options, adSlot);
        if (!this.getAndResetIsPrepared()) {
            this.onRequestError("Could not load ad on layout.");
        }
    }

    @Override
    public int getTimeout() {
        AdController adController = this.getAdController();
        if (adController == null) {
            return -1;
        }
        return this.getAdController().getTimeout();
    }

    @Override
    public void setTimeout(int timeout) {
        AdController adController = this.getAdController();
        if (adController != null) {
            adController.setTimeout(timeout);
        }
    }

    public AdSize getAdSize() {
        AdController adController = this.getAdController();
        if (adController == null) {
            return null;
        }
        return adController.getAdSize();
    }

    void setMaxWidth(int maxWidthDp) {
        if (this.adController != null) {
            this.logger.w("The maximum width cannot be changed because this ad has already been initialized. Max width should be set immediately after construction of the Ad object.");
            return;
        }
        this.adSize = this.adSize.newMaxWidth(maxWidthDp);
    }

    @Override
    public boolean loadAd() {
        return this.loadAd(new AdTargetingOptions());
    }

    @Override
    public boolean loadAd(AdTargetingOptions options) {
        if (options == null) {
            options = new AdTargetingOptions();
        }
        this.adTargetingOptions = options;
        if (this.getNeedsToLoadAdOnLayout()) {
            this.logger.e(LOADING_IN_PROGRESS_LOG_MSG);
            return false;
        }
        this.initializeIfNecessary();
        if (!this.isInitialized()) {
            this.logger.e("The ad could not be initialized properly.");
            return false;
        }
        if (!this.isReadyToLoad()) {
            switch (this.getAdController().getAdState()) {
                case INVALID: {
                    if (this.getAdController().isExpired()) {
                        this.getAdController().setAdState(AdState.READY_TO_LOAD);
                        this.getAdController().resetToReady();
                        return this.loadAd(options);
                    }
                    this.logger.e("An ad could not be loaded because of an unknown issue with the web views.");
                    break;
                }
                case DESTROYED: {
                    this.logger.e("An ad could not be loaded because the AdLayout has been destroyed.");
                    break;
                }
                case EXPANDED: {
                    this.logger.e("An ad could not be loaded because another ad is currently expanded.");
                    break;
                }
                default: {
                    this.logger.e(LOADING_OR_LOADED_LOG_MSG);
                }
            }
            return false;
        }
        if (this.getAdController().getAdState().equals((Object)AdState.SHOWING)) {
            this.getAdController().getMetricsCollector().stopMetric(Metrics.MetricType.AD_SHOW_DURATION);
        }
        this.previousAdExpired.set(false);
        this.adLoadStarter.loadAds(this.getAdController().getTimeout(), options, new AdSlot(this.getAdController(), options));
        if (this.getNeedsToLoadAdOnLayout()) {
            return true;
        }
        return this.getAndResetIsPrepared();
    }

    private boolean isReadyToLoad() {
        return AdState.READY_TO_LOAD.equals((Object)this.getAdController().getAdState()) || AdState.SHOWING.equals((Object)this.getAdController().getAdState());
    }

    private boolean isReadyToShow() {
        return this.getAdController().getAdState().equals((Object)AdState.RENDERED);
    }

    public boolean isShowing() {
        return this.getAdController().getAdState().equals((Object)AdState.SHOWING);
    }

    boolean prepareAd(boolean deferredLoad) {
        if (deferredLoad) {
            this.logger.d("Skipping ad layout preparation steps because the layout is already prepared.");
            return true;
        }
        if (!this.isReadyToLoad()) {
            return false;
        }
        if (this.getNeedsToLoadAdOnLayout()) {
            this.logger.e(LOADING_IN_PROGRESS_LOG_MSG);
            return false;
        }
        if (this.getAdSize().isAuto()) {
            String msg = "Ad size to be determined automatically.";
            this.logger.d(msg);
        }
        this.setIsParentViewMissingAtLoadTime();
        if (this.getAdSize().isAuto() && this.getAdController().areWindowDimensionsSet()) {
            return true;
        }
        if (this.isLayoutRequested() && this.getAdSize().isAuto() && !this.isParentViewMissingAtLoadTime()) {
            this.deferAdLoadToLayoutEvent();
            return false;
        }
        if (this.isParentViewMissingAtLoadTime()) {
            this.logger.d("The ad's parent view is missing at load time.");
            return this.loadAdWhenParentViewMissing();
        }
        this.setWindowDimensions();
        return true;
    }

    private boolean loadAdWhenParentViewMissing() {
        if (this.getLayoutParams() == null) {
            Metrics.getInstance().getMetricsCollector().incrementMetric(Metrics.MetricType.AD_FAILED_NULL_LAYOUT_PARAMS);
            this.onRequestError(LAYOUT_PARAMS_NULL_ERR_MSG);
            return false;
        }
        if (AndroidTargetUtils.isAtLeastAndroidAPI(11)) {
            this.setActivityRootView();
            if (this.isActivityRootViewNull()) {
                String msg = "Ad load failed because root view could not be obtained from the activity.";
                this.onRequestError(msg);
                return false;
            }
            if (this.isActivityRootViewLayoutRequested()) {
                this.logger.d("Activity root view layout is requested.");
                this.deferAdLoadToLayoutEvent();
                this.setOnLayoutChangeListenerForRoot();
                return false;
            }
            this.setFloatingWindowDimensions();
            return true;
        }
        this.setFloatingWindowDimensions();
        return true;
    }

    void adFailed(AdError adError) {
        this.getAdController().adFailed(adError);
    }

    void bypassAdRenderingProcess() {
        this.getAdController().setAdState(AdState.RENDERING);
        this.getAdController().adRendered("custom-render");
    }

    void adShown() {
        this.getAdController().adShown();
    }

    void setOnLayoutChangeListenerForRoot() {
        OnLayoutChangeListenerUtil.setOnLayoutChangeListenerForRoot(this);
    }

    void setFloatingWindowDimensions() {
        if (this.getLayoutParams().width == -1 || this.getLayoutParams().height == -1) {
            this.logger.d("The requested ad will scale based on the screen's dimensions because at least one AdLayout dimension is set to MATCH_PARENT but the AdLayout is currently missing a fixed-size parent view.");
        }
        this.setWindowDimensions();
    }

    private void setWindowDimensions() {
        int windowWidth = this.resolveLayoutParam(true);
        int windowHeight = this.resolveLayoutParam(false);
        if (windowWidth > 0 || windowHeight > 0) {
            this.getAdController().setWindowDimensions(windowWidth, windowHeight);
        }
    }

    int resolveLayoutParam(boolean isWidth) {
        int value;
        int n = value = isWidth ? this.getLayoutParams().width : this.getLayoutParams().height;
        if (value == -1) {
            if (this.isActivityRootViewNull()) {
                return this.getRawScreenDimension(isWidth);
            }
            return this.getActivityRootViewDimension(isWidth);
        }
        if (value == -2) {
            return 0;
        }
        return value;
    }

    int getRawScreenDimension(boolean isWidth) {
        WindowManager wm = (WindowManager)this.context.getSystemService("window");
        DisplayMetrics metrics = new DisplayMetrics();
        wm.getDefaultDisplay().getMetrics(metrics);
        return isWidth ? metrics.widthPixels : metrics.heightPixels;
    }

    void deferAdLoadToLayoutEvent() {
        this.setNeedsToLoadAdOnLayout(true);
        this.scheduleTaskForCheckingIfLayoutHasRun();
    }

    void scheduleTaskForCheckingIfLayoutHasRun() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                AdLayout.this.failLoadIfLayoutHasNotRun();
            }
        };
        threadPool.schedule(runnable, (long)this.getTimeout(), TimeUnit.MILLISECONDS);
    }

    void failLoadIfLayoutHasNotRun() {
        if (this.getAndSetNeedsToLoadAdOnLayout(false)) {
            Metrics.getInstance().getMetricsCollector().incrementMetric(Metrics.MetricType.AD_FAILED_LAYOUT_NOT_RUN);
            this.onRequestError(LAYOUT_NOT_RUN_ERR_MSG);
        }
    }

    boolean getNeedsToLoadAdOnLayout() {
        return this.needsToLoadAdOnLayout.get();
    }

    void setNeedsToLoadAdOnLayout(boolean value) {
        this.needsToLoadAdOnLayout.set(value);
    }

    boolean getAndSetNeedsToLoadAdOnLayout(boolean value) {
        return this.needsToLoadAdOnLayout.getAndSet(value);
    }

    boolean getAndResetIsPrepared() {
        return this.getAdController().getAndResetIsPrepared();
    }

    private void onRequestError(String message) {
        this.getAdController().onRequestError(message);
    }

    boolean isParentViewMissingAtLoadTime() {
        return this.isParentViewMissingAtLoadTime;
    }

    void setIsParentViewMissingAtLoadTime() {
        this.isParentViewMissingAtLoadTime = this.getParent() == null;
    }

    void setIsParentViewMissingAtLoadTime(boolean parentViewMissingAtLoadTime) {
        this.isParentViewMissingAtLoadTime = parentViewMissingAtLoadTime;
    }

    void setActivityRootView() {
        Activity activity = ContextUtils.getContextAsActivity(this.context);
        if (activity == null) {
            this.logger.e("unable to set activity root view because the context did not contain an activity");
            return;
        }
        this.activityRootView = activity.getWindow().getDecorView().findViewById(0x1020002).getRootView();
    }

    boolean isActivityRootViewLayoutRequested() {
        return this.activityRootView.isLayoutRequested();
    }

    boolean isActivityRootViewNull() {
        return this.activityRootView == null;
    }

    int getActivityRootViewDimension(boolean isWidth) {
        return isWidth ? this.activityRootView.getWidth() : this.activityRootView.getHeight();
    }

    @Override
    public void setListener(AdListener adListener) {
        if (adListener == null) {
            adListener = new DefaultAdListener(LOGTAG);
        }
        this.adListenerExecutor = this.adListenerExecutorFactory.createAdListenerExecutor(adListener);
    }

    AdListenerExecutor getAdListenerExecutor() {
        return this.adListenerExecutor;
    }

    @Override
    public boolean isLoading() {
        AdController adController = this.getAdController();
        if (adController == null) {
            return false;
        }
        return this.getAdController().getAdState().equals((Object)AdState.LOADING);
    }

    public boolean isAdLoading() {
        return this.isLoading();
    }

    public void destroy() {
        if (!this.isInitialized()) {
            return;
        }
        this.logger.d("Destroying the AdLayout");
        this.isDestroyed = true;
        this.unregisterScreenStateBroadcastReceiver();
        this.getAdController().destroy();
    }

    public boolean showAd() {
        if (this.previousAdExpired.get()) {
            this.logger.w("This banner ad has expired. Please load another ad.");
            return false;
        }
        if (this.isReadyToShow()) {
            if (this.getAdController().isExpired()) {
                this.logger.w("This banner ad has expired. Please load another ad.");
                return false;
            }
            if (this.getAdController().startAdDrawing()) {
                if (!this.autoShow) {
                    this.getAdController().getMetricsCollector().stopMetric(Metrics.MetricType.AD_LOADED_TO_AD_SHOW_TIME);
                }
                this.getAdController().getMetricsCollector().startMetric(Metrics.MetricType.AD_SHOW_LATENCY);
                if (this.currentView != null) {
                    this.removeView(this.currentView);
                }
                if (this.currentDestroyable != null) {
                    this.currentDestroyable.destroy();
                }
                this.currentView = this.getAdController().getView();
                this.currentDestroyable = this.getAdController().getDestroyable();
                FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1, 17);
                this.addView(this.currentView, (ViewGroup.LayoutParams)layoutParams);
                this.getAdController().getMetricsCollector().startMetric(Metrics.MetricType.AD_SHOW_DURATION);
                this.adShown();
                return true;
            }
            this.logger.w("Banner ad could not be shown.");
            return false;
        }
        if (this.isLoading()) {
            this.logger.w("The banner ad cannot be shown because it is still loading.");
        } else if (this.isShowing()) {
            this.logger.w("The banner ad cannot be shown because it is already showing.");
        } else if (this.isReadyToLoad()) {
            this.logger.w("The banner ad cannot be shown because it has not loaded successfully.");
        } else {
            this.logger.w("A banner ad is not ready to show.");
        }
        return false;
    }

    public void enableAutoShow() {
        this.autoShow = true;
    }

    public void disableAutoShow() {
        this.autoShow = false;
    }

    static {
        boolean numberThreads = true;
        long keepAliveTimeSeconds = 60L;
        threadPool = new ScheduledThreadPoolExecutor(1);
        threadPool.setKeepAliveTime(60L, TimeUnit.SECONDS);
    }

    class AdLayoutAdControlCallback
    implements AdControlCallback {
        AdLayoutAdControlCallback() {
        }

        @Override
        public boolean isAdReady(boolean deferredLoad) {
            return AdLayout.this.prepareAd(deferredLoad);
        }

        @Override
        public void onAdLoaded(AdProperties adProperties) {
            AdLayout.this.properties = adProperties;
            AdLayout.this.getAdController().render();
        }

        @Override
        @SuppressLint(value={"InlinedApi"})
        public void onAdRendered() {
            if (AdLayout.this.autoShow) {
                if (AdLayout.this.showAd()) {
                    AdLayout.this.getAdListenerExecutor().onAdLoaded(AdLayout.this, AdLayout.this.properties);
                }
            } else {
                AdLayout.this.getAdController().getMetricsCollector().startMetric(Metrics.MetricType.AD_LOADED_TO_AD_SHOW_TIME);
                AdLayout.this.logger.d("Ad is ready to show. Please call showAd to display it.");
                AdLayout.this.getAdListenerExecutor().onAdLoaded(AdLayout.this, AdLayout.this.properties);
            }
        }

        @Override
        public void onAdFailed(AdError adError) {
            if (AdError.ErrorCode.NETWORK_TIMEOUT.equals((Object)adError.getCode())) {
                AdLayout.this.adController = null;
            }
            AdLayout.this.getAdListenerExecutor().onAdFailedToLoad(AdLayout.this, adError);
        }

        @Override
        public void onAdEvent(AdEvent event) {
            this.handleAdEvent(event);
        }

        boolean handleAdEvent(AdEvent event) {
            switch (event.getAdEventType()) {
                case EXPANDED: {
                    AdLayout.this.getAdListenerExecutor().onAdExpanded(AdLayout.this);
                    return true;
                }
                case CLOSED: {
                    AdLayout.this.getAdListenerExecutor().onAdCollapsed(AdLayout.this);
                    return true;
                }
                case RESIZED: {
                    Rect positionOnScreen = (Rect)event.getParameters().getParameter("positionOnScreen");
                    AdLayout.this.getAdListenerExecutor().onAdResized(AdLayout.this, positionOnScreen);
                    return true;
                }
            }
            return false;
        }

        @Override
        public int adClosing() {
            if (AdLayout.this.getAdController().getAdState().equals((Object)AdState.EXPANDED)) {
                return 0;
            }
            return 2;
        }

        @Override
        public void postAdRendered() {
        }

        @Override
        public void onAdExpired() {
            AdLayout.this.getAdController().getMetricsCollector().incrementMetric(Metrics.MetricType.AD_EXPIRED_BEFORE_SHOWING);
            AdLayout.this.previousAdExpired.set(true);
            AdLayout.this.adController = null;
            AdLayout.this.getAdListenerExecutor().onAdExpired(AdLayout.this);
        }
    }

    private static class OnLayoutChangeListenerUtil {
        private OnLayoutChangeListenerUtil() {
        }

        @TargetApi(value=11)
        protected static void setOnLayoutChangeListenerForRoot(final AdLayout adLayout) {
            View.OnLayoutChangeListener listener = new View.OnLayoutChangeListener(){

                public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                    if (adLayout.getAndSetNeedsToLoadAdOnLayout(false)) {
                        adLayout.setFloatingWindowDimensions();
                        adLayout.startAdLoadUponLayout();
                        adLayout.activityRootView.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
                    }
                }
            };
            adLayout.activityRootView.addOnLayoutChangeListener(listener);
        }
    }
}

