/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.device.ads.AAXCreative;
import com.amazon.device.ads.AdProperties;
import java.util.Iterator;
import java.util.Set;

class AdData
implements Iterable<AAXCreative> {
    private String instrPixelUrl;
    private String impPixelUrl;
    private String creative;
    private AdProperties properties;
    private Set<AAXCreative> creativeTypes;
    private int adHeight;
    private int adWidth;
    private boolean fetched;
    private long expirationTimeMs = -1L;
    static final String DEFAULT_METRICS_ENDPOINT = "https://fls-na.amazon.com/1/action-impressions/1/OE/mobile-ads-sas/action";

    protected String getCreative() {
        return this.creative;
    }

    protected void setCreative(String creative) {
        this.creative = creative;
    }

    protected AdProperties getProperties() {
        return this.properties;
    }

    protected void setProperties(AdProperties properties) {
        this.properties = properties;
    }

    protected Set<AAXCreative> getCreativeTypes() {
        return this.creativeTypes;
    }

    protected void setCreativeTypes(Set<AAXCreative> creativeTypes) {
        this.creativeTypes = creativeTypes;
    }

    protected String getInstrumentationPixelUrl() {
        return this.instrPixelUrl != null ? this.instrPixelUrl : DEFAULT_METRICS_ENDPOINT;
    }

    protected void setInstrumentationPixelUrl(String instrPixelUrl) {
        this.instrPixelUrl = instrPixelUrl;
    }

    protected String getImpressionPixelUrl() {
        return this.impPixelUrl;
    }

    protected void setImpressionPixelUrl(String impPixelUrl) {
        this.impPixelUrl = impPixelUrl;
    }

    public boolean getIsFetched() {
        return this.fetched;
    }

    public void setFetched(boolean fetched) {
        this.fetched = fetched;
    }

    protected void setHeight(int height) {
        this.adHeight = height;
    }

    public int getHeight() {
        return this.adHeight;
    }

    protected void setWidth(int width) {
        this.adWidth = width;
    }

    public int getWidth() {
        return this.adWidth;
    }

    protected void setExpirationTimeMillis(long expirationTimeMs) {
        this.expirationTimeMs = expirationTimeMs;
    }

    public boolean isExpired() {
        if (this.expirationTimeMs < 0L) {
            return false;
        }
        long time = System.currentTimeMillis();
        return time > this.expirationTimeMs;
    }

    public long getTimeToExpire() {
        long time = System.currentTimeMillis();
        return this.expirationTimeMs - time;
    }

    @Override
    public Iterator<AAXCreative> iterator() {
        return this.creativeTypes.iterator();
    }
}

